/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.IndyHandler;
import org.apidesign.vm4brwsr.InternalSig;
import org.apidesign.vm4brwsr.Variable;

class MetafactoryHandler
extends IndyHandler {
    MetafactoryHandler() {
        super("java/lang/invoke/LambdaMetafactory", "metafactory");
    }

    MetafactoryHandler(String clazz, String method) {
        super(clazz, method);
    }

    @Override
    protected boolean handle(IndyHandler.Ctx ctx) throws IOException {
        String convertMethod;
        String convertType;
        boolean isStatic;
        ByteCodeParser.CPX2 methodHandle = ctx.bm.clazz.getCpoolEntry(ctx.bm.args[1]);
        boolean isVirtual = false;
        boolean isConstructor = false;
        switch (methodHandle.cpx1) {
            case 6: {
                isStatic = true;
                break;
            }
            case 5: 
            case 9: {
                isVirtual = true;
            }
            case 7: {
                isStatic = false;
                break;
            }
            case 8: {
                isStatic = true;
                isConstructor = true;
                break;
            }
            default: {
                return false;
            }
        }
        String sig = ctx.mt[1];
        int typeEnd = sig.lastIndexOf(41);
        String typeSig = sig.substring(typeEnd + 1);
        if (!typeSig.startsWith("L") || !typeSig.endsWith(";")) {
            return false;
        }
        String type = typeSig.substring(1, typeSig.length() - 1);
        ctx.byteCodeToJavaScript.requireReference(type);
        String mangledType = InternalSig.mangleClassName(type);
        String interfaceToCreate = ctx.byteCodeToJavaScript.accessClassFalse(mangledType);
        InternalSig internalSig = InternalSig.find(null, sig);
        int fixedArgsCount = internalSig.getParameterCount();
        CharSequence[] vars = new CharSequence[fixedArgsCount];
        for (int j = fixedArgsCount - 1; j >= 0; --j) {
            vars[j] = ctx.stackMapper.popValue();
        }
        assert (internalSig.getMangledType().startsWith("L"));
        ctx.stackMapper.flush(ctx.out);
        Variable samVar = ctx.stackMapper.pushA();
        ctx.out.append("var ").append(samVar).append(" = ").append(interfaceToCreate).append(".constructor.$class.$lambda([");
        String sep = "";
        for (int j = 0; j < fixedArgsCount; ++j) {
            ctx.out.append(sep).append(vars[j]);
            sep = ", ";
        }
        ctx.out.append("], function(args1, args2) {\n");
        String[] methodInfoName = ctx.bm.clazz.getFieldInfoName(methodHandle.cpx2);
        ctx.byteCodeToJavaScript.requireReference(methodInfoName[0]);
        String mangledType2 = InternalSig.mangleClassName(methodInfoName[0]);
        InternalSig internalSig2 = InternalSig.find(methodInfoName[1], methodInfoName[2]);
        String mangledMethod = internalSig2.getJniName();
        for (int i = 0; i < internalSig2.getParameterCount(); ++i) {
            int index;
            String type2 = internalSig2.getJvmParameterType(i);
            if (type2.length() == 1) continue;
            if (type2.startsWith("L") && type2.endsWith(";")) {
                type2 = type2.substring(1, type2.length() - 1);
            }
            ctx.out.append("\n      ");
            int n = index = isStatic ? i : i + 1;
            if (index < fixedArgsCount) {
                ctx.byteCodeToJavaScript.generateCheckcast(ctx.out, type2, "args1[" + index + "]");
                continue;
            }
            ctx.byteCodeToJavaScript.generateCheckcast(ctx.out, type2, "args2[" + (index - fixedArgsCount) + "]");
        }
        String sep2 = "";
        ctx.out.append("\n      var type = ").append(ctx.byteCodeToJavaScript.accessClassFalse(mangledType2)).append(";");
        ctx.out.append("\n      var ret = ");
        if (isVirtual) {
            if (fixedArgsCount > 0) {
                ctx.out.append("args1[0]");
            } else {
                ctx.out.append("args2[0]");
            }
            ctx.out.append(".").append(mangledMethod).append('(');
        } else if (isConstructor) {
            ctx.out.append("new ").append(ctx.byteCodeToJavaScript.accessClass(mangledType2)).append(";");
            ctx.out.append("\n      type.constructor['").append(mangledMethod).append("'].call(ret");
            sep2 = ", ";
        } else {
            ctx.out.append("type.").append(mangledMethod);
            if (!isStatic) {
                ctx.out.append(".call(");
                if (fixedArgsCount > 0) {
                    ctx.out.append("args1[0]");
                } else {
                    ctx.out.append("args2[0]");
                }
                sep2 = ", ";
            } else {
                ctx.out.append('(');
            }
        }
        for (int i = 0; i < internalSig2.getParameterCount(); ++i) {
            int index = isStatic ? i : i + 1;
            ctx.out.append(sep2);
            if (index < fixedArgsCount) {
                ctx.out.append("args1[" + index + "]");
            } else {
                ctx.out.append("args2[" + (index - fixedArgsCount) + "]");
            }
            sep2 = ", ";
        }
        ctx.out.append(");");
        switch (internalSig2.getMangledType().charAt(0)) {
            case 'I': {
                convertType = "java_lang_Integer";
                convertMethod = "valueOf__Ljava_lang_Integer_2I";
                break;
            }
            case 'J': {
                convertType = "java_lang_Long";
                convertMethod = "valueOf__Ljava_lang_Long_2J";
                break;
            }
            case 'D': {
                convertType = "java_lang_Double";
                convertMethod = "valueOf__Ljava_lang_Double_2D";
                break;
            }
            case 'F': {
                convertType = "java_lang_Float";
                convertMethod = "valueOf__Ljava_lang_Float_2F";
                break;
            }
            case 'B': {
                convertType = "java_lang_Byte";
                convertMethod = "valueOf__Ljava_lang_Byte_2B";
                break;
            }
            case 'Z': {
                convertType = "java_lang_Boolean";
                convertMethod = "valueOf__Ljava_lang_Boolean_2Z";
                break;
            }
            case 'S': {
                convertType = "java_lang_Short";
                convertMethod = "valueOf__Ljava_lang_Short_2S";
                break;
            }
            case 'C': {
                convertType = "java_lang_Character";
                convertMethod = "valueOf__Ljava_lang_Character_2C";
                break;
            }
            case 'L': 
            case 'V': 
            case '[': {
                convertType = null;
                convertMethod = null;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected return type: " + internalSig2.getMangledType());
            }
        }
        if (convertType != null) {
            String jvmConvertType = convertType.replace('_', '/');
            ctx.byteCodeToJavaScript.requireReference(jvmConvertType);
            ctx.out.append("\n      ret = ").append(ctx.byteCodeToJavaScript.accessClassFalse(convertType));
            ctx.out.append(".").append(convertMethod).append("(ret);");
        }
        ctx.out.append("\n      return ret;");
        ctx.out.append("\n   });");
        return true;
    }
}

