/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Base64;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.vm4brwsr.Bck2Brwsr;
import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.ByteCodeToJavaScript;
import org.apidesign.vm4brwsr.ClassDataCache;
import org.apidesign.vm4brwsr.ClassPath;
import org.apidesign.vm4brwsr.ExportedSymbols;
import org.apidesign.vm4brwsr.InternalSig;
import org.apidesign.vm4brwsr.StringArray;
import org.apidesign.vm4brwsr.VMLazy;

abstract class VM
extends ByteCodeToJavaScript {
    protected final ClassDataCache classDataCache;
    private final Bck2Brwsr.Resources resources;
    private final ExportedSymbols exportedSymbols;
    private final StringBuilder invokerMethods;
    private final StringArray asBinary;
    int exportedCount;
    private StringArray scripts = new StringArray();
    private StringArray references = new StringArray();

    private VM(Appendable out, Bck2Brwsr.Resources resources, StringArray explicitlyExported, StringArray asBinary) {
        super(out);
        this.resources = resources;
        this.classDataCache = new ClassDataCache(resources);
        this.exportedSymbols = new ExportedSymbols(resources, explicitlyExported);
        this.invokerMethods = new StringBuilder();
        this.asBinary = asBinary;
    }

    @Override
    boolean debug(Appendable out, String msg) throws IOException {
        return false;
    }

    static void compile(Appendable out, Bck2Brwsr config) throws IOException {
        VM vm;
        String[] both = config.classes().toArray();
        StringArray fixedNames = new StringArray();
        boolean addThree = false;
        if (config.isExtension()) {
            vm = new Extension(out, config.getResources(), both, config.exported(), config.allResources(), config.classpath());
            addThree = true;
        } else {
            if (config.includeVM()) {
                fixedNames.add(VM.class.getName().replace('.', '/'));
                addThree = true;
            }
            vm = new Standalone(out, config.getResources(), config.exported(), config.allResources());
        }
        if (addThree) {
            fixedNames.add(Object.class.getName().replace('.', '/'));
            fixedNames.add(Class.class.getName().replace('.', '/'));
            fixedNames.add(ArithmeticException.class.getName().replace('.', '/'));
        }
        super.doCompile(out, fixedNames.addAndNew(both));
    }

    private void doCompile(Appendable out, StringArray names) throws IOException {
        this.generatePrologue(out);
        out.append("\n  var invoker = {};");
        out.append("\n  function registerClass(vm, name, fn) {");
        out.append("\n    if (!vm[name]) vm[name] = fn;");
        out.append("\n    return vm[name];");
        out.append("\n  }");
        this.generateBody(out, names);
        out.append(this.invokerMethods);
        for (String r : this.asBinary.toArray()) {
            out.append("\n  ").append(this.getExportsObject()).append("['registerResource']('");
            out.append(r).append("', '");
            InputStream is = this.resources.get(r);
            int avail = is.available();
            if (avail <= 0) {
                avail = 4096;
            }
            byte[] arr = new byte[avail];
            int offset = 0;
            while (true) {
                int len;
                if (offset == arr.length) {
                    byte[] tmp = new byte[arr.length * 2];
                    System.arraycopy(arr, 0, tmp, 0, arr.length);
                    arr = tmp;
                }
                if ((len = is.read(arr, offset, arr.length - offset)) == -1) break;
                offset += len;
            }
            if (offset != arr.length) {
                byte[] tmp = new byte[offset];
                System.arraycopy(arr, 0, tmp, 0, offset);
                arr = tmp;
            }
            out.append(VM.btoa(arr));
            out.append("');");
        }
        out.append("\n");
        this.generateEpilogue(out);
    }

    @JavaScriptBody(args={"arr"}, body="return btoa(arr);")
    private static String btoa(byte[] arr) {
        return Base64.getEncoder().encodeToString(arr);
    }

    protected abstract void generatePrologue(Appendable var1) throws IOException;

    protected abstract void generateEpilogue(Appendable var1) throws IOException;

    protected abstract String getExportsObject();

    protected abstract boolean isExternalClass(String var1);

    protected abstract void lazyReference(Appendable var1, String var2) throws IOException;

    @Override
    protected final void declareClass(Appendable out, ByteCodeParser.ClassData classData, String mangledName) throws IOException {
        if (this.exportedSymbols.isExported(classData)) {
            out.append("registerClass(").append(this.getExportsObject()).append(",'").append(mangledName).append("',").append(mangledName).append(")");
            ++this.exportedCount;
        } else {
            out.append(mangledName);
        }
    }

    protected String generateClass(Appendable out, String className) throws IOException {
        ByteCodeParser.ClassData classData = this.classDataCache.getClassData(className);
        if (classData == null) {
            throw new IOException("Can't find class " + className);
        }
        return this.compile(classData);
    }

    @Override
    protected void declaredField(Appendable out, ByteCodeParser.FieldData fieldData, String destObject, String mangledName) throws IOException {
        if (this.exportedSymbols.isExported(fieldData)) {
            this.exportMember(out, destObject, mangledName);
        }
    }

    @Override
    protected void declaredMethod(Appendable out, ByteCodeParser.MethodData methodData, String destObject, String mangledName) throws IOException {
        if (this.isHierarchyExported(methodData)) {
            this.exportMember(out, destObject, mangledName);
        }
    }

    private void exportMember(Appendable out, String destObject, String memberName) throws IOException {
        out.append("\n").append(destObject).append("['").append(memberName).append("'] = m;\n");
    }

    /*
     * WARNING - void declaration
     */
    private void generateBody(Appendable out, StringArray names) throws IOException {
        StringArray processed = new StringArray();
        StringArray initCode = new StringArray();
        StringArray skipClass = new StringArray();
        for (String baseClass : names.toArray()) {
            this.references.add(baseClass);
            while (true) {
                void var10_13;
                Object var10_12 = null;
                String[] stringArray = this.references.toArray();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String n2 = stringArray[i];
                    if (skipClass.contains(n2) || processed.contains(n2)) continue;
                    String string = n2;
                }
                if (var10_13 == null) break;
                InputStream is = this.resources.get((String)var10_13 + ".class");
                if (is == null) {
                    this.lazyReference(out, (String)var10_13);
                    skipClass.add((String)var10_13);
                    continue;
                }
                try {
                    String ic = this.generateClass(out, (String)var10_13);
                    processed.add((String)var10_13);
                    initCode.add(ic == null ? "" : ic);
                }
                catch (RuntimeException ex) {
                    throw new IOException("Error while compiling " + (String)var10_13 + "\n", ex);
                }
            }
            for (String resource : this.scripts.toArray()) {
                while (resource.startsWith("/")) {
                    resource = resource.substring(1);
                }
                this.requireResourceImpl(out, false, resource);
                this.asBinary.remove(resource);
            }
            this.scripts = new StringArray();
            StringArray stringArray = StringArray.asList(this.references.toArray());
            stringArray.reverse();
            for (String ic : stringArray.toArray()) {
                int indx = processed.indexOf(ic);
                if (indx < 0) continue;
                String theCode = initCode.toArray()[indx];
                if (!theCode.isEmpty()) {
                    out.append(theCode).append("\n");
                }
                initCode.toArray()[indx] = "";
            }
        }
    }

    final void requireResourceImpl(Appendable out, boolean useEval, String resource) throws IOException {
        InputStream emul = this.resources.get(resource);
        if (emul == null) {
            throw new IOException("Can't find " + resource);
        }
        out.append("\n// resource from ").append(resource).append("\n");
        out.append("\n");
        if (useEval) {
            out.append("(0 || eval)(\"");
        }
        try (InputStreamReader r = new InputStreamReader(emul, "UTF-8");){
            VM.readResource(useEval, r, out);
        }
        if (useEval) {
            out.append("\");");
        }
        out.append("\n");
    }

    private static void readResource(boolean escape, Reader emul, Appendable out) throws IOException {
        int ch;
        block7: while ((ch = emul.read()) != -1) {
            if (escape) {
                switch (ch) {
                    case 34: {
                        out.append("\\\"");
                        continue block7;
                    }
                    case 92: {
                        out.append("\\\\");
                        continue block7;
                    }
                    case 10: {
                        out.append("\\n\"\n + \"");
                        continue block7;
                    }
                    case 9: {
                        out.append("\\t");
                        continue block7;
                    }
                    case 13: {
                        out.append("\\r");
                        continue block7;
                    }
                }
                out.append((char)ch);
                continue;
            }
            out.append((char)ch);
        }
    }

    static String toString(String name) throws IOException {
        StringBuilder sb = new StringBuilder();
        return sb.toString().toString();
    }

    @Override
    protected boolean requireReference(String cn) {
        return this.references.addIfMissing(cn);
    }

    @Override
    protected void requireScript(String resourcePath) {
        this.scripts.add(resourcePath);
    }

    @Override
    String assignClass(String className) {
        return "vm." + className + " = ";
    }

    @Override
    String accessClass(String className) {
        return "vm." + className;
    }

    @Override
    protected ByteCodeParser.FieldData findField(String[] fieldInfoName) throws IOException {
        ByteCodeParser.FieldData field = this.classDataCache.findField(fieldInfoName[0], fieldInfoName[1], fieldInfoName[2]);
        return field != null && this.canAccessDirectly(field.cls) ? field : null;
    }

    @Override
    protected String accessField(String object, ByteCodeParser.FieldData field, String[] fieldInfoName) throws IOException {
        if (field != null && !field.isStatic()) {
            return "['fld_" + object + "_" + field.getName() + "']";
        }
        String mangledName = "_" + fieldInfoName[1];
        return this.accessNonVirtualMember(object, mangledName, field != null ? field.cls : null);
    }

    @Override
    protected String accessStaticMethod(String object, String mangledName, String[] fieldInfoName) throws IOException {
        ByteCodeParser.MethodData method = this.classDataCache.findMethod(fieldInfoName[0], fieldInfoName[1], fieldInfoName[2]);
        return this.accessNonVirtualMember(object, mangledName, method != null ? method.cls : null);
    }

    @Override
    protected String accessVirtualMethod(ByteCodeParser.ClassData caller, String object, String mangledName, String[] fieldInfoName, int params, String[] sep) throws IOException {
        ByteCodeParser.ClassData referencedClass = this.classDataCache.getClassData(fieldInfoName[0]);
        ByteCodeParser.MethodData method = this.classDataCache.findMethod(referencedClass, fieldInfoName[1], fieldInfoName[2]);
        if (method != null) {
            boolean classIsFinal;
            boolean methodIsPrivate;
            boolean bl = methodIsPrivate = (method.access & 2) != 0;
            if (methodIsPrivate && referencedClass != caller) {
                String mcn = InternalSig.mangleClassName(referencedClass.getClassName());
                String nestedClass = this.accessClassFalse(mcn);
                sep[0] = ", ";
                return nestedClass + "." + mangledName + ".call(" + object;
            }
            boolean methodIsFinal = (method.access & 0x10) != 0;
            boolean bl2 = classIsFinal = (referencedClass.getAccessFlags() & 0x10) != 0;
            if (!this.isExternalClass(method.cls.getClassName()) && (methodIsFinal || classIsFinal || !this.isHierarchyExported(method))) {
                return object + "." + mangledName + '(';
            }
        }
        return this.accessThroughInvoker(object, mangledName, params);
    }

    private String accessThroughInvoker(String object, String mangledName, int params) throws IOException {
        String def = "\n  invoker." + mangledName + " = function(target";
        if (this.invokerMethods.indexOf(def) == -1) {
            int j;
            this.invokerMethods.append(def);
            for (j = 1; j < params; ++j) {
                this.invokerMethods.append(", p").append(j);
            }
            this.invokerMethods.append(") {\n    return target['").append(mangledName).append("'](");
            for (j = 1; j < params; ++j) {
                if (j > 1) {
                    this.invokerMethods.append(",");
                }
                this.invokerMethods.append("p").append(j);
            }
            this.invokerMethods.append(");\n  };");
        }
        return "invoker." + mangledName + '(' + object + (params > 1 ? "," : "");
    }

    private boolean isHierarchyExported(ByteCodeParser.MethodData methodData) throws IOException {
        if (this.exportedSymbols.isExported(methodData)) {
            return true;
        }
        if ((methodData.access & 0xA) != 0) {
            return false;
        }
        ExportedMethodFinder exportedMethodFinder = new ExportedMethodFinder(this.exportedSymbols);
        this.classDataCache.findMethods(methodData.cls, methodData.getName(), methodData.getInternalSig(), exportedMethodFinder);
        return exportedMethodFinder.getFound() != null;
    }

    private boolean canAccessDirectly(ByteCodeParser.ClassData declaringClass) {
        if (declaringClass == null) {
            return false;
        }
        String className = declaringClass.getClassName();
        return !"java/lang/Object".equals(className) && !"java/lang/reflect/Array".equals(className) && !this.isExternalClass(className);
    }

    private String accessNonVirtualMember(String object, String mangledName, ByteCodeParser.ClassData declaringClass) {
        return this.canAccessDirectly(declaringClass) ? object + "." + mangledName : object + "['" + mangledName + "']";
    }

    static {
        boolean assertsOn = false;
        if (!$assertionsDisabled) {
            assertsOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsOn) {
            VMLazy.init();
            ClassPath.init();
        }
    }

    private static final class Extension
    extends VM {
        private final StringArray extensionClasses;
        private final StringArray classpath;

        private Extension(Appendable out, Bck2Brwsr.Resources resources, String[] extClassesArray, StringArray explicitlyExported, StringArray asBinary, StringArray classpath) throws IOException {
            super(out, resources, explicitlyExported, asBinary);
            this.extensionClasses = StringArray.asList(extClassesArray);
            this.classpath = classpath;
        }

        @Override
        protected void generatePrologue(Appendable out) throws IOException {
            out.append("bck2brwsr.register({\n  'magic' : 'melta'");
            if (this.classpath != null && this.classpath.toArray().length > 0) {
                out.append(",\n  'classpath' : [\n");
                String sep = "    ";
                for (String s : this.classpath.toArray()) {
                    out.append(sep).append("'").append(s).append("'");
                    sep = ",\n    ";
                }
                out.append("\n  ]");
            }
            out.append("\n}, function(exports) {\n  var vm = {};\n");
            out.append("  function link(n, assign) {\n    function replaceAll(s, o, n) {\n      var pos = 0;\n      for (;;) {\n         var indx = s.indexOf(o, pos);\n         if (indx === -1) {\n           return s;\n         }\n         pos = indx + n.length;\n         s = s.substring(0, indx) + n + s.substring(indx + o.length);\n      }\n    }\n    return function() {\n      var no_ = replaceAll(n, '_', '_1');\n      var cls = replaceAll(no_, '/', '_');\n      var dot = replaceAll(n, '/', '.');\n      exports.loadClass(dot);\n      assign(exports[cls]);\n      return exports[cls](arguments);\n    };\n  };\n");
        }

        @Override
        protected void generateEpilogue(Appendable out) throws IOException {
            out.append("});");
        }

        @Override
        String accessClass(String className) {
            if (this.extensionClasses.contains(className.replace('_', '/'))) {
                return className;
            }
            return super.accessClass(className);
        }

        @Override
        protected String generateClass(Appendable out, String className) throws IOException {
            if (this.isExternalClass(className)) {
                String cls = className.replace("_", "_1").replace('/', '_');
                out.append("\n").append(this.assignClass(cls)).append("link('").append(className).append("', function(f) { ").append(this.assignClass(cls)).append(" f; });");
                return null;
            }
            return super.generateClass(out, className);
        }

        @Override
        protected String getExportsObject() {
            return "exports";
        }

        @Override
        protected boolean isExternalClass(String className) {
            return !this.extensionClasses.contains(className);
        }

        @Override
        protected void lazyReference(Appendable out, String n) throws IOException {
            String cls = n.replace('/', '_');
            out.append("\nvm.").append(cls).append(" = function() {");
            out.append("\n  var instance = arguments.length == 0 || arguments[0] === true;");
            out.append("\n  delete vm.").append(cls).append(";");
            out.append("\n  return link('").append(n).append("', function(f) { vm.");
            out.append(cls).append(" = f;})(instance);");
            out.append("\n}");
        }

        @Override
        protected void requireResource(Appendable out, String resourcePath) throws IOException {
            this.requireResourceImpl(out, true, resourcePath);
            ((VM)this).asBinary.remove(resourcePath);
        }
    }

    private static final class Standalone
    extends VM {
        private Standalone(Appendable out, Bck2Brwsr.Resources resources, StringArray explicitlyExported, StringArray asBinary) {
            super(out, resources, explicitlyExported, asBinary);
        }

        @Override
        protected void generatePrologue(Appendable out) throws IOException {
            out.append("(function VM(global) {var fillInVMSkeleton = function(vm) {");
        }

        @Override
        protected void generateEpilogue(Appendable out) throws IOException {
            out.append("  return vm;\n  };\n  var extensions = [];\n  var importingScript = null;\n  function replaceAll(s, target, replacement) {\n    var pos = 0;\n    for (;;) {\n      var indx = s.indexOf(target, pos);\n      if (indx === -1) {\n        return s;\n      }\n      pos = indx + replacement.length;\n      s = s.substring(0, indx) + replacement + s.substring(indx + target.length);\n    }\n  }\n  function mangleClass(name) {\n    name = replaceAll(name, '_', '_1');\n    name = replaceAll(name, '.', '_');\n    return name;\n  };\n  var pending = [];\n  var pendingClasses = [];\n  function wrapJavaMethod(wrapper, m, method) {\n    wrapper[m] = function() {\n      return method.apply(null, arguments);\n    };\n    var underscores = m.indexOf('__');\n    if (underscores >= 0) {\n      var shortName = m.substring(0, underscores);\n      if (!wrapper[shortName]) {\n        wrapper[shortName] = wrapper[m];\n      }\n    }\n  }\n  function wrapAllMethods(wrapper, realClass) {\n    for (var m in realClass) {\n      var method = realClass[m];\n      if (method && (method['access'] & 8) === 8) {\n        wrapJavaMethod(wrapper, m, method);\n      }\n    }\n  }\n  function wrapJava(vm, clazz, callback, realClass) {\n    var wrapper = {\n    };\n    Object.defineProperty(wrapper, '__raw__', {\n      value : realClass\n    });\n    if (realClass) {\n      wrapAllMethods(wrapper, realClass)\n    }\n    if (!wrapper['invoke']) {\n      wrapper['invoke'] = function() {\n         return invokeMethod(vm, clazz, arguments);\n      }\n    }\n    if (typeof callback === 'function') {\n      callback(wrapper);\n    }\n    return wrapper;\n  }\n  function extensionLoaded(ev) {\n    var at = pending.indexOf(ev.target);\n    pending.splice(at, 1);\n    if (pending.length === 0) {\n      for (var i = 0; i < pendingClasses.length; i += 4) {\n        var vm = pendingClasses[i];\n        var clazz = pendingClasses[i + 1];\n        var args = pendingClasses[i + 2];\n        var callback = pendingClasses[i + 3];\n        invokeMethod(vm, clazz, args);\n        wrapJava(vm, clazz, callback);\n      }\n      pendingClasses = [];\n    }\n  }\n  function invokeMethod(vm, n, args) {\n    var clazz = vm.loadClass(n);\n    if (args) {\n      var seek = args[0];\n      var prefix = seek.indexOf('__') == -1 ? seek + '__' : seek;\n      args = Array.prototype.slice.call(args, 1);\n      var found = '';\n      for (var m in clazz) {\n        if (m.indexOf(prefix) === 0) {\n          var method = clazz[m];\n          if ((method['access'] & 8) === 8) {\n            return method.apply(null, args);\n          }\n        }\n        found += m.toString() + '\\n'\n      }\n      throw 'Cannot find ' + seek + ' in ' + n + ' found:\\n' + found;\n    }\n  }\n  function extensionError(ev) {\n    console.log('error loading ' + ev.target.src);\n    extensionLoaded(ev);\n  }\n  function loadExtension(url, registerScript) {\n      if (url.substring(url.length - 4) == '.jar') {\n          url = url.substring(0, url.length - 4) + '.js';\n      }\n      if (typeof document !== 'undefined') {\n          var script = document.createElement('script');\n          script.type = 'text/javascript';\n          script.src = url;\n          script.onload = extensionLoaded;\n          script.onerror = extensionError;\n          if (registerScript && !document['currentScript']) {\n              document['currentScript'] = script;\n          }\n          document.getElementsByTagName('head')[0].appendChild(script);\n          pending.push(script);\n      } else {\n          var previousScript = importingScript;\n          try {\n              importingScript = url;\n              importScripts(url);\n          } finally {\n              importingScript = previousScript;\n          }\n      }\n  }\n  global.bck2brwsr = function() {\n    var args = Array.prototype.slice.apply(arguments);\n    var resources = {};\n    function registerResource(n, a64) {\n      var frm = atob || window.atob;\n      var str = frm(a64);\n      var arr = [];\n      for (var i = 0; i < str.length; i++) {\n        var ch = str.charCodeAt(i) & 0xff;\n        if (ch > 127) ch -= 256;\n        arr.push(ch);\n      }\n      if (!resources[n]) resources[n] = [arr];\n      else resources[n].push(arr);\n    }\n    var vm = fillInVMSkeleton({ 'registerResource' : registerResource });\n    function initVM() {\n      var clsArray = vm['java_lang_reflect_Array'];\n      if (clsArray) clsArray(false);\n    }\n    for (var i = 0; i < extensions.length; ++i) {\n      extensions[i](vm);\n    }\n    vm['registerResource'] = null;\n    var knownExtensions = extensions.length;\n    var loader = {};\n    var classPath;\n    var loadBytes = function(name, skip) {\n      skip = typeof skip == 'number' ? skip : 0;\n      var arr = resources[name];\n      if (arr) {\n        var arrSize = arr.length;\n        if (skip < arrSize) return arr[skip];\n        skip -= arrSize;\n      } else {\n        var arrSize = 0;\n      };\n      for (var i = 0; i < args.length; i++) {\n        var at = args[i];\n        if(!at) continue;\n        var ret;\n        if (typeof at === 'string' && at.substring(at.length - 3) === '.js') {\n          loadExtension(at, true);\n          args[i] = null;\n        } else if (typeof at === 'function') ret = at(name, skip);\n        else {\n          if (classPath === undefined) {\n             classPath = null;\n             try {\n               classPath = vm.loadClass('org.apidesign.vm4brwsr.ClassPath');\n             } catch (err) {\n             }\n           }\n          if (!classPath) {\n            if (name !== 'org/apidesign/vm4brwsr/ClassPath.class') {\n              throw 'Core Java library not registered. Cannot load from ' + at;\n            }\n            ret = null;\n          } else {\n            ret = classPath['loadBytes___3BLjava_lang_String_2Ljava_lang_Object_2II'](name, args, i, skip);\n          }\n        }\n        if (ret) return ret;\n      }\n      while (knownExtensions < extensions.length) {\n        vm['registerResource'] = registerResource;\n        extensions[knownExtensions++](vm);\n        vm['registerResource'] = null;\n        initVM();\n      }\n      var arr = resources[name];\n      return (arr && arr.length > arrSize) ? arr[arrSize] : null;\n    }\n    var reload = function(name, arr, keep) {\n      if (!arr) throw 'Cannot find ' + name;\n      var err = null;\n      try {\n        var lazy = loadClass('org.apidesign.vm4brwsr.VMLazy');\n      } catch (e) {\n        err = e;\n      }\n      if (!lazy) {\n         throw 'No bck2brwsr VM module to compile ' + name + ':\\n' + err;\n      }\n      if (!keep) {\n        var attr = mangleClass(name);\n        delete vm[attr];\n      }\n      return lazy['load__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_String_2_3Ljava_lang_Object_2_3B']\n        (vm, name, args, arr);\n    };\n    var loadClass = function(name) {\n      var attr = mangleClass(name);\n      var fn = vm[attr];\n      if (fn) {\n         return fn(false);\n      };\n      try {\n        var arr = loadBytes(replaceAll(name, '.', '/') + '.class');\n        var newClazz = reload(name, arr, true);\n        return newClazz;\n      } catch (err) {\n        fn = vm[attr];\n        if (fn) return fn(false);\n        throw err;\n      }\n    }\n    if (vm['loadClass']) {\n      throw 'Cannot initialize the bck2brwsr VM twice!';\n    }\n    vm['loadClass'] = loadClass;\n    vm['_reload'] = reload;\n    vm['loadBytes'] = loadBytes;\n    initVM();\n    loader.loadClass = function(name, callback) {\n      if (pending.length === 0) {\n        try {\n          var c = loadClass(name, callback);\n          var w = wrapJava(vm, name, callback, c);\n          return w;\n        } catch (err) {\n          if (pending.length === 0) throw err;\n        }\n      }\n      pendingClasses.push(vm);\n      pendingClasses.push(name);\n      pendingClasses.push(null);\n      pendingClasses.push(callback);\n      return {\n        'invoke' : function() {\n          if (pending.length === 0) {\n            invokeMethod(vm, name, arguments);\n            return;\n          }\n          pendingClasses.push(vm);\n          pendingClasses.push(name);\n          pendingClasses.push(arguments);\n          pendingClasses.push(null);\n        }\n      };\n    }\n    return loader;\n  };\n");
            out.append("  global.bck2brwsr.register = function(config, extension) {\n    if (!config || config['magic'] !== 'melta') {\n      console.log('Will not register: ' + extension);\n      return false;\n    }\n    var csUrl = null;\n    if (typeof document === 'undefined') {\n      csUrl = importingScript;\n    } else {\n      var cs = document['currentScript'];\n      if (!cs) {\n        var all = document.getElementsByTagName('script');\n        var last = all.length;\n        while (--last >= 0 && !all[last].src) {\n        }\n        cs = all[last];\n      }\n      if (cs) {\n        csUrl = cs['src'];\n      }\n    }\n    var prefix = csUrl ? csUrl['replace'](/[^\\/]*$/,'') : '';\n    extensions.push(extension);\n    var cp = config['classpath'];\n    if (cp) for (var i = 0; i < cp.length; i++) {\n      loadExtension(prefix + cp[i], false);\n    }\n    return null;\n  };\n");
            out.append("}(this));");
        }

        @Override
        protected String getExportsObject() {
            return "vm";
        }

        @Override
        protected boolean isExternalClass(String className) {
            return false;
        }

        @Override
        protected void lazyReference(Appendable out, String n) throws IOException {
            String cls = n.replace('/', '_');
            String dot = n.replace('/', '.');
            out.append("\nvm.").append(cls).append(" = function() {");
            out.append("\n  var instance = arguments.length == 0 || arguments[0] === true;");
            out.append("\n  delete vm.").append(cls).append(";");
            out.append("\n  var c = vm.loadClass('").append(dot).append("');");
            out.append("\n  return vm.").append(cls).append("(instance);");
            out.append("\n}");
        }

        @Override
        protected void requireResource(Appendable out, String resourcePath) throws IOException {
            this.requireResourceImpl(out, true, resourcePath);
            ((VM)this).asBinary.remove(resourcePath);
        }
    }

    private final class ExportedMethodFinder
    implements ClassDataCache.TraversalCallback<ByteCodeParser.MethodData> {
        private final ExportedSymbols exportedSymbols;
        private ByteCodeParser.MethodData found;

        public ExportedMethodFinder(ExportedSymbols exportedSymbols) {
            this.exportedSymbols = exportedSymbols;
        }

        @Override
        public boolean traverse(ByteCodeParser.MethodData methodData) {
            try {
                if (this.exportedSymbols.isExported(methodData) || VM.this.isExternalClass(methodData.cls.getClassName())) {
                    this.found = methodData;
                    return false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }

        public ByteCodeParser.MethodData getFound() {
            return this.found;
        }
    }
}

