/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;

public class AbstractIndexWriter
extends HtmlDocletWriter {
    protected IndexBuilder indexbuilder;

    protected AbstractIndexWriter(ConfigurationImpl configuration, DocPath path, IndexBuilder indexbuilder) throws IOException {
        super(configuration, path);
        this.indexbuilder = indexbuilder;
    }

    @Override
    protected Content getNavLinkIndex() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.indexLabel);
        return li;
    }

    protected void addContents(Character uc, List<? extends Doc> memberlist, Content contentTree) {
        String unicode = uc.toString();
        contentTree.addContent(this.getMarkerAnchorForIndex(unicode));
        StringContent headContent = new StringContent(unicode);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, false, HtmlStyle.title, headContent);
        contentTree.addContent(heading);
        int memberListSize = memberlist.size();
        if (memberListSize > 0) {
            HtmlTree dl = new HtmlTree(HtmlTag.DL);
            for (int i = 0; i < memberListSize; ++i) {
                Doc element = memberlist.get(i);
                if (element instanceof MemberDoc) {
                    this.addDescription((MemberDoc)element, (Content)dl);
                    continue;
                }
                if (element instanceof ClassDoc) {
                    this.addDescription((ClassDoc)element, (Content)dl);
                    continue;
                }
                if (!(element instanceof PackageDoc)) continue;
                this.addDescription((PackageDoc)element, (Content)dl);
            }
            contentTree.addContent(dl);
        }
    }

    protected void addDescription(PackageDoc pkg, Content dlTree) {
        Content link = this.getPackageLink(pkg, new StringContent(Util.getPackageName(pkg)));
        HtmlTree dt = HtmlTree.DT(link);
        ((Content)dt).addContent(" - ");
        ((Content)dt).addContent(this.getResource("doclet.package"));
        ((Content)dt).addContent(" " + pkg.name());
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        this.addSummaryComment((Doc)pkg, dd);
        dlTree.addContent(dd);
    }

    protected void addDescription(ClassDoc cd, Content dlTree) {
        Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.INDEX, cd).strong(true));
        HtmlTree dt = HtmlTree.DT(link);
        ((Content)dt).addContent(" - ");
        this.addClassInfo(cd, dt);
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        this.addComment((ProgramElementDoc)cd, dd);
        dlTree.addContent(dd);
    }

    protected void addClassInfo(ClassDoc cd, Content contentTree) {
        contentTree.addContent(this.getResource("doclet.in", Util.getTypeName(this.configuration, cd, false), this.getPackageLink(cd.containingPackage(), Util.getPackageName(cd.containingPackage()))));
    }

    protected void addDescription(MemberDoc member, Content dlTree) {
        String name = member instanceof ExecutableMemberDoc ? member.name() + ((ExecutableMemberDoc)member).flatSignature() : member.name();
        HtmlTree span = HtmlTree.SPAN(HtmlStyle.memberNameLink, this.getDocLink(LinkInfoImpl.Kind.INDEX, member, name));
        HtmlTree dt = HtmlTree.DT(span);
        ((Content)dt).addContent(" - ");
        this.addMemberDesc(member, dt);
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        this.addComment((ProgramElementDoc)member, dd);
        dlTree.addContent(dd);
    }

    protected void addComment(ProgramElementDoc element, Content contentTree) {
        HtmlTree span = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.block);
        if (Util.isDeprecated((Doc)element)) {
            div.addContent(span);
            Tag[] tags = element.tags("deprecated");
            if (tags.length > 0) {
                this.addInlineDeprecatedComment((Doc)element, tags[0], div);
            }
            contentTree.addContent(div);
        } else {
            for (ClassDoc cont = element.containingClass(); cont != null; cont = cont.containingClass()) {
                if (!Util.isDeprecated((Doc)cont)) continue;
                div.addContent(span);
                contentTree.addContent(div);
                break;
            }
            this.addSummaryComment((Doc)element, contentTree);
        }
    }

    protected void addMemberDesc(MemberDoc member, Content contentTree) {
        ClassDoc containing = member.containingClass();
        String classdesc = Util.getTypeName(this.configuration, containing, true) + " ";
        if (member.isField()) {
            if (member.isStatic()) {
                contentTree.addContent(this.getResource("doclet.Static_variable_in", classdesc));
            } else {
                contentTree.addContent(this.getResource("doclet.Variable_in", classdesc));
            }
        } else if (member.isConstructor()) {
            contentTree.addContent(this.getResource("doclet.Constructor_for", classdesc));
        } else if (member.isMethod()) {
            if (member.isStatic()) {
                contentTree.addContent(this.getResource("doclet.Static_method_in", classdesc));
            } else {
                contentTree.addContent(this.getResource("doclet.Method_in", classdesc));
            }
        }
        this.addPreQualifiedClassLink(LinkInfoImpl.Kind.INDEX, containing, false, contentTree);
    }

    public Content getMarkerAnchorForIndex(String anchorNameForIndex) {
        return this.getMarkerAnchor(this.getNameForIndex(anchorNameForIndex), null);
    }

    public String getNameForIndex(String unicode) {
        return "I:" + this.getName(unicode);
    }
}

