/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.formats.html.AbstractPackageIndexWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.RawHtml;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;

public class PackageIndexFrameWriter
extends AbstractPackageIndexWriter {
    public PackageIndexFrameWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(ConfigurationImpl configuration) {
        DocPath filename = DocPaths.OVERVIEW_FRAME;
        try {
            PackageIndexFrameWriter packgen = new PackageIndexFrameWriter(configuration, filename);
            packgen.buildPackageIndexFile("doclet.Window_Overview", false);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    @Override
    protected void addPackagesList(PackageDoc[] packages, String text, String tableSummary, Content body) {
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, this.packagesLabel);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.indexContainer, heading);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.setTitle(this.packagesLabel);
        for (int i = 0; i < packages.length; ++i) {
            if (packages[i] == null || this.configuration.nodeprecated && Util.isDeprecated((Doc)packages[i])) continue;
            ul.addContent(this.getPackage(packages[i]));
        }
        ((Content)div).addContent(ul);
        body.addContent(div);
    }

    protected Content getPackage(PackageDoc pd) {
        Content packageLinkContent;
        if (pd.name().length() > 0) {
            Content packageLabel = this.getPackageLabel(pd.name());
            packageLinkContent = this.getHyperLink(this.pathString(pd, DocPaths.PACKAGE_FRAME), packageLabel, "", "packageFrame");
        } else {
            StringContent packageLabel = new StringContent("<unnamed package>");
            packageLinkContent = this.getHyperLink(DocPaths.PACKAGE_FRAME, (Content)packageLabel, "", "packageFrame");
        }
        HtmlTree li = HtmlTree.LI(packageLinkContent);
        return li;
    }

    @Override
    protected void addNavigationBarHeader(Content body) {
        RawHtml headerContent = this.configuration.packagesheader.length() > 0 ? new RawHtml(this.replaceDocRootDir(this.configuration.packagesheader)) : new RawHtml(this.replaceDocRootDir(this.configuration.header));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.bar, headerContent);
        body.addContent(heading);
    }

    @Override
    protected void addOverviewHeader(Content body) {
    }

    @Override
    protected void addAllClassesLink(Content div) {
        Content linkContent = this.getHyperLink(DocPaths.ALLCLASSES_FRAME, this.allclassesLabel, "", "packageFrame");
        HtmlTree span = HtmlTree.SPAN(linkContent);
        div.addContent(span);
    }

    @Override
    protected void addAllProfilesLink(Content div) {
        Content linkContent = this.getHyperLink(DocPaths.PROFILE_OVERVIEW_FRAME, this.allprofilesLabel, "", "packageListFrame");
        HtmlTree span = HtmlTree.SPAN(linkContent);
        div.addContent(span);
    }

    @Override
    protected void addNavigationBarFooter(Content body) {
        HtmlTree p = HtmlTree.P(this.getSpace());
        body.addContent(p);
    }
}

