/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.formats.html.AbstractTreeWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.ClassTree;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;

public class PackageTreeWriter
extends AbstractTreeWriter {
    protected PackageDoc packagedoc;
    protected PackageDoc prev;
    protected PackageDoc next;

    public PackageTreeWriter(ConfigurationImpl configuration, DocPath path, PackageDoc packagedoc, PackageDoc prev, PackageDoc next) throws IOException {
        super(configuration, path, new ClassTree(configuration.classDocCatalog.allClasses(packagedoc), (Configuration)configuration));
        this.packagedoc = packagedoc;
        this.prev = prev;
        this.next = next;
    }

    public static void generate(ConfigurationImpl configuration, PackageDoc pkg, PackageDoc prev, PackageDoc next, boolean noDeprecated) {
        DocPath path = DocPath.forPackage(pkg).resolve(DocPaths.PACKAGE_TREE);
        try {
            PackageTreeWriter packgen = new PackageTreeWriter(configuration, path, pkg, prev, next);
            packgen.generatePackageTreeFile();
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), path.getPath());
            throw new DocletAbortException(exc);
        }
    }

    protected void generatePackageTreeFile() throws IOException {
        Content body = this.getPackageTreeHeader();
        Content headContent = this.getResource("doclet.Hierarchy_For_Package", Util.getPackageName(this.packagedoc));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, false, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        if (this.configuration.packages.length > 1) {
            this.addLinkToMainTree(div);
        }
        body.addContent(div);
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.addTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy", divTree);
        this.addTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy", divTree);
        this.addTree(this.classtree.baseAnnotationTypes(), "doclet.Annotation_Type_Hierarchy", divTree);
        this.addTree(this.classtree.baseEnums(), "doclet.Enum_Hierarchy", divTree);
        body.addContent(divTree);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    protected Content getPackageTreeHeader() {
        String title = this.packagedoc.name() + " " + this.configuration.getText("doclet.Window_Class_Hierarchy");
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        return bodyTree;
    }

    protected void addLinkToMainTree(Content div) {
        HtmlTree span = HtmlTree.SPAN(HtmlStyle.packageHierarchyLabel, this.getResource("doclet.Package_Hierarchies"));
        div.addContent(span);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.horizontal);
        ul.addContent(this.getNavLinkMainTree(this.configuration.getText("doclet.All_Packages")));
        div.addContent(ul);
    }

    @Override
    protected Content getNavLinkPrevious() {
        if (this.prev == null) {
            return this.getNavLinkPrevious(null);
        }
        DocPath path = DocPath.relativePath(this.packagedoc, this.prev);
        return this.getNavLinkPrevious(path.resolve(DocPaths.PACKAGE_TREE));
    }

    @Override
    protected Content getNavLinkNext() {
        if (this.next == null) {
            return this.getNavLinkNext(null);
        }
        DocPath path = DocPath.relativePath(this.packagedoc, this.next);
        return this.getNavLinkNext(path.resolve(DocPaths.PACKAGE_TREE));
    }

    @Override
    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink(DocPaths.PACKAGE_SUMMARY, this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }
}

