/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.SectionName;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.RawHtml;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.ProfilePackageSummaryWriter;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;

public class ProfilePackageWriterImpl
extends HtmlDocletWriter
implements ProfilePackageSummaryWriter {
    protected PackageDoc prev;
    protected PackageDoc next;
    protected PackageDoc packageDoc;
    protected String profileName;
    protected int profileValue;

    public ProfilePackageWriterImpl(ConfigurationImpl configuration, PackageDoc packageDoc, PackageDoc prev, PackageDoc next, Profile profile) throws IOException {
        super(configuration, DocPath.forPackage(packageDoc).resolve(DocPaths.profilePackageSummary(profile.name)));
        this.prev = prev;
        this.next = next;
        this.packageDoc = packageDoc;
        this.profileName = profile.name;
        this.profileValue = profile.value;
    }

    @Override
    public Content getPackageHeader(String heading) {
        String pkgName = this.packageDoc.name();
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(pkgName));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.header);
        StringContent profileContent = new StringContent(this.profileName);
        HtmlTree profileNameDiv = HtmlTree.DIV(HtmlStyle.subTitle, profileContent);
        div.addContent(profileNameDiv);
        HtmlTree annotationContent = new HtmlTree(HtmlTag.P);
        this.addAnnotationInfo(this.packageDoc, (Content)annotationContent);
        div.addContent(annotationContent);
        HtmlTree tHeading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, this.packageLabel);
        ((Content)tHeading).addContent(this.getSpace());
        RawHtml packageHead = new RawHtml(heading);
        ((Content)tHeading).addContent(packageHead);
        div.addContent(tHeading);
        this.addDeprecationInfo(div);
        if (this.packageDoc.inlineTags().length > 0 && !this.configuration.nocomment) {
            HtmlTree docSummaryDiv = new HtmlTree(HtmlTag.DIV);
            docSummaryDiv.addStyle(HtmlStyle.docSummary);
            this.addSummaryComment((Doc)this.packageDoc, docSummaryDiv);
            div.addContent(docSummaryDiv);
            Content space = this.getSpace();
            Content descLink = this.getHyperLink(this.getDocLink(SectionName.PACKAGE_DESCRIPTION), this.descriptionLabel, "", "");
            HtmlTree descPara = new HtmlTree(HtmlTag.P, this.seeLabel, space, descLink);
            div.addContent(descPara);
        }
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    @Override
    public Content getContentHeader() {
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        return div;
    }

    public void addDeprecationInfo(Content div) {
        Tag[] deprs = this.packageDoc.tags("deprecated");
        if (Util.isDeprecated((Doc)this.packageDoc)) {
            Tag[] commentTags;
            HtmlTree deprDiv = new HtmlTree(HtmlTag.DIV);
            deprDiv.addStyle(HtmlStyle.deprecatedContent);
            HtmlTree deprPhrase = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            deprDiv.addContent(deprPhrase);
            if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                this.addInlineDeprecatedComment((Doc)this.packageDoc, deprs[0], deprDiv);
            }
            div.addContent(deprDiv);
        }
    }

    @Override
    public void addClassesSummary(ClassDoc[] classes, String label, String tableSummary, String[] tableHeader, Content packageSummaryContentTree) {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        li.addStyle(HtmlStyle.blockList);
        this.addClassesSummary(classes, label, tableSummary, tableHeader, li, this.profileValue);
        packageSummaryContentTree.addContent(li);
    }

    @Override
    public Content getSummaryHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    @Override
    public void addPackageDescription(Content packageContentTree) {
        if (this.packageDoc.inlineTags().length > 0) {
            packageContentTree.addContent(this.getMarkerAnchor(SectionName.PACKAGE_DESCRIPTION));
            StringContent h2Content = new StringContent(this.configuration.getText("doclet.Package_Description", this.packageDoc.name()));
            packageContentTree.addContent(HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, (Content)h2Content));
            this.addInlineComment((Doc)this.packageDoc, packageContentTree);
        }
    }

    @Override
    public void addPackageTags(Content packageContentTree) {
        this.addTagsInfo((Doc)this.packageDoc, packageContentTree);
    }

    @Override
    public void addPackageFooter(Content contentTree) {
        this.addNavLinks(false, contentTree);
        this.addBottom(contentTree);
    }

    @Override
    public void printDocument(Content contentTree) throws IOException {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.packageDoc), true, contentTree);
    }

    @Override
    protected Content getNavLinkClassUse() {
        Content useLink = this.getHyperLink(DocPaths.PACKAGE_USE, this.useLabel, "", "");
        HtmlTree li = HtmlTree.LI(useLink);
        return li;
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree li;
        if (this.prev == null) {
            li = HtmlTree.LI(this.prevpackageLabel);
        } else {
            DocPath path = DocPath.relativePath(this.packageDoc, this.prev);
            li = HtmlTree.LI(this.getHyperLink(path.resolve(DocPaths.profilePackageSummary(this.profileName)), this.prevpackageLabel, "", ""));
        }
        return li;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree li;
        if (this.next == null) {
            li = HtmlTree.LI(this.nextpackageLabel);
        } else {
            DocPath path = DocPath.relativePath(this.packageDoc, this.next);
            li = HtmlTree.LI(this.getHyperLink(path.resolve(DocPaths.profilePackageSummary(this.profileName)), this.nextpackageLabel, "", ""));
        }
        return li;
    }

    @Override
    protected Content getNavLinkTree() {
        Content useLink = this.getHyperLink(DocPaths.PACKAGE_TREE, this.treeLabel, "", "");
        HtmlTree li = HtmlTree.LI(useLink);
        return li;
    }

    @Override
    protected Content getNavLinkPackage() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.packageLabel);
        return li;
    }
}

