/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.tools.oldlets.formats.html.ClassWriterImpl;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.markup.ContentBuilder;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.RawHtml;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.builders.SerializedFormBuilder;
import com.sun.tools.oldlets.internal.toolkit.taglets.TagletWriter;
import com.sun.tools.oldlets.internal.toolkit.util.DocLink;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletConstants;
import com.sun.tools.oldlets.internal.toolkit.util.MessageRetriever;
import com.sun.tools.oldlets.internal.toolkit.util.Util;

public class TagletWriterImpl
extends TagletWriter {
    private final HtmlDocletWriter htmlWriter;
    private final ConfigurationImpl configuration;

    public TagletWriterImpl(HtmlDocletWriter htmlWriter, boolean isFirstSentence) {
        super(isFirstSentence);
        this.htmlWriter = htmlWriter;
        this.configuration = htmlWriter.configuration;
    }

    @Override
    public Content getOutputInstance() {
        return new ContentBuilder();
    }

    @Override
    protected Content codeTagOutput(Tag tag) {
        HtmlTree result = HtmlTree.CODE(new StringContent(Util.normalizeNewlines(tag.text())));
        return result;
    }

    @Override
    public Content getDocRootOutput() {
        String path = this.htmlWriter.pathToRoot.isEmpty() ? "." : this.htmlWriter.pathToRoot.getPath();
        return new StringContent(path);
    }

    @Override
    public Content deprecatedTagOutput(Doc doc) {
        ContentBuilder result = new ContentBuilder();
        Tag[] deprs = doc.tags("deprecated");
        if (doc instanceof ClassDoc) {
            if (Util.isDeprecated((Doc)((ProgramElementDoc)doc))) {
                Tag[] commentTags;
                result.addContent(HtmlTree.SPAN(HtmlStyle.deprecatedLabel, new StringContent(this.configuration.getText("doclet.Deprecated"))));
                result.addContent(RawHtml.nbsp);
                if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                    result.addContent(this.commentTagsToOutput(null, doc, deprs[0].inlineTags(), false));
                }
            }
        } else {
            MemberDoc member = (MemberDoc)doc;
            if (Util.isDeprecated((Doc)((ProgramElementDoc)doc))) {
                Content body;
                result.addContent(HtmlTree.SPAN(HtmlStyle.deprecatedLabel, new StringContent(this.configuration.getText("doclet.Deprecated"))));
                result.addContent(RawHtml.nbsp);
                if (deprs.length > 0 && !(body = this.commentTagsToOutput(null, doc, deprs[0].inlineTags(), false)).isEmpty()) {
                    result.addContent(HtmlTree.SPAN(HtmlStyle.deprecationComment, body));
                }
            } else if (Util.isDeprecated((Doc)member.containingClass())) {
                result.addContent(HtmlTree.SPAN(HtmlStyle.deprecatedLabel, new StringContent(this.configuration.getText("doclet.Deprecated"))));
                result.addContent(RawHtml.nbsp);
            }
        }
        return result;
    }

    @Override
    protected Content literalTagOutput(Tag tag) {
        StringContent result = new StringContent(Util.normalizeNewlines(tag.text()));
        return result;
    }

    @Override
    public MessageRetriever getMsgRetriever() {
        return this.configuration.message;
    }

    @Override
    public Content getParamHeader(String header) {
        HtmlTree result = HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.paramLabel, new StringContent(header)));
        return result;
    }

    @Override
    public Content paramTagOutput(ParamTag paramTag, String paramName) {
        ContentBuilder body = new ContentBuilder();
        body.addContent(HtmlTree.CODE(new RawHtml(paramName)));
        body.addContent(" - ");
        body.addContent(this.htmlWriter.commentTagsToContent((Tag)paramTag, null, paramTag.inlineTags(), false));
        HtmlTree result = HtmlTree.DD(body);
        return result;
    }

    @Override
    public Content propertyTagOutput(Tag tag, String prefix) {
        ContentBuilder body = new ContentBuilder();
        ((Content)body).addContent(new RawHtml(prefix));
        ((Content)body).addContent(" ");
        ((Content)body).addContent(HtmlTree.CODE(new RawHtml(tag.text())));
        ((Content)body).addContent(".");
        HtmlTree result = HtmlTree.P(body);
        return result;
    }

    @Override
    public Content returnTagOutput(Tag returnTag) {
        ContentBuilder result = new ContentBuilder();
        result.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.returnLabel, new StringContent(this.configuration.getText("doclet.Returns")))));
        result.addContent(HtmlTree.DD(this.htmlWriter.commentTagsToContent(returnTag, null, returnTag.inlineTags(), false)));
        return result;
    }

    @Override
    public Content seeTagOutput(Doc holder, SeeTag[] seeTags) {
        ContentBuilder body = new ContentBuilder();
        if (seeTags.length > 0) {
            for (int i = 0; i < seeTags.length; ++i) {
                this.appendSeparatorIfNotEmpty(body);
                body.addContent(this.htmlWriter.seeTagToContent(seeTags[i]));
            }
        }
        if (holder.isField() && ((FieldDoc)holder).constantValue() != null && this.htmlWriter instanceof ClassWriterImpl) {
            this.appendSeparatorIfNotEmpty(body);
            DocPath constantsPath = this.htmlWriter.pathToRoot.resolve(DocPaths.CONSTANT_VALUES);
            String whichConstant = ((ClassWriterImpl)this.htmlWriter).getClassDoc().qualifiedName() + "." + ((FieldDoc)holder).name();
            DocLink link = constantsPath.fragment(whichConstant);
            body.addContent(this.htmlWriter.getHyperLink(link, (Content)new StringContent(this.configuration.getText("doclet.Constants_Summary"))));
        }
        if (holder.isClass() && ((ClassDoc)holder).isSerializable() && SerializedFormBuilder.serialInclude(holder) && SerializedFormBuilder.serialInclude((Doc)((ClassDoc)holder).containingPackage())) {
            this.appendSeparatorIfNotEmpty(body);
            DocPath serialPath = this.htmlWriter.pathToRoot.resolve(DocPaths.SERIALIZED_FORM);
            DocLink link = serialPath.fragment(((ClassDoc)holder).qualifiedName());
            body.addContent(this.htmlWriter.getHyperLink(link, (Content)new StringContent(this.configuration.getText("doclet.Serialized_Form"))));
        }
        if (body.isEmpty()) {
            return body;
        }
        ContentBuilder result = new ContentBuilder();
        result.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.seeLabel, new StringContent(this.configuration.getText("doclet.See_Also")))));
        result.addContent(HtmlTree.DD(body));
        return result;
    }

    private void appendSeparatorIfNotEmpty(ContentBuilder body) {
        if (!body.isEmpty()) {
            body.addContent(", ");
            body.addContent(DocletConstants.NL);
        }
    }

    @Override
    public Content simpleTagOutput(Tag[] simpleTags, String header) {
        ContentBuilder result = new ContentBuilder();
        result.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.simpleTagLabel, new RawHtml(header))));
        ContentBuilder body = new ContentBuilder();
        for (int i = 0; i < simpleTags.length; ++i) {
            if (i > 0) {
                body.addContent(", ");
            }
            body.addContent(this.htmlWriter.commentTagsToContent(simpleTags[i], null, simpleTags[i].inlineTags(), false));
        }
        result.addContent(HtmlTree.DD(body));
        return result;
    }

    @Override
    public Content simpleTagOutput(Tag simpleTag, String header) {
        ContentBuilder result = new ContentBuilder();
        result.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.simpleTagLabel, new RawHtml(header))));
        Content body = this.htmlWriter.commentTagsToContent(simpleTag, null, simpleTag.inlineTags(), false);
        result.addContent(HtmlTree.DD(body));
        return result;
    }

    @Override
    public Content getThrowsHeader() {
        HtmlTree result = HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.throwsLabel, new StringContent(this.configuration.getText("doclet.Throws"))));
        return result;
    }

    @Override
    public Content throwsTagOutput(ThrowsTag throwsTag) {
        ContentBuilder body = new ContentBuilder();
        RawHtml excName = throwsTag.exceptionType() == null ? new RawHtml(throwsTag.exceptionName()) : this.htmlWriter.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, throwsTag.exceptionType()));
        body.addContent(HtmlTree.CODE(excName));
        Content desc = this.htmlWriter.commentTagsToContent((Tag)throwsTag, null, throwsTag.inlineTags(), false);
        if (desc != null && !desc.isEmpty()) {
            body.addContent(" - ");
            body.addContent(desc);
        }
        HtmlTree result = HtmlTree.DD(body);
        return result;
    }

    @Override
    public Content throwsTagOutput(Type throwsType) {
        HtmlTree result = HtmlTree.DD(HtmlTree.CODE(this.htmlWriter.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, throwsType))));
        return result;
    }

    @Override
    public Content valueTagOutput(FieldDoc field, String constantVal, boolean includeLink) {
        return includeLink ? this.htmlWriter.getDocLink(LinkInfoImpl.Kind.VALUE_TAG, (MemberDoc)field, constantVal, false) : new RawHtml(constantVal);
    }

    @Override
    public Content commentTagsToOutput(Tag holderTag, Tag[] tags) {
        return this.commentTagsToOutput(holderTag, null, tags, false);
    }

    @Override
    public Content commentTagsToOutput(Doc holderDoc, Tag[] tags) {
        return this.commentTagsToOutput(null, holderDoc, tags, false);
    }

    @Override
    public Content commentTagsToOutput(Tag holderTag, Doc holderDoc, Tag[] tags, boolean isFirstSentence) {
        return this.htmlWriter.commentTagsToContent(holderTag, holderDoc, tags, isFirstSentence);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }
}

