/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html.markup;

import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.DocletConstants;
import java.io.IOException;
import java.io.Writer;

public class RawHtml
extends Content {
    private String rawHtmlContent;
    public static final Content nbsp = new RawHtml("&nbsp;");

    public RawHtml(String rawHtml) {
        this.rawHtmlContent = RawHtml.nullCheck(rawHtml);
    }

    @Override
    public void addContent(Content content) {
        throw new DocletAbortException("not supported");
    }

    @Override
    public void addContent(String stringContent) {
        throw new DocletAbortException("not supported");
    }

    @Override
    public boolean isEmpty() {
        return this.rawHtmlContent.isEmpty();
    }

    @Override
    public String toString() {
        return this.rawHtmlContent;
    }

    @Override
    public int charCount() {
        return RawHtml.charCount(this.rawHtmlContent);
    }

    static int charCount(String htmlText) {
        State state = State.TEXT;
        int count = 0;
        block17: for (int i = 0; i < htmlText.length(); ++i) {
            char c = htmlText.charAt(i);
            switch (state) {
                case TEXT: {
                    switch (c) {
                        case '<': {
                            state = State.TAG;
                            continue block17;
                        }
                        case '&': {
                            state = State.ENTITY;
                            ++count;
                            continue block17;
                        }
                    }
                    ++count;
                    continue block17;
                }
                case ENTITY: {
                    if (Character.isLetterOrDigit(c)) continue block17;
                    state = State.TEXT;
                    continue block17;
                }
                case TAG: {
                    switch (c) {
                        case '\"': {
                            state = State.STRING;
                            break;
                        }
                        case '>': {
                            state = State.TEXT;
                        }
                    }
                    continue block17;
                }
                case STRING: {
                    switch (c) {
                        case '\"': {
                            state = State.TAG;
                        }
                    }
                }
            }
        }
        return count;
    }

    @Override
    public boolean write(Writer out, boolean atNewline) throws IOException {
        out.write(this.rawHtmlContent);
        return this.rawHtmlContent.endsWith(DocletConstants.NL);
    }

    private static enum State {
        TEXT,
        ENTITY,
        TAG,
        STRING;

    }
}

