/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Type;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.internal.toolkit.AnnotationTypeWriter;
import com.sun.tools.oldlets.internal.toolkit.ClassWriter;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.PropertyWriter;
import com.sun.tools.oldlets.internal.toolkit.WriterFactory;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.AnnotationTypeBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.AnnotationTypeFieldBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.AnnotationTypeOptionalMemberBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.AnnotationTypeRequiredMemberBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.ClassBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.ConstantsSummaryBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.ConstructorBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.EnumConstantBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.FieldBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.LayoutParser;
import com.sun.tools.oldlets.internal.toolkit.builders.MemberSummaryBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.MethodBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.PackageSummaryBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.ProfilePackageSummaryBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.ProfileSummaryBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.PropertyBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.SerializedFormBuilder;
import com.sun.tools.oldlets.internal.toolkit.util.ClassTree;
import java.util.HashSet;

public class BuilderFactory {
    private final Configuration configuration;
    private final WriterFactory writerFactory;
    private final AbstractBuilder.Context context;

    public BuilderFactory(Configuration configuration) {
        this.configuration = configuration;
        this.writerFactory = configuration.getWriterFactory();
        HashSet<String> containingPackagesSeen = new HashSet<String>();
        this.context = new AbstractBuilder.Context(configuration, containingPackagesSeen, LayoutParser.getInstance(configuration));
    }

    public AbstractBuilder getConstantsSummaryBuider() throws Exception {
        return ConstantsSummaryBuilder.getInstance(this.context, this.writerFactory.getConstantsSummaryWriter());
    }

    public AbstractBuilder getPackageSummaryBuilder(PackageDoc pkg, PackageDoc prevPkg, PackageDoc nextPkg) throws Exception {
        return PackageSummaryBuilder.getInstance(this.context, pkg, this.writerFactory.getPackageSummaryWriter(pkg, prevPkg, nextPkg));
    }

    public AbstractBuilder getProfileSummaryBuilder(Profile profile, Profile prevProfile, Profile nextProfile) throws Exception {
        return ProfileSummaryBuilder.getInstance(this.context, profile, this.writerFactory.getProfileSummaryWriter(profile, prevProfile, nextProfile));
    }

    public AbstractBuilder getProfilePackageSummaryBuilder(PackageDoc pkg, PackageDoc prevPkg, PackageDoc nextPkg, Profile profile) throws Exception {
        return ProfilePackageSummaryBuilder.getInstance(this.context, pkg, this.writerFactory.getProfilePackageSummaryWriter(pkg, prevPkg, nextPkg, profile), profile);
    }

    public AbstractBuilder getClassBuilder(ClassDoc classDoc, ClassDoc prevClass, ClassDoc nextClass, ClassTree classTree) throws Exception {
        return ClassBuilder.getInstance(this.context, classDoc, this.writerFactory.getClassWriter(classDoc, prevClass, nextClass, classTree));
    }

    public AbstractBuilder getAnnotationTypeBuilder(AnnotationTypeDoc annotationType, Type prevType, Type nextType) throws Exception {
        return AnnotationTypeBuilder.getInstance(this.context, annotationType, this.writerFactory.getAnnotationTypeWriter(annotationType, prevType, nextType));
    }

    public AbstractBuilder getMethodBuilder(ClassWriter classWriter) throws Exception {
        return MethodBuilder.getInstance(this.context, classWriter.getClassDoc(), this.writerFactory.getMethodWriter(classWriter));
    }

    public AbstractBuilder getAnnotationTypeFieldsBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return AnnotationTypeFieldBuilder.getInstance(this.context, (ClassDoc)annotationTypeWriter.getAnnotationTypeDoc(), this.writerFactory.getAnnotationTypeFieldWriter(annotationTypeWriter));
    }

    public AbstractBuilder getAnnotationTypeOptionalMemberBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return AnnotationTypeOptionalMemberBuilder.getInstance(this.context, (ClassDoc)annotationTypeWriter.getAnnotationTypeDoc(), this.writerFactory.getAnnotationTypeOptionalMemberWriter(annotationTypeWriter));
    }

    public AbstractBuilder getAnnotationTypeRequiredMemberBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return AnnotationTypeRequiredMemberBuilder.getInstance(this.context, (ClassDoc)annotationTypeWriter.getAnnotationTypeDoc(), this.writerFactory.getAnnotationTypeRequiredMemberWriter(annotationTypeWriter));
    }

    public AbstractBuilder getEnumConstantsBuilder(ClassWriter classWriter) throws Exception {
        return EnumConstantBuilder.getInstance(this.context, classWriter.getClassDoc(), this.writerFactory.getEnumConstantWriter(classWriter));
    }

    public AbstractBuilder getFieldBuilder(ClassWriter classWriter) throws Exception {
        return FieldBuilder.getInstance(this.context, classWriter.getClassDoc(), this.writerFactory.getFieldWriter(classWriter));
    }

    public AbstractBuilder getPropertyBuilder(ClassWriter classWriter) throws Exception {
        PropertyWriter propertyWriter = this.writerFactory.getPropertyWriter(classWriter);
        return PropertyBuilder.getInstance(this.context, classWriter.getClassDoc(), propertyWriter);
    }

    public AbstractBuilder getConstructorBuilder(ClassWriter classWriter) throws Exception {
        return ConstructorBuilder.getInstance(this.context, classWriter.getClassDoc(), this.writerFactory.getConstructorWriter(classWriter));
    }

    public AbstractBuilder getMemberSummaryBuilder(ClassWriter classWriter) throws Exception {
        return MemberSummaryBuilder.getInstance(classWriter, this.context);
    }

    public AbstractBuilder getMemberSummaryBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return MemberSummaryBuilder.getInstance(annotationTypeWriter, this.context);
    }

    public AbstractBuilder getSerializedFormBuilder() throws Exception {
        return SerializedFormBuilder.getInstance(this.context);
    }
}

