/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.oldlets.internal.toolkit.ConstructorWriter;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConstructorBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "ConstructorDetails";
    private int currentConstructorIndex;
    private final ClassDoc classDoc;
    private final VisibleMemberMap visibleMemberMap;
    private final ConstructorWriter writer;
    private final List<ProgramElementDoc> constructors;

    private ConstructorBuilder(AbstractBuilder.Context context, ClassDoc classDoc, ConstructorWriter writer) {
        super(context);
        this.classDoc = classDoc;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(classDoc, 3, this.configuration);
        this.constructors = new ArrayList<ProgramElementDoc>(this.visibleMemberMap.getMembersFor(classDoc));
        for (int i = 0; i < this.constructors.size(); ++i) {
            if (!this.constructors.get(i).isProtected() && !this.constructors.get(i).isPrivate()) continue;
            writer.setFoundNonPubConstructor(true);
        }
        if (this.configuration.getMemberComparator() != null) {
            Collections.sort(this.constructors, this.configuration.getMemberComparator());
        }
    }

    public static ConstructorBuilder getInstance(AbstractBuilder.Context context, ClassDoc classDoc, ConstructorWriter writer) {
        return new ConstructorBuilder(context, classDoc, writer);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.constructors.size() > 0;
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public ConstructorWriter getWriter() {
        return this.writer;
    }

    public void buildConstructorDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.constructors.size();
        if (size > 0) {
            Content constructorDetailsTree = this.writer.getConstructorDetailsTreeHeader(this.classDoc, memberDetailsTree);
            this.currentConstructorIndex = 0;
            while (this.currentConstructorIndex < size) {
                Content constructorDocTree = this.writer.getConstructorDocTreeHeader((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), constructorDetailsTree);
                this.buildChildren(node, constructorDocTree);
                constructorDetailsTree.addContent(this.writer.getConstructorDoc(constructorDocTree, this.currentConstructorIndex == size - 1));
                ++this.currentConstructorIndex;
            }
            memberDetailsTree.addContent(this.writer.getConstructorDetails(constructorDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content constructorDocTree) {
        constructorDocTree.addContent(this.writer.getSignature((ConstructorDoc)this.constructors.get(this.currentConstructorIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content constructorDocTree) {
        this.writer.addDeprecated((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), constructorDocTree);
    }

    public void buildConstructorComments(XMLNode node, Content constructorDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), constructorDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content constructorDocTree) {
        this.writer.addTags((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), constructorDocTree);
    }
}

