/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.EnumConstantWriter;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EnumConstantBuilder
extends AbstractMemberBuilder {
    private final ClassDoc classDoc;
    private final VisibleMemberMap visibleMemberMap;
    private final EnumConstantWriter writer;
    private final List<ProgramElementDoc> enumConstants;
    private int currentEnumConstantsIndex;

    private EnumConstantBuilder(AbstractBuilder.Context context, ClassDoc classDoc, EnumConstantWriter writer) {
        super(context);
        this.classDoc = classDoc;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(classDoc, 1, this.configuration);
        this.enumConstants = new ArrayList<ProgramElementDoc>(this.visibleMemberMap.getMembersFor(classDoc));
        if (this.configuration.getMemberComparator() != null) {
            Collections.sort(this.enumConstants, this.configuration.getMemberComparator());
        }
    }

    public static EnumConstantBuilder getInstance(AbstractBuilder.Context context, ClassDoc classDoc, EnumConstantWriter writer) {
        return new EnumConstantBuilder(context, classDoc, writer);
    }

    @Override
    public String getName() {
        return "EnumConstantDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.enumConstants.size() > 0;
    }

    public void buildEnumConstant(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.enumConstants.size();
        if (size > 0) {
            Content enumConstantsDetailsTree = this.writer.getEnumConstantsDetailsTreeHeader(this.classDoc, memberDetailsTree);
            this.currentEnumConstantsIndex = 0;
            while (this.currentEnumConstantsIndex < size) {
                Content enumConstantsTree = this.writer.getEnumConstantsTreeHeader((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), enumConstantsDetailsTree);
                this.buildChildren(node, enumConstantsTree);
                enumConstantsDetailsTree.addContent(this.writer.getEnumConstants(enumConstantsTree, this.currentEnumConstantsIndex == size - 1));
                ++this.currentEnumConstantsIndex;
            }
            memberDetailsTree.addContent(this.writer.getEnumConstantsDetails(enumConstantsDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content enumConstantsTree) {
        enumConstantsTree.addContent(this.writer.getSignature((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content enumConstantsTree) {
        this.writer.addDeprecated((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), enumConstantsTree);
    }

    public void buildEnumConstantComments(XMLNode node, Content enumConstantsTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), enumConstantsTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content enumConstantsTree) {
        this.writer.addTags((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), enumConstantsTree);
    }

    public EnumConstantWriter getWriter() {
        return this.writer;
    }
}

