/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import com.sun.tools.oldlets.internal.toolkit.util.ClassTree;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ClassUseMapper {
    private final ClassTree classtree;
    public Map<String, Set<PackageDoc>> classToPackage = new HashMap<String, Set<PackageDoc>>();
    public Map<String, List<PackageDoc>> classToPackageAnnotations = new HashMap<String, List<PackageDoc>>();
    public Map<String, Set<ClassDoc>> classToClass = new HashMap<String, Set<ClassDoc>>();
    public Map<String, List<ClassDoc>> classToSubclass = new HashMap<String, List<ClassDoc>>();
    public Map<String, List<ClassDoc>> classToSubinterface = new HashMap<String, List<ClassDoc>>();
    public Map<String, List<ClassDoc>> classToImplementingClass = new HashMap<String, List<ClassDoc>>();
    public Map<String, List<FieldDoc>> classToField = new HashMap<String, List<FieldDoc>>();
    public Map<String, List<MethodDoc>> classToMethodReturn = new HashMap<String, List<MethodDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToMethodArgs = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToMethodThrows = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToConstructorArgs = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToConstructorThrows = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ConstructorDoc>> classToConstructorAnnotations = new HashMap<String, List<ConstructorDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToConstructorParamAnnotation = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToConstructorDocArgTypeParam = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ClassDoc>> classToClassTypeParam = new HashMap<String, List<ClassDoc>>();
    public Map<String, List<ClassDoc>> classToClassAnnotations = new HashMap<String, List<ClassDoc>>();
    public Map<String, List<MethodDoc>> classToExecMemberDocTypeParam = new HashMap<String, List<MethodDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToExecMemberDocArgTypeParam = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<MethodDoc>> classToExecMemberDocAnnotations = new HashMap<String, List<MethodDoc>>();
    public Map<String, List<MethodDoc>> classToExecMemberDocReturnTypeParam = new HashMap<String, List<MethodDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToExecMemberDocParamAnnotation = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<FieldDoc>> classToFieldDocTypeParam = new HashMap<String, List<FieldDoc>>();
    public Map<String, List<FieldDoc>> annotationToFieldDoc = new HashMap<String, List<FieldDoc>>();

    public ClassUseMapper(RootDoc root, ClassTree classtree) {
        this.classtree = classtree;
        Iterator<ClassDoc> it = classtree.baseclasses().iterator();
        while (it.hasNext()) {
            this.subclasses(it.next());
        }
        it = classtree.baseinterfaces().iterator();
        while (it.hasNext()) {
            this.implementingClasses(it.next());
        }
        ClassDoc[] classes = root.classes();
        for (int i = 0; i < classes.length; ++i) {
            PackageDoc pkg = classes[i].containingPackage();
            this.mapAnnotations(this.classToPackageAnnotations, pkg, pkg);
            ClassDoc cd = classes[i];
            this.mapTypeParameters(this.classToClassTypeParam, cd, cd);
            this.mapAnnotations(this.classToClassAnnotations, cd, cd);
            FieldDoc[] fields = cd.fields();
            for (int j = 0; j < fields.length; ++j) {
                FieldDoc fd = fields[j];
                this.mapTypeParameters(this.classToFieldDocTypeParam, fd, fd);
                this.mapAnnotations(this.annotationToFieldDoc, fd, fd);
                if (fd.type().isPrimitive()) continue;
                this.add(this.classToField, fd.type().asClassDoc(), fd);
            }
            ConstructorDoc[] cons = cd.constructors();
            for (int j = 0; j < cons.length; ++j) {
                this.mapAnnotations(this.classToConstructorAnnotations, cons[j], cons[j]);
                this.mapExecutable((ExecutableMemberDoc)cons[j]);
            }
            MethodDoc[] meths = cd.methods();
            for (int j = 0; j < meths.length; ++j) {
                MethodDoc md = meths[j];
                this.mapExecutable((ExecutableMemberDoc)md);
                this.mapTypeParameters(this.classToExecMemberDocTypeParam, md, md);
                this.mapAnnotations(this.classToExecMemberDocAnnotations, md, md);
                if (md.returnType().isPrimitive() || md.returnType() instanceof TypeVariable) continue;
                this.mapTypeParameters(this.classToExecMemberDocReturnTypeParam, md.returnType(), md);
                this.add(this.classToMethodReturn, md.returnType().asClassDoc(), md);
            }
        }
    }

    private Collection<ClassDoc> subclasses(ClassDoc cd) {
        TreeSet<ClassDoc> ret = (TreeSet<ClassDoc>)((Object)this.classToSubclass.get(cd.qualifiedName()));
        if (ret == null) {
            ret = new TreeSet<ClassDoc>();
            List<ClassDoc> subs = this.classtree.subclasses(cd);
            if (subs != null) {
                ret.addAll(subs);
                Iterator<ClassDoc> it = subs.iterator();
                while (it.hasNext()) {
                    ret.addAll(this.subclasses(it.next()));
                }
            }
            this.addAll(this.classToSubclass, cd, ret);
        }
        return ret;
    }

    private Collection<ClassDoc> subinterfaces(ClassDoc cd) {
        TreeSet<ClassDoc> ret = (TreeSet<ClassDoc>)((Object)this.classToSubinterface.get(cd.qualifiedName()));
        if (ret == null) {
            ret = new TreeSet<ClassDoc>();
            List<ClassDoc> subs = this.classtree.subinterfaces(cd);
            if (subs != null) {
                ret.addAll(subs);
                Iterator<ClassDoc> it = subs.iterator();
                while (it.hasNext()) {
                    ret.addAll(this.subinterfaces(it.next()));
                }
            }
            this.addAll(this.classToSubinterface, cd, ret);
        }
        return ret;
    }

    private Collection<ClassDoc> implementingClasses(ClassDoc cd) {
        TreeSet<ClassDoc> ret = (TreeSet<ClassDoc>)((Object)this.classToImplementingClass.get(cd.qualifiedName()));
        if (ret == null) {
            Iterator<ClassDoc> it;
            ret = new TreeSet<ClassDoc>();
            List<ClassDoc> impl = this.classtree.implementingclasses(cd);
            if (impl != null) {
                ret.addAll(impl);
                it = impl.iterator();
                while (it.hasNext()) {
                    ret.addAll(this.subclasses(it.next()));
                }
            }
            it = this.subinterfaces(cd).iterator();
            while (it.hasNext()) {
                ret.addAll(this.implementingClasses(it.next()));
            }
            this.addAll(this.classToImplementingClass, cd, ret);
        }
        return ret;
    }

    private void mapExecutable(ExecutableMemberDoc em) {
        Parameter[] params = em.parameters();
        boolean isConstructor = em.isConstructor();
        ArrayList<Type> classArgs = new ArrayList<Type>();
        for (int k = 0; k < params.length; ++k) {
            Type pcd = params[k].type();
            if (!(params[k].type().isPrimitive() || classArgs.contains(pcd) || pcd instanceof TypeVariable)) {
                this.add(isConstructor ? this.classToConstructorArgs : this.classToMethodArgs, pcd.asClassDoc(), em);
                classArgs.add(pcd);
                this.mapTypeParameters(isConstructor ? this.classToConstructorDocArgTypeParam : this.classToExecMemberDocArgTypeParam, pcd, em);
            }
            this.mapAnnotations(isConstructor ? this.classToConstructorParamAnnotation : this.classToExecMemberDocParamAnnotation, params[k], em);
        }
        ClassDoc[] thr = em.thrownExceptions();
        for (int k = 0; k < thr.length; ++k) {
            this.add(isConstructor ? this.classToConstructorThrows : this.classToMethodThrows, thr[k], em);
        }
    }

    private <T> List<T> refList(Map<String, List<T>> map, ClassDoc cd) {
        List<T> list = map.get(cd.qualifiedName());
        if (list == null) {
            ArrayList<T> l = new ArrayList<T>();
            list = l;
            map.put(cd.qualifiedName(), list);
        }
        return list;
    }

    private Set<PackageDoc> packageSet(ClassDoc cd) {
        Set<PackageDoc> pkgSet = this.classToPackage.get(cd.qualifiedName());
        if (pkgSet == null) {
            pkgSet = new TreeSet<PackageDoc>();
            this.classToPackage.put(cd.qualifiedName(), pkgSet);
        }
        return pkgSet;
    }

    private Set<ClassDoc> classSet(ClassDoc cd) {
        Set<ClassDoc> clsSet = this.classToClass.get(cd.qualifiedName());
        if (clsSet == null) {
            TreeSet<ClassDoc> s = new TreeSet<ClassDoc>();
            clsSet = s;
            this.classToClass.put(cd.qualifiedName(), clsSet);
        }
        return clsSet;
    }

    private <T extends ProgramElementDoc> void add(Map<String, List<T>> map, ClassDoc cd, T ref) {
        this.refList(map, cd).add(ref);
        this.packageSet(cd).add(ref.containingPackage());
        this.classSet(cd).add(ref instanceof MemberDoc ? ((MemberDoc)ref).containingClass() : (ClassDoc)ref);
    }

    private void addAll(Map<String, List<ClassDoc>> map, ClassDoc cd, Collection<ClassDoc> refs) {
        if (refs == null) {
            return;
        }
        this.refList(map, cd).addAll(refs);
        Set<PackageDoc> pkgSet = this.packageSet(cd);
        Set<ClassDoc> clsSet = this.classSet(cd);
        for (ClassDoc cls : refs) {
            pkgSet.add(cls.containingPackage());
            clsSet.add(cls);
        }
    }

    private <T extends ProgramElementDoc> void mapTypeParameters(Map<String, List<T>> map, Object doc, T holder) {
        TypeVariable[] typeVariables;
        if (doc instanceof ClassDoc) {
            typeVariables = ((ClassDoc)doc).typeParameters();
        } else {
            if (doc instanceof WildcardType) {
                Type[] extendsBounds = ((WildcardType)doc).extendsBounds();
                for (int k = 0; k < extendsBounds.length; ++k) {
                    this.addTypeParameterToMap(map, extendsBounds[k], holder);
                }
                Type[] superBounds = ((WildcardType)doc).superBounds();
                for (int k = 0; k < superBounds.length; ++k) {
                    this.addTypeParameterToMap(map, superBounds[k], holder);
                }
                return;
            }
            if (doc instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)doc).typeArguments();
                for (int k = 0; k < typeArguments.length; ++k) {
                    this.addTypeParameterToMap(map, typeArguments[k], holder);
                }
                return;
            }
            if (doc instanceof ExecutableMemberDoc) {
                typeVariables = ((ExecutableMemberDoc)doc).typeParameters();
            } else {
                if (doc instanceof FieldDoc) {
                    Type fieldType = ((FieldDoc)doc).type();
                    this.mapTypeParameters(map, fieldType, holder);
                    return;
                }
                return;
            }
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            Type[] bounds = typeVariables[i].bounds();
            for (int j = 0; j < bounds.length; ++j) {
                this.addTypeParameterToMap(map, bounds[j], holder);
            }
        }
    }

    private <T extends ProgramElementDoc> void mapAnnotations(Map<String, List<T>> map, Object doc, T holder) {
        AnnotationDesc[] annotations;
        boolean isPackage = false;
        if (doc instanceof ProgramElementDoc) {
            annotations = ((ProgramElementDoc)doc).annotations();
        } else if (doc instanceof PackageDoc) {
            annotations = ((PackageDoc)doc).annotations();
            isPackage = true;
        } else if (doc instanceof Parameter) {
            annotations = ((Parameter)doc).annotations();
        } else {
            throw new DocletAbortException("should not happen");
        }
        for (int i = 0; i < annotations.length; ++i) {
            AnnotationTypeDoc annotationDoc = annotations[i].annotationType();
            if (isPackage) {
                this.refList(map, (ClassDoc)annotationDoc).add(holder);
                continue;
            }
            this.add(map, (ClassDoc)annotationDoc, holder);
        }
    }

    private <T extends PackageDoc> void mapAnnotations(Map<String, List<T>> map, PackageDoc doc, T holder) {
        AnnotationDesc[] annotations = doc.annotations();
        for (int i = 0; i < annotations.length; ++i) {
            AnnotationTypeDoc annotationDoc = annotations[i].annotationType();
            this.refList(map, (ClassDoc)annotationDoc).add(holder);
        }
    }

    private <T extends ProgramElementDoc> void addTypeParameterToMap(Map<String, List<T>> map, Type type, T holder) {
        if (type instanceof ClassDoc) {
            this.add(map, (ClassDoc)type, holder);
        } else if (type instanceof ParameterizedType) {
            this.add(map, ((ParameterizedType)type).asClassDoc(), holder);
        }
        this.mapTypeParameters(map, type, holder);
    }
}

