/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.DocFile;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.PathDocFileFactory;
import com.sun.tools.oldlets.internal.toolkit.util.StandardDocFileFactory;
import java.util.Map;
import java.util.WeakHashMap;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;

abstract class DocFileFactory {
    private static final Map<Configuration, DocFileFactory> factories = new WeakHashMap<Configuration, DocFileFactory>();
    protected Configuration configuration;

    static synchronized DocFileFactory getFactory(Configuration configuration) {
        DocFileFactory f = factories.get(configuration);
        if (f == null) {
            JavaFileManager fm = configuration.getFileManager();
            if (fm instanceof StandardJavaFileManager) {
                f = new StandardDocFileFactory(configuration);
            } else {
                try {
                    Class<?> pathFileManagerClass = Class.forName("com.sun.tools.javac.nio.PathFileManager");
                    if (pathFileManagerClass.isAssignableFrom(fm.getClass())) {
                        f = new PathDocFileFactory(configuration);
                    }
                }
                catch (Throwable t) {
                    throw new IllegalStateException(t);
                }
            }
            factories.put(configuration, f);
        }
        return f;
    }

    protected DocFileFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    abstract DocFile createFileForDirectory(String var1);

    abstract DocFile createFileForInput(String var1);

    abstract DocFile createFileForOutput(DocPath var1);

    abstract Iterable<DocFile> list(JavaFileManager.Location var1, DocPath var2);
}

