/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.DocFile;
import com.sun.tools.oldlets.internal.toolkit.util.DocFileFactory;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

class SimpleDocFileFactory
extends DocFileFactory {
    public SimpleDocFileFactory(Configuration configuration) {
        super(configuration);
    }

    @Override
    public DocFile createFileForDirectory(String file) {
        return new SimpleDocFile(new File(file));
    }

    @Override
    public DocFile createFileForInput(String file) {
        return new SimpleDocFile(new File(file));
    }

    @Override
    public DocFile createFileForOutput(DocPath path) {
        return new SimpleDocFile(DocumentationTool.Location.DOCUMENTATION_OUTPUT, path);
    }

    @Override
    Iterable<DocFile> list(JavaFileManager.Location location, DocPath path) {
        if (location != StandardLocation.SOURCE_PATH) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<DocFile> files = new LinkedHashSet<DocFile>();
        for (String s : this.configuration.sourcepath.split(File.pathSeparator)) {
            File f;
            if (s.isEmpty() || !(f = new File(s)).isDirectory() || !(f = new File(f, path.getPath())).exists()) continue;
            files.add(new SimpleDocFile(f));
        }
        return files;
    }

    class SimpleDocFile
    extends DocFile {
        private File file;

        private SimpleDocFile(File file) {
            super(SimpleDocFileFactory.this.configuration);
            this.file = file;
        }

        private SimpleDocFile(JavaFileManager.Location location, DocPath path) {
            super(SimpleDocFileFactory.this.configuration, location, path);
            String destDirName = SimpleDocFileFactory.this.configuration.destDirName;
            this.file = destDirName.isEmpty() ? new File(path.getPath()) : new File(destDirName, path.getPath());
        }

        @Override
        public InputStream openInputStream() throws FileNotFoundException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }

        @Override
        public OutputStream openOutputStream() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            this.createDirectoryForFile(this.file);
            return new BufferedOutputStream(new FileOutputStream(this.file));
        }

        @Override
        public Writer openWriter() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            this.createDirectoryForFile(this.file);
            FileOutputStream fos = new FileOutputStream(this.file);
            if (SimpleDocFileFactory.this.configuration.docencoding == null) {
                return new BufferedWriter(new OutputStreamWriter(fos));
            }
            return new BufferedWriter(new OutputStreamWriter((OutputStream)fos, SimpleDocFileFactory.this.configuration.docencoding));
        }

        @Override
        public boolean canRead() {
            return this.file.canRead();
        }

        @Override
        public boolean canWrite() {
            return this.file.canRead();
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }

        @Override
        public boolean isAbsolute() {
            return this.file.isAbsolute();
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.file.isFile();
        }

        @Override
        public boolean isSameFile(DocFile other) {
            if (!(other instanceof SimpleDocFile)) {
                return false;
            }
            try {
                return this.file.exists() && this.file.getCanonicalFile().equals(((SimpleDocFile)other).file.getCanonicalFile());
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public Iterable<DocFile> list() {
            ArrayList<DocFile> files = new ArrayList<DocFile>();
            for (File f : this.file.listFiles()) {
                files.add(new SimpleDocFile(f));
            }
            return files;
        }

        @Override
        public boolean mkdirs() {
            return this.file.mkdirs();
        }

        @Override
        public DocFile resolve(DocPath p) {
            return this.resolve(p.getPath());
        }

        @Override
        public DocFile resolve(String p) {
            if (this.location == null && this.path == null) {
                return new SimpleDocFile(new File(this.file, p));
            }
            return new SimpleDocFile(this.location, this.path.resolve(p));
        }

        @Override
        public DocFile resolveAgainst(JavaFileManager.Location locn) {
            if (locn != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalArgumentException();
            }
            return new SimpleDocFile(new File(SimpleDocFileFactory.this.configuration.destDirName, this.file.getPath()));
        }

        private void createDirectoryForFile(File file) {
            File dir = file.getParentFile();
            if (dir == null || dir.exists() || dir.mkdirs()) {
                return;
            }
            SimpleDocFileFactory.this.configuration.message.error("doclet.Unable_to_create_directory_0", dir.getPath());
            throw new DocletAbortException("can't create directory");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DocFile[");
            if (this.location != null) {
                sb.append("locn:").append(this.location).append(",");
            }
            if (this.path != null) {
                sb.append("path:").append(this.path.getPath()).append(",");
            }
            sb.append("file:").append(this.file);
            sb.append("]");
            return sb.toString();
        }
    }
}

