/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.javadoc.codesnippet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.tools.oldlets.formats.html.HtmlDoclet;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apidesign.javadoc.codesnippet.Snippets;

public final class Doclet {
    private static Snippets snippets;

    private Doclet() {
    }

    public static boolean start(RootDoc root) {
        for (ClassDoc classDoc : root.classes()) {
            snippets.fixCodesnippets((Doc)root, (Doc)classDoc);
            for (MethodDoc methodDoc : classDoc.methods()) {
                snippets.fixCodesnippets((Doc)classDoc, (Doc)methodDoc);
            }
            for (MethodDoc methodDoc : classDoc.fields()) {
                snippets.fixCodesnippets((Doc)classDoc, (Doc)methodDoc);
            }
            for (MethodDoc methodDoc : classDoc.constructors()) {
                snippets.fixCodesnippets((Doc)classDoc, (Doc)methodDoc);
            }
            if (!(classDoc instanceof AnnotationTypeDoc)) continue;
            for (MethodDoc methodDoc : ((AnnotationTypeDoc)classDoc).elements()) {
                snippets.fixCodesnippets((Doc)classDoc, (Doc)methodDoc);
            }
        }
        for (ClassDoc classDoc : root.specifiedPackages()) {
            snippets.fixCodesnippets((Doc)root, (Doc)classDoc);
        }
        RootDoc rootProxy = Doclet.hideElements(RootDoc.class, root);
        return HtmlDoclet.start(rootProxy);
    }

    public static int optionLength(String option) {
        if (option.equals("-snippetpath")) {
            return 2;
        }
        if (option.equals("-snippetclasses")) {
            return 2;
        }
        if (option.equals("-maxLineLength")) {
            return 2;
        }
        if (option.equals("-verifysincepresent")) {
            return 1;
        }
        if (option.equals("-verifysince")) {
            return 2;
        }
        if (option.equals("-hiddingannotation")) {
            return 2;
        }
        return HtmlDoclet.optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        snippets = new Snippets(reporter);
        for (String[] optionAndParams : options) {
            int i;
            Boolean visible = null;
            if (optionAndParams[0].equals("-sourcepath")) {
                visible = true;
            }
            if (optionAndParams[0].equals("-snippetpath")) {
                visible = false;
            }
            if (visible != null) {
                for (i = 1; i < optionAndParams.length; ++i) {
                    for (String elem : optionAndParams[i].split(File.pathSeparator)) {
                        snippets.addPath(Doclet.findAbsolutePath(elem), visible);
                    }
                }
            }
            if (optionAndParams[0].equals("-snippetclasses")) {
                for (i = 1; i < optionAndParams.length; ++i) {
                    snippets.addClasses(optionAndParams[i]);
                }
            }
            if (optionAndParams[0].equals("-maxLineLength") && optionAndParams.length > 1) {
                snippets.setMaxLineLength(optionAndParams[1]);
            }
            if (optionAndParams[0].equals("-verifysincepresent") || optionAndParams[0].equals("-verifysince")) {
                if (optionAndParams.length > 1) {
                    snippets.setVerifySince(optionAndParams[1]);
                } else {
                    snippets.setVerifySince("");
                }
            }
            if (optionAndParams[0].equals("-hiddingannotation")) {
                snippets.addHiddenAnnotation(optionAndParams[1]);
            }
            if (!optionAndParams[0].equals("-encoding")) continue;
            snippets.setEncoding(optionAndParams[1]);
        }
        return HtmlDoclet.validOptions(options, reporter);
    }

    private static Path findAbsolutePath(String elem) {
        File file = new File(elem);
        if (file.isAbsolute()) {
            return file.toPath();
        }
        for (File root = new File(".").getAbsoluteFile(); !file.exists() && root != null; root = root.getParentFile()) {
            file = new File(root, elem);
        }
        return file.getAbsoluteFile().toPath();
    }

    public static LanguageVersion languageVersion() {
        return HtmlDoclet.languageVersion();
    }

    private static <T> T hideElement(Class<T> clazz, Object obj) {
        return Doclet.hideElements(clazz, clazz.cast(obj));
    }

    private static <T> T hideElements(Class<T> clazz, T obj) {
        if (!Doclet.toBeHiddenInterface(clazz)) {
            return obj;
        }
        Class<Object> c = clazz;
        if (clazz.isAssignableFrom(ClassDoc.class) && obj instanceof ClassDoc && ((ClassDoc)obj).isAnnotationType()) {
            c = AnnotationTypeDoc.class;
        }
        if (clazz.isAssignableFrom(SeeTag.class) && obj instanceof SeeTag) {
            c = SeeTag.class;
        }
        DocProxy<T> h = new DocProxy<T>(obj);
        return clazz.cast(Proxy.newProxyInstance(obj.getClass().getClassLoader(), new Class[]{c}, h));
    }

    private static boolean toBeHiddenInterface(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.getPackage() == RootDoc.class.getPackage()) {
            return true;
        }
        for (Class<?> interfce : type.getInterfaces()) {
            if (!Doclet.toBeHiddenInterface(interfce)) continue;
            return true;
        }
        return Doclet.toBeHiddenInterface(type.getSuperclass());
    }

    private static class DocProxy<T>
    implements InvocationHandler,
    Callable<T> {
        private final T obj;

        public DocProxy(T obj) {
            this.obj = obj;
        }

        @Override
        public T call() {
            return this.obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> componentType;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) continue;
                    InvocationHandler handler = null;
                    try {
                        handler = Proxy.getInvocationHandler(args[i]);
                    }
                    catch (IllegalArgumentException ignore) {
                        continue;
                    }
                    if (!(handler instanceof DocProxy)) continue;
                    args[i] = ((DocProxy)handler).obj;
                }
            }
            boolean doSkip = true;
            if (method.getName().equals("allClasses")) {
                doSkip = false;
            }
            Object ret = method.invoke(this.obj, args);
            Class<?> requestedType = method.getReturnType();
            if (requestedType.isArray() && Doclet.toBeHiddenInterface(componentType = requestedType.getComponentType())) {
                Object[] arr = (Object[])ret;
                ArrayList<Object> copy = new ArrayList<Object>();
                for (Object element : arr) {
                    boolean skip = false;
                    for (String name : this.findAnnotationsNames(element)) {
                        if (!snippets.isHiddingAnnotation(name)) continue;
                        skip = doSkip;
                        break;
                    }
                    if (skip) continue;
                    copy.add(Doclet.hideElement(componentType, element));
                }
                Object[] reqArr = (Object[])Array.newInstance(requestedType.getComponentType(), 0);
                return copy.toArray(reqArr);
            }
            if (ret instanceof Object && Doclet.toBeHiddenInterface(ret.getClass())) {
                ret = Doclet.hideElement(ret.getClass().getInterfaces()[0], ret);
            }
            return ret;
        }

        private AnnotationDesc[] findAnnotations(Object element) {
            if (element instanceof ProgramElementDoc) {
                ProgramElementDoc ped = (ProgramElementDoc)element;
                return ped.annotations();
            }
            if (element instanceof PackageDoc) {
                return ((PackageDoc)element).annotations();
            }
            return new AnnotationDesc[0];
        }

        private Iterable<String> findAnnotationsNames(Object element) {
            TreeSet<String> names = new TreeSet<String>();
            for (AnnotationDesc desc : this.findAnnotations(element)) {
                try {
                    String name = desc.annotationType().qualifiedName();
                    names.add(name);
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                }
            }
            return names;
        }
    }
}

