/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.RawHtml;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import java.io.IOException;
import org.apidesign.javadoc.codesnippet.impl.Profiles;

public abstract class AbstractProfileIndexWriter
extends HtmlDocletWriter {
    protected Profiles profiles;

    public AbstractProfileIndexWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
        this.profiles = configuration.profiles;
    }

    protected abstract void addNavigationBarHeader(Content var1);

    protected abstract void addNavigationBarFooter(Content var1);

    protected abstract void addOverviewHeader(Content var1);

    protected abstract void addProfilesList(Profiles var1, String var2, String var3, Content var4);

    protected abstract void addProfilePackagesList(Profiles var1, String var2, String var3, Content var4, String var5);

    protected void buildProfileIndexFile(String title, boolean includeScript) throws IOException {
        String windowOverview = this.configuration.getText(title);
        HtmlTree body = this.getBody(includeScript, this.getWindowTitle(windowOverview));
        this.addNavigationBarHeader(body);
        this.addOverviewHeader(body);
        this.addIndex(body);
        this.addOverview(body);
        this.addNavigationBarFooter(body);
        this.printHtmlDocument(this.configuration.metakeywords.getOverviewMetaKeywords(title, this.configuration.doctitle), includeScript, body);
    }

    protected void buildProfilePackagesIndexFile(String title, boolean includeScript, String profileName) throws IOException {
        String windowOverview = this.configuration.getText(title);
        HtmlTree body = this.getBody(includeScript, this.getWindowTitle(windowOverview));
        this.addNavigationBarHeader(body);
        this.addOverviewHeader(body);
        this.addProfilePackagesIndex(body, profileName);
        this.addOverview(body);
        this.addNavigationBarFooter(body);
        this.printHtmlDocument(this.configuration.metakeywords.getOverviewMetaKeywords(title, this.configuration.doctitle), includeScript, body);
    }

    protected void addOverview(Content body) throws IOException {
    }

    protected void addIndex(Content body) {
        this.addIndexContents(this.profiles, "doclet.Profile_Summary", this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Profile_Summary"), this.configuration.getText("doclet.profiles")), body);
    }

    protected void addProfilePackagesIndex(Content body, String profileName) {
        this.addProfilePackagesIndexContents(this.profiles, "doclet.Profile_Summary", this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Profile_Summary"), this.configuration.getText("doclet.profiles")), body, profileName);
    }

    protected void addIndexContents(Profiles profiles, String text, String tableSummary, Content body) {
        if (profiles.getProfileCount() > 0) {
            HtmlTree div = new HtmlTree(HtmlTag.DIV);
            div.addStyle(HtmlStyle.indexHeader);
            this.addAllClassesLink(div);
            this.addAllPackagesLink(div);
            body.addContent(div);
            this.addProfilesList(profiles, text, tableSummary, body);
        }
    }

    protected void addProfilePackagesIndexContents(Profiles profiles, String text, String tableSummary, Content body, String profileName) {
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.indexHeader);
        this.addAllClassesLink(div);
        this.addAllPackagesLink(div);
        this.addAllProfilesLink(div);
        body.addContent(div);
        this.addProfilePackagesList(profiles, text, tableSummary, body, profileName);
    }

    protected void addConfigurationTitle(Content body) {
        if (this.configuration.doctitle.length() > 0) {
            RawHtml title = new RawHtml(this.configuration.doctitle);
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.title, (Content)title);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
            body.addContent(div);
        }
    }

    @Override
    protected Content getNavLinkContents() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.overviewLabel);
        return li;
    }

    protected void addAllClassesLink(Content div) {
    }

    protected void addAllPackagesLink(Content div) {
    }

    protected void addAllProfilesLink(Content div) {
    }
}

