/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.ConstructorWriterImpl;
import com.sun.tools.oldlets.formats.html.FieldWriterImpl;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.MethodWriterImpl;
import com.sun.tools.oldlets.formats.html.NestedClassWriterImpl;
import com.sun.tools.oldlets.formats.html.PackageUseWriter;
import com.sun.tools.oldlets.formats.html.SubWriterHolderWriter;
import com.sun.tools.oldlets.formats.html.markup.ContentBuilder;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.ClassTree;
import com.sun.tools.oldlets.internal.toolkit.util.ClassUseMapper;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClassUseWriter
extends SubWriterHolderWriter {
    final ClassDoc classdoc;
    Set<PackageDoc> pkgToPackageAnnotations = null;
    final Map<String, List<ProgramElementDoc>> pkgToClassTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToClassAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToMethodTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToMethodArgTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToMethodReturnTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToMethodAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToMethodParameterAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToFieldTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToFieldAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToSubclass;
    final Map<String, List<ProgramElementDoc>> pkgToSubinterface;
    final Map<String, List<ProgramElementDoc>> pkgToImplementingClass;
    final Map<String, List<ProgramElementDoc>> pkgToField;
    final Map<String, List<ProgramElementDoc>> pkgToMethodReturn;
    final Map<String, List<ProgramElementDoc>> pkgToMethodArgs;
    final Map<String, List<ProgramElementDoc>> pkgToMethodThrows;
    final Map<String, List<ProgramElementDoc>> pkgToConstructorAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToConstructorParameterAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToConstructorArgs;
    final Map<String, List<ProgramElementDoc>> pkgToConstructorArgTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToConstructorThrows;
    final SortedSet<PackageDoc> pkgSet;
    final MethodWriterImpl methodSubWriter;
    final ConstructorWriterImpl constrSubWriter;
    final FieldWriterImpl fieldSubWriter;
    final NestedClassWriterImpl classSubWriter;
    final String classUseTableSummary;
    final String subclassUseTableSummary;
    final String subinterfaceUseTableSummary;
    final String fieldUseTableSummary;
    final String methodUseTableSummary;
    final String constructorUseTableSummary;

    public ClassUseWriter(ConfigurationImpl configuration, ClassUseMapper mapper, DocPath filename, ClassDoc classdoc) throws IOException {
        super(configuration, filename);
        this.classdoc = classdoc;
        if (mapper.classToPackageAnnotations.containsKey(classdoc.qualifiedName())) {
            this.pkgToPackageAnnotations = new TreeSet<PackageDoc>((Collection)mapper.classToPackageAnnotations.get(classdoc.qualifiedName()));
        }
        configuration.currentcd = classdoc;
        this.pkgSet = new TreeSet<PackageDoc>();
        this.pkgToClassTypeParameter = this.pkgDivide(mapper.classToClassTypeParam);
        this.pkgToClassAnnotations = this.pkgDivide(mapper.classToClassAnnotations);
        this.pkgToMethodTypeParameter = this.pkgDivide(mapper.classToExecMemberDocTypeParam);
        this.pkgToMethodArgTypeParameter = this.pkgDivide(mapper.classToExecMemberDocArgTypeParam);
        this.pkgToFieldTypeParameter = this.pkgDivide(mapper.classToFieldDocTypeParam);
        this.pkgToFieldAnnotations = this.pkgDivide(mapper.annotationToFieldDoc);
        this.pkgToMethodReturnTypeParameter = this.pkgDivide(mapper.classToExecMemberDocReturnTypeParam);
        this.pkgToMethodAnnotations = this.pkgDivide(mapper.classToExecMemberDocAnnotations);
        this.pkgToMethodParameterAnnotations = this.pkgDivide(mapper.classToExecMemberDocParamAnnotation);
        this.pkgToSubclass = this.pkgDivide(mapper.classToSubclass);
        this.pkgToSubinterface = this.pkgDivide(mapper.classToSubinterface);
        this.pkgToImplementingClass = this.pkgDivide(mapper.classToImplementingClass);
        this.pkgToField = this.pkgDivide(mapper.classToField);
        this.pkgToMethodReturn = this.pkgDivide(mapper.classToMethodReturn);
        this.pkgToMethodArgs = this.pkgDivide(mapper.classToMethodArgs);
        this.pkgToMethodThrows = this.pkgDivide(mapper.classToMethodThrows);
        this.pkgToConstructorAnnotations = this.pkgDivide(mapper.classToConstructorAnnotations);
        this.pkgToConstructorParameterAnnotations = this.pkgDivide(mapper.classToConstructorParamAnnotation);
        this.pkgToConstructorArgs = this.pkgDivide(mapper.classToConstructorArgs);
        this.pkgToConstructorArgTypeParameter = this.pkgDivide(mapper.classToConstructorDocArgTypeParam);
        this.pkgToConstructorThrows = this.pkgDivide(mapper.classToConstructorThrows);
        if (this.pkgSet.size() > 0 && mapper.classToPackage.containsKey(classdoc.qualifiedName()) && !this.pkgSet.equals(mapper.classToPackage.get(classdoc.qualifiedName()))) {
            configuration.root.printWarning("Internal error: package sets don't match: " + this.pkgSet + " with: " + mapper.classToPackage.get(classdoc.qualifiedName()));
        }
        this.methodSubWriter = new MethodWriterImpl(this);
        this.constrSubWriter = new ConstructorWriterImpl(this);
        this.fieldSubWriter = new FieldWriterImpl(this);
        this.classSubWriter = new NestedClassWriterImpl(this);
        this.classUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.classes"));
        this.subclassUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.subclasses"));
        this.subinterfaceUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.subinterfaces"));
        this.fieldUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.fields"));
        this.methodUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.methods"));
        this.constructorUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.constructors"));
    }

    public static void generate(ConfigurationImpl configuration, ClassTree classtree) {
        ClassUseMapper mapper = new ClassUseMapper(configuration.root, classtree);
        ClassDoc[] classes = configuration.root.classes();
        for (int i = 0; i < classes.length; ++i) {
            if (configuration.nodeprecated && Util.isDeprecated(classes[i].containingPackage())) continue;
            ClassUseWriter.generate(configuration, mapper, classes[i]);
        }
        PackageDoc[] pkgs = configuration.packages;
        for (int i = 0; i < pkgs.length; ++i) {
            if (configuration.nodeprecated && Util.isDeprecated(pkgs[i])) continue;
            PackageUseWriter.generate(configuration, mapper, pkgs[i]);
        }
    }

    private Map<String, List<ProgramElementDoc>> pkgDivide(Map<String, ? extends List<? extends ProgramElementDoc>> classMap) {
        HashMap<String, List<ProgramElementDoc>> map = new HashMap<String, List<ProgramElementDoc>>();
        List<? extends ProgramElementDoc> list = classMap.get(this.classdoc.qualifiedName());
        if (list != null) {
            Collections.sort(list);
            for (ProgramElementDoc programElementDoc : list) {
                PackageDoc pkg = programElementDoc.containingPackage();
                this.pkgSet.add(pkg);
                ArrayList<ProgramElementDoc> inPkg = (ArrayList<ProgramElementDoc>)map.get(pkg.name());
                if (inPkg == null) {
                    inPkg = new ArrayList<ProgramElementDoc>();
                    map.put(pkg.name(), inPkg);
                }
                inPkg.add(programElementDoc);
            }
        }
        return map;
    }

    public static void generate(ConfigurationImpl configuration, ClassUseMapper mapper, ClassDoc classdoc) {
        DocPath path = DocPath.forPackage(classdoc).resolve(DocPaths.CLASS_USE).resolve(DocPath.forName(classdoc));
        try {
            ClassUseWriter clsgen = new ClassUseWriter(configuration, mapper, path, classdoc);
            clsgen.generateClassUseFile();
            clsgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), path.getPath());
            throw new DocletAbortException(exc);
        }
    }

    protected void generateClassUseFile() throws IOException {
        Content body = this.getClassUseHeader();
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.classUseContainer);
        if (this.pkgSet.size() > 0) {
            this.addClassUse(div);
        } else {
            div.addContent(this.getResource("doclet.ClassUse_No.usage.of.0", this.classdoc.qualifiedName()));
        }
        body.addContent(div);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    protected void addClassUse(Content contentTree) throws IOException {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        if (this.configuration.packages.length > 1) {
            this.addPackageList(ul);
            this.addPackageAnnotationList(ul);
        }
        this.addClassList(ul);
        contentTree.addContent(ul);
    }

    protected void addPackageList(Content contentTree) throws IOException {
        HtmlTree table = HtmlTree.TABLE(HtmlStyle.useSummary, 0, 3, 0, this.useTableSummary, this.getTableCaption(this.configuration.getResource("doclet.ClassUse_Packages.that.use.0", this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_USE_HEADER, this.classdoc)))));
        ((Content)table).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
        Iterator it = this.pkgSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            PackageDoc pkg = (PackageDoc)it.next();
            HtmlTree tr = new HtmlTree(HtmlTag.TR);
            if (i % 2 == 0) {
                tr.addStyle(HtmlStyle.altColor);
            } else {
                tr.addStyle(HtmlStyle.rowColor);
            }
            this.addPackageUse(pkg, tr);
            ((Content)tbody).addContent(tr);
            ++i;
        }
        ((Content)table).addContent(tbody);
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
        contentTree.addContent(li);
    }

    protected void addPackageAnnotationList(Content contentTree) throws IOException {
        if (!this.classdoc.isAnnotationType() || this.pkgToPackageAnnotations == null || this.pkgToPackageAnnotations.isEmpty()) {
            return;
        }
        HtmlTree table = HtmlTree.TABLE(HtmlStyle.useSummary, 0, 3, 0, this.useTableSummary, this.getTableCaption(this.configuration.getResource("doclet.ClassUse_PackageAnnotation", this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_USE_HEADER, this.classdoc)))));
        ((Content)table).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
        Iterator<PackageDoc> it = this.pkgToPackageAnnotations.iterator();
        int i = 0;
        while (it.hasNext()) {
            PackageDoc pkg = it.next();
            HtmlTree tr = new HtmlTree(HtmlTag.TR);
            if (i % 2 == 0) {
                tr.addStyle(HtmlStyle.altColor);
            } else {
                tr.addStyle(HtmlStyle.rowColor);
            }
            HtmlTree tdFirst = HtmlTree.TD(HtmlStyle.colFirst, this.getPackageLink(pkg, new StringContent(pkg.name())));
            tr.addContent(tdFirst);
            HtmlTree tdLast = new HtmlTree(HtmlTag.TD);
            tdLast.addStyle(HtmlStyle.colLast);
            this.addSummaryComment(pkg, tdLast);
            tr.addContent(tdLast);
            ((Content)tbody).addContent(tr);
            ++i;
        }
        ((Content)table).addContent(tbody);
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
        contentTree.addContent(li);
    }

    protected void addClassList(Content contentTree) throws IOException {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        for (PackageDoc pkg : this.pkgSet) {
            HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, this.getMarkerAnchor(pkg.name()));
            Content link = this.getResource("doclet.ClassUse_Uses.of.0.in.1", this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_USE_HEADER, this.classdoc)), this.getPackageLink(pkg, Util.getPackageName(pkg)));
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, link);
            ((Content)li).addContent(heading);
            this.addClassUse(pkg, li);
            ul.addContent(li);
        }
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, ul);
        contentTree.addContent(li);
    }

    protected void addPackageUse(PackageDoc pkg, Content contentTree) throws IOException {
        HtmlTree tdFirst = HtmlTree.TD(HtmlStyle.colFirst, this.getHyperLink(pkg.name(), (Content)new StringContent(Util.getPackageName(pkg))));
        contentTree.addContent(tdFirst);
        HtmlTree tdLast = new HtmlTree(HtmlTag.TD);
        tdLast.addStyle(HtmlStyle.colLast);
        this.addSummaryComment(pkg, tdLast);
        contentTree.addContent(tdLast);
    }

    protected void addClassUse(PackageDoc pkg, Content contentTree) throws IOException {
        Content classLink = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_USE_HEADER, this.classdoc));
        Content pkgLink = this.getPackageLink(pkg, Util.getPackageName(pkg));
        this.classSubWriter.addUseInfo(this.pkgToClassAnnotations.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_Annotation", classLink, pkgLink), this.classUseTableSummary, contentTree);
        this.classSubWriter.addUseInfo(this.pkgToClassTypeParameter.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_TypeParameter", classLink, pkgLink), this.classUseTableSummary, contentTree);
        this.classSubWriter.addUseInfo(this.pkgToSubclass.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_Subclass", classLink, pkgLink), this.subclassUseTableSummary, contentTree);
        this.classSubWriter.addUseInfo(this.pkgToSubinterface.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_Subinterface", classLink, pkgLink), this.subinterfaceUseTableSummary, contentTree);
        this.classSubWriter.addUseInfo(this.pkgToImplementingClass.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_ImplementingClass", classLink, pkgLink), this.classUseTableSummary, contentTree);
        this.fieldSubWriter.addUseInfo(this.pkgToField.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_Field", classLink, pkgLink), this.fieldUseTableSummary, contentTree);
        this.fieldSubWriter.addUseInfo(this.pkgToFieldAnnotations.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_FieldAnnotations", classLink, pkgLink), this.fieldUseTableSummary, contentTree);
        this.fieldSubWriter.addUseInfo(this.pkgToFieldTypeParameter.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_FieldTypeParameter", classLink, pkgLink), this.fieldUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodAnnotations.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_MethodAnnotations", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodParameterAnnotations.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_MethodParameterAnnotations", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodTypeParameter.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_MethodTypeParameter", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodReturn.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_MethodReturn", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodReturnTypeParameter.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_MethodReturnTypeParameter", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodArgs.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_MethodArgs", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodArgTypeParameter.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_MethodArgsTypeParameters", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodThrows.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_MethodThrows", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorAnnotations.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_ConstructorAnnotations", classLink, pkgLink), this.constructorUseTableSummary, contentTree);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorParameterAnnotations.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_ConstructorParameterAnnotations", classLink, pkgLink), this.constructorUseTableSummary, contentTree);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorArgs.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_ConstructorArgs", classLink, pkgLink), this.constructorUseTableSummary, contentTree);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorArgTypeParameter.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_ConstructorArgsTypeParameters", classLink, pkgLink), this.constructorUseTableSummary, contentTree);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorThrows.get(pkg.name()), this.configuration.getResource("doclet.ClassUse_ConstructorThrows", classLink, pkgLink), this.constructorUseTableSummary, contentTree);
    }

    protected Content getClassUseHeader() {
        String cltype = this.configuration.getText(this.classdoc.isInterface() ? "doclet.Interface" : "doclet.Class");
        String clname = this.classdoc.qualifiedName();
        String title = this.configuration.getText("doclet.Window_ClassUse_Header", cltype, clname);
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        ContentBuilder headContent = new ContentBuilder();
        headContent.addContent(this.getResource("doclet.ClassUse_Title", cltype));
        headContent.addContent(new HtmlTree(HtmlTag.BR));
        headContent.addContent(clname);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CLASS_PAGE_HEADING, true, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    @Override
    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink(DocPath.parent.resolve(DocPaths.PACKAGE_SUMMARY), this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    protected Content getNavLinkClass() {
        Content linkContent = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_USE_HEADER, this.classdoc).label(this.configuration.getText("doclet.Class")));
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    protected Content getNavLinkClassUse() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.useLabel);
        return li;
    }

    @Override
    protected Content getNavLinkTree() {
        Content linkContent = this.classdoc.containingPackage().isIncluded() ? this.getHyperLink(DocPath.parent.resolve(DocPaths.PACKAGE_TREE), this.treeLabel) : this.getHyperLink(this.pathToRoot.resolve(DocPaths.OVERVIEW_TREE), this.treeLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }
}

