/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.formats.html.AbstractMemberWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.SubWriterHolderWriter;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.ClassWriter;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.builders.MemberSummaryBuilder;
import com.sun.tools.oldlets.internal.toolkit.taglets.ParamTaglet;
import com.sun.tools.oldlets.internal.toolkit.util.ClassTree;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.DocletConstants;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;
import org.apidesign.javadoc.codesnippet.impl.Profiles;

public class ClassWriterImpl
extends SubWriterHolderWriter
implements ClassWriter {
    protected final ClassDoc classDoc;
    protected final ClassTree classtree;
    protected final ClassDoc prev;
    protected final ClassDoc next;

    public ClassWriterImpl(ConfigurationImpl configuration, ClassDoc classDoc, ClassDoc prevClass, ClassDoc nextClass, ClassTree classTree) throws IOException {
        super(configuration, DocPath.forClass(classDoc));
        this.classDoc = classDoc;
        configuration.currentcd = classDoc;
        this.classtree = classTree;
        this.prev = prevClass;
        this.next = nextClass;
    }

    @Override
    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink(DocPaths.PACKAGE_SUMMARY, this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    protected Content getNavLinkClass() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.classLabel);
        return li;
    }

    @Override
    protected Content getNavLinkClassUse() {
        Content linkContent = this.getHyperLink(DocPaths.CLASS_USE.resolve(this.filename), this.useLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree li;
        if (this.prev != null) {
            Content prevLink = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS, this.prev).label(this.prevclassLabel).strong(true));
            li = HtmlTree.LI(prevLink);
        } else {
            li = HtmlTree.LI(this.prevclassLabel);
        }
        return li;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree li;
        if (this.next != null) {
            Content nextLink = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS, this.next).label(this.nextclassLabel).strong(true));
            li = HtmlTree.LI(nextLink);
        } else {
            li = HtmlTree.LI(this.nextclassLabel);
        }
        return li;
    }

    @Override
    public Content getHeader(String header) {
        String pkgname = this.classDoc.containingPackage() != null ? this.classDoc.containingPackage().name() : "";
        String clname = this.classDoc.name();
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(clname));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        ((Content)bodyTree).addContent(HtmlConstants.START_OF_CLASS_DATA);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.header);
        if (this.configuration.showProfiles) {
            String sep = "";
            int profile = this.configuration.profiles.getProfile(this.getTypeNameForProfile(this.classDoc));
            if (profile > 0) {
                StringContent profNameContent = new StringContent();
                for (int i = profile; i < this.configuration.profiles.getProfileCount(); ++i) {
                    ((Content)profNameContent).addContent(sep);
                    ((Content)profNameContent).addContent(Profile.lookup((int)i).name);
                    sep = ", ";
                }
                HtmlTree profileNameDiv = HtmlTree.DIV(HtmlStyle.subTitle, profNameContent);
                div.addContent(profileNameDiv);
            }
        }
        if (pkgname.length() > 0) {
            StringContent pkgNameContent = new StringContent(pkgname);
            HtmlTree pkgNameDiv = HtmlTree.DIV(HtmlStyle.subTitle, pkgNameContent);
            div.addContent(pkgNameDiv);
        }
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_HEADER, this.classDoc);
        linkInfo.linkToSelf = false;
        StringContent headerContent = new StringContent(header);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CLASS_PAGE_HEADING, true, HtmlStyle.title, headerContent);
        ((Content)heading).addContent(this.getTypeParameterLinks(linkInfo));
        div.addContent(heading);
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    @Override
    public Content getClassContentHeader() {
        return this.getContentHeader();
    }

    @Override
    public void addFooter(Content contentTree) {
        contentTree.addContent(HtmlConstants.END_OF_CLASS_DATA);
        this.addNavLinks(false, contentTree);
        this.addBottom(contentTree);
    }

    @Override
    public void printDocument(Content contentTree) throws IOException {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.classDoc), true, contentTree);
    }

    @Override
    public Content getClassInfoTreeHeader() {
        return this.getMemberTreeHeader();
    }

    @Override
    public Content getClassInfo(Content classInfoTree) {
        return this.getMemberTree(HtmlStyle.description, classInfoTree);
    }

    @Override
    public void addClassSignature(String modifiers, Content classInfoTree) {
        Type[] implIntfacs;
        Type superclass;
        boolean isInterface = this.classDoc.isInterface();
        classInfoTree.addContent(new HtmlTree(HtmlTag.BR));
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.addAnnotationInfo(this.classDoc, (Content)pre);
        ((Content)pre).addContent(modifiers);
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_SIGNATURE, this.classDoc);
        linkInfo.linkToSelf = false;
        StringContent className = new StringContent(this.classDoc.name());
        Content parameterLinks = this.getTypeParameterLinks(linkInfo);
        if (this.configuration.linksource) {
            this.addSrcLink(this.classDoc, className, pre);
            ((Content)pre).addContent(parameterLinks);
        } else {
            HtmlTree span = HtmlTree.SPAN(HtmlStyle.typeNameLabel, className);
            ((Content)span).addContent(parameterLinks);
            ((Content)pre).addContent(span);
        }
        if (!isInterface && (superclass = Util.getFirstVisibleSuperClass(this.classDoc, this.configuration)) != null) {
            ((Content)pre).addContent(DocletConstants.NL);
            ((Content)pre).addContent("extends ");
            Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_SIGNATURE_PARENT_NAME, superclass));
            ((Content)pre).addContent(link);
        }
        if ((implIntfacs = this.classDoc.interfaceTypes()) != null && implIntfacs.length > 0) {
            int counter = 0;
            for (int i = 0; i < implIntfacs.length; ++i) {
                ClassDoc classDoc = implIntfacs[i].asClassDoc();
                if (!classDoc.isPublic() && !Util.isLinkable(classDoc, this.configuration)) continue;
                if (counter == 0) {
                    ((Content)pre).addContent(DocletConstants.NL);
                    ((Content)pre).addContent(isInterface ? "extends " : "implements ");
                } else {
                    ((Content)pre).addContent(", ");
                }
                Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_SIGNATURE_PARENT_NAME, implIntfacs[i]));
                ((Content)pre).addContent(link);
                ++counter;
            }
        }
        classInfoTree.addContent(pre);
    }

    @Override
    public void addClassDescription(Content classInfoTree) {
        if (!this.configuration.nocomment && this.classDoc.inlineTags().length > 0) {
            this.addInlineComment(this.classDoc, classInfoTree);
        }
    }

    @Override
    public void addClassTagInfo(Content classInfoTree) {
        if (!this.configuration.nocomment) {
            this.addTagsInfo(this.classDoc, classInfoTree);
        }
    }

    private Content getClassInheritenceTree(Type type) {
        Type sup;
        HtmlTree classTreeUl = new HtmlTree(HtmlTag.UL);
        classTreeUl.addStyle(HtmlStyle.inheritance);
        HtmlTree liTree = null;
        do {
            if ((sup = Util.getFirstVisibleSuperClass(type instanceof ClassDoc ? (ClassDoc)type : type.asClassDoc(), this.configuration)) != null) {
                HtmlTree li;
                HtmlTree ul = new HtmlTree(HtmlTag.UL);
                ul.addStyle(HtmlStyle.inheritance);
                ul.addContent(this.getTreeForClassHelper(type));
                if (liTree != null) {
                    ul.addContent(liTree);
                }
                liTree = li = HtmlTree.LI(ul);
                type = sup;
                continue;
            }
            classTreeUl.addContent(this.getTreeForClassHelper(type));
        } while (sup != null);
        if (liTree != null) {
            classTreeUl.addContent(liTree);
        }
        return classTreeUl;
    }

    private Content getTreeForClassHelper(Type type) {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        if (type.equals(this.classDoc)) {
            Content typeParameters = this.getTypeParameterLinks(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.TREE, this.classDoc));
            if (this.configuration.shouldExcludeQualifier(this.classDoc.containingPackage().name())) {
                ((Content)li).addContent(type.asClassDoc().name());
                ((Content)li).addContent(typeParameters);
            } else {
                ((Content)li).addContent(type.asClassDoc().qualifiedName());
                ((Content)li).addContent(typeParameters);
            }
        } else {
            Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_TREE_PARENT, type).label(this.configuration.getClassName(type.asClassDoc())));
            ((Content)li).addContent(link);
        }
        return li;
    }

    @Override
    public void addClassTree(Content classContentTree) {
        if (!this.classDoc.isClass()) {
            return;
        }
        classContentTree.addContent(this.getClassInheritenceTree(this.classDoc));
    }

    @Override
    public void addTypeParamInfo(Content classInfoTree) {
        if (this.classDoc.typeParamTags().length > 0) {
            Content typeParam = new ParamTaglet().getTagletOutput(this.classDoc, this.getTagletWriterInstance(false));
            HtmlTree dl = HtmlTree.DL(typeParam);
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addSubClassInfo(Content classInfoTree) {
        if (this.classDoc.isClass()) {
            if (this.classDoc.qualifiedName().equals("java.lang.Object") || this.classDoc.qualifiedName().equals("org.omg.CORBA.Object")) {
                return;
            }
            List<ClassDoc> subclasses = this.classtree.subs(this.classDoc, false);
            if (subclasses.size() > 0) {
                Content label = this.getResource("doclet.Subclasses");
                HtmlTree dt = HtmlTree.DT(label);
                HtmlTree dl = HtmlTree.DL(dt);
                ((Content)dl).addContent(this.getClassLinks(LinkInfoImpl.Kind.SUBCLASSES, subclasses));
                classInfoTree.addContent(dl);
            }
        }
    }

    @Override
    public void addSubInterfacesInfo(Content classInfoTree) {
        List<ClassDoc> subInterfaces;
        if (this.classDoc.isInterface() && (subInterfaces = this.classtree.allSubs(this.classDoc, false)).size() > 0) {
            Content label = this.getResource("doclet.Subinterfaces");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(LinkInfoImpl.Kind.SUBINTERFACES, subInterfaces));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addInterfaceUsageInfo(Content classInfoTree) {
        if (!this.classDoc.isInterface()) {
            return;
        }
        if (this.classDoc.qualifiedName().equals("java.lang.Cloneable") || this.classDoc.qualifiedName().equals("java.io.Serializable")) {
            return;
        }
        List<ClassDoc> implcl = this.classtree.implementingclasses(this.classDoc);
        if (implcl.size() > 0) {
            Content label = this.getResource("doclet.Implementing_Classes");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(LinkInfoImpl.Kind.IMPLEMENTED_CLASSES, implcl));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addImplementedInterfacesInfo(Content classInfoTree) {
        List<Type> interfaceArray = Util.getAllInterfaces(this.classDoc, this.configuration);
        if (this.classDoc.isClass() && interfaceArray.size() > 0) {
            Content label = this.getResource("doclet.All_Implemented_Interfaces");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(LinkInfoImpl.Kind.IMPLEMENTED_INTERFACES, interfaceArray));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addSuperInterfacesInfo(Content classInfoTree) {
        List<Type> interfaceArray = Util.getAllInterfaces(this.classDoc, this.configuration);
        if (this.classDoc.isInterface() && interfaceArray.size() > 0) {
            Content label = this.getResource("doclet.All_Superinterfaces");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(LinkInfoImpl.Kind.SUPER_INTERFACES, interfaceArray));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addNestedClassInfo(Content classInfoTree) {
        ClassDoc outerClass = this.classDoc.containingClass();
        if (outerClass != null) {
            Content label = outerClass.isInterface() ? this.getResource("doclet.Enclosing_Interface") : this.getResource("doclet.Enclosing_Class");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            HtmlTree dd = new HtmlTree(HtmlTag.DD);
            ((Content)dd).addContent(this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS, outerClass)));
            ((Content)dl).addContent(dd);
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addFunctionalInterfaceInfo(Content classInfoTree) {
        if (Profiles.isFunctionalInterface(this.configuration.root, this.classDoc)) {
            HtmlTree dt = HtmlTree.DT(this.getResource("doclet.Functional_Interface"));
            HtmlTree dl = HtmlTree.DL(dt);
            HtmlTree dd = new HtmlTree(HtmlTag.DD);
            ((Content)dd).addContent(this.getResource("doclet.Functional_Interface_Message"));
            ((Content)dl).addContent(dd);
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addClassDeprecationInfo(Content classInfoTree) {
        HtmlTree hr = new HtmlTree(HtmlTag.HR);
        classInfoTree.addContent(hr);
        Tag[] deprs = this.classDoc.tags("deprecated");
        if (Util.isDeprecated(this.classDoc)) {
            Tag[] commentTags;
            HtmlTree deprLabel = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, deprLabel);
            if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                ((Content)div).addContent(this.getSpace());
                this.addInlineDeprecatedComment(this.classDoc, deprs[0], div);
            }
            classInfoTree.addContent(div);
        }
    }

    private Content getClassLinks(LinkInfoImpl.Kind context, List<?> list) {
        Object[] typeList = list.toArray();
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        for (int i = 0; i < list.size(); ++i) {
            Content link;
            if (i > 0) {
                StringContent separator = new StringContent(", ");
                ((Content)dd).addContent(separator);
            }
            if (typeList[i] instanceof ClassDoc) {
                link = this.getLink(new LinkInfoImpl(this.configuration, context, (ClassDoc)typeList[i]));
                ((Content)dd).addContent(link);
                continue;
            }
            link = this.getLink(new LinkInfoImpl(this.configuration, context, (Type)typeList[i]));
            ((Content)dd).addContent(link);
        }
        return dd;
    }

    @Override
    protected Content getNavLinkTree() {
        Content treeLinkContent = this.getHyperLink(DocPaths.PACKAGE_TREE, this.treeLabel, "", "");
        HtmlTree li = HtmlTree.LI(treeLinkContent);
        return li;
    }

    @Override
    protected void addSummaryDetailLinks(Content subDiv) {
        try {
            HtmlTree div = HtmlTree.DIV(this.getNavSummaryLinks());
            ((Content)div).addContent(this.getNavDetailLinks());
            subDiv.addContent(div);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocletAbortException(e);
        }
    }

    protected Content getNavSummaryLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.summaryLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        String[] navLinkLabels = new String[]{"doclet.navNested", "doclet.navEnum", "doclet.navField", "doclet.navConstructor", "doclet.navMethod"};
        for (int i = 0; i < navLinkLabels.length; ++i) {
            HtmlTree liNav = new HtmlTree(HtmlTag.LI);
            if (i == 1 && !this.classDoc.isEnum() || i == 3 && this.classDoc.isEnum()) continue;
            AbstractMemberWriter writer = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(i));
            if (writer == null) {
                ((Content)liNav).addContent(this.getResource(navLinkLabels[i]));
            } else {
                writer.addNavSummaryLink(memberSummaryBuilder.members(i), memberSummaryBuilder.getVisibleMemberMap(i), liNav);
            }
            if (i < navLinkLabels.length - 1) {
                this.addNavGap(liNav);
            }
            ((Content)ulNav).addContent(liNav);
        }
        return ulNav;
    }

    protected Content getNavDetailLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.detailLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        String[] navLinkLabels = new String[]{"doclet.navNested", "doclet.navEnum", "doclet.navField", "doclet.navConstructor", "doclet.navMethod"};
        for (int i = 1; i < navLinkLabels.length; ++i) {
            HtmlTree liNav = new HtmlTree(HtmlTag.LI);
            AbstractMemberWriter writer = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(i));
            if (i == 1 && !this.classDoc.isEnum() || i == 3 && this.classDoc.isEnum()) continue;
            if (writer == null) {
                ((Content)liNav).addContent(this.getResource(navLinkLabels[i]));
            } else {
                writer.addNavDetailLink(memberSummaryBuilder.members(i), (Content)liNav);
            }
            if (i < navLinkLabels.length - 1) {
                this.addNavGap(liNav);
            }
            ((Content)ulNav).addContent(liNav);
        }
        return ulNav;
    }

    protected void addNavGap(Content liNav) {
        liNav.addContent(this.getSpace());
        liNav.addContent("|");
        liNav.addContent(this.getSpace());
    }

    @Override
    public ClassDoc getClassDoc() {
        return this.classDoc;
    }
}

