/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.formats.html.AbstractProfileIndexWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.RawHtml;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;
import org.apidesign.javadoc.codesnippet.impl.Profiles;

public class ProfileIndexFrameWriter
extends AbstractProfileIndexWriter {
    public ProfileIndexFrameWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(ConfigurationImpl configuration) {
        DocPath filename = DocPaths.PROFILE_OVERVIEW_FRAME;
        try {
            ProfileIndexFrameWriter profilegen = new ProfileIndexFrameWriter(configuration, filename);
            profilegen.buildProfileIndexFile("doclet.Window_Overview", false);
            profilegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    @Override
    protected void addProfilesList(Profiles profiles, String text, String tableSummary, Content body) {
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.PROFILE_HEADING, true, this.profilesLabel);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.indexContainer, heading);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.setTitle(this.profilesLabel);
        for (int i = 1; i < profiles.getProfileCount(); ++i) {
            String profileName = Profile.lookup((int)i).name;
            if (!this.configuration.shouldDocumentProfile(profileName)) continue;
            ul.addContent(this.getProfile(profileName));
        }
        ((Content)div).addContent(ul);
        body.addContent(div);
    }

    protected Content getProfile(String profileName) {
        StringContent profileLabel = new StringContent(profileName);
        Content profileLinkContent = this.getHyperLink(DocPaths.profileFrame(profileName), (Content)profileLabel, "", "packageListFrame");
        HtmlTree li = HtmlTree.LI(profileLinkContent);
        return li;
    }

    @Override
    protected void addNavigationBarHeader(Content body) {
        RawHtml headerContent = this.configuration.packagesheader.length() > 0 ? new RawHtml(this.replaceDocRootDir(this.configuration.packagesheader)) : new RawHtml(this.replaceDocRootDir(this.configuration.header));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.bar, headerContent);
        body.addContent(heading);
    }

    @Override
    protected void addOverviewHeader(Content body) {
    }

    @Override
    protected void addAllClassesLink(Content div) {
        Content linkContent = this.getHyperLink(DocPaths.ALLCLASSES_FRAME, this.allclassesLabel, "", "packageFrame");
        HtmlTree span = HtmlTree.SPAN(linkContent);
        div.addContent(span);
    }

    @Override
    protected void addAllPackagesLink(Content div) {
        Content linkContent = this.getHyperLink(DocPaths.OVERVIEW_FRAME, this.allpackagesLabel, "", "packageListFrame");
        HtmlTree span = HtmlTree.SPAN(linkContent);
        div.addContent(span);
    }

    @Override
    protected void addNavigationBarFooter(Content body) {
        HtmlTree p = HtmlTree.P(this.getSpace());
        body.addContent(p);
    }

    @Override
    protected void addProfilePackagesList(Profiles profiles, String text, String tableSummary, Content body, String profileName) {
    }
}

