/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.RawHtml;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;

public class ProfilePackageFrameWriter
extends HtmlDocletWriter {
    private PackageDoc packageDoc;

    public ProfilePackageFrameWriter(ConfigurationImpl configuration, PackageDoc packageDoc, String profileName) throws IOException {
        super(configuration, DocPath.forPackage(packageDoc).resolve(DocPaths.profilePackageFrame(profileName)));
        this.packageDoc = packageDoc;
    }

    public static void generate(ConfigurationImpl configuration, PackageDoc packageDoc, int profileValue) {
        try {
            String profileName = Profile.lookup((int)profileValue).name;
            ProfilePackageFrameWriter profpackgen = new ProfilePackageFrameWriter(configuration, packageDoc, profileName);
            StringBuilder winTitle = new StringBuilder(profileName);
            String sep = " - ";
            winTitle.append(sep);
            String pkgName = Util.getPackageName(packageDoc);
            winTitle.append(pkgName);
            HtmlTree body = profpackgen.getBody(false, profpackgen.getWindowTitle(winTitle.toString()));
            StringContent profName = new StringContent(profileName);
            StringContent sepContent = new StringContent(sep);
            RawHtml pkgNameContent = new RawHtml(pkgName);
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, profpackgen.getTargetProfileLink("classFrame", profName, profileName));
            ((Content)heading).addContent(sepContent);
            ((Content)heading).addContent(profpackgen.getTargetProfilePackageLink(packageDoc, "classFrame", pkgNameContent, profileName));
            ((Content)body).addContent(heading);
            HtmlTree div = new HtmlTree(HtmlTag.DIV);
            div.addStyle(HtmlStyle.indexContainer);
            profpackgen.addClassListing(div, profileValue);
            ((Content)body).addContent(div);
            profpackgen.printHtmlDocument(configuration.metakeywords.getMetaKeywords(packageDoc), false, body);
            profpackgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), DocPaths.PACKAGE_FRAME.getPath());
            throw new DocletAbortException(exc);
        }
    }

    protected void addClassListing(Content contentTree, int profileValue) {
        if (this.packageDoc.isIncluded()) {
            this.addClassKindListing(this.packageDoc.interfaces(), this.getResource("doclet.Interfaces"), contentTree, profileValue);
            this.addClassKindListing(this.packageDoc.ordinaryClasses(), this.getResource("doclet.Classes"), contentTree, profileValue);
            this.addClassKindListing(this.packageDoc.enums(), this.getResource("doclet.Enums"), contentTree, profileValue);
            this.addClassKindListing(this.packageDoc.exceptions(), this.getResource("doclet.Exceptions"), contentTree, profileValue);
            this.addClassKindListing(this.packageDoc.errors(), this.getResource("doclet.Errors"), contentTree, profileValue);
            this.addClassKindListing(this.packageDoc.annotationTypes(), this.getResource("doclet.AnnotationTypes"), contentTree, profileValue);
        }
    }

    protected void addClassKindListing(ClassDoc[] arr, Content labelContent, Content contentTree, int profileValue) {
        if (arr.length > 0) {
            Arrays.sort(arr);
            boolean printedHeader = false;
            HtmlTree ul = new HtmlTree(HtmlTag.UL);
            ul.setTitle(labelContent);
            for (int i = 0; i < arr.length; ++i) {
                if (!this.isTypeInProfile(arr[i], profileValue) || !Util.isCoreClass(arr[i]) || !this.configuration.isGeneratedDoc(arr[i])) continue;
                if (!printedHeader) {
                    HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, labelContent);
                    contentTree.addContent(heading);
                    printedHeader = true;
                }
                Content arr_i_name = new StringContent(arr[i].name());
                if (arr[i].isInterface()) {
                    arr_i_name = HtmlTree.SPAN(HtmlStyle.interfaceName, arr_i_name);
                }
                Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.PACKAGE_FRAME, arr[i]).label(arr_i_name).target("classFrame"));
                HtmlTree li = HtmlTree.LI(link);
                ul.addContent(li);
            }
            contentTree.addContent(ul);
        }
    }
}

