/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.RawHtml;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.ProfileSummaryWriter;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;

public class ProfileWriterImpl
extends HtmlDocletWriter
implements ProfileSummaryWriter {
    protected Profile prevProfile;
    protected Profile nextProfile;
    protected Profile profile;

    public ProfileWriterImpl(ConfigurationImpl configuration, Profile profile, Profile prevProfile, Profile nextProfile) throws IOException {
        super(configuration, DocPaths.profileSummary(profile.name));
        this.prevProfile = prevProfile;
        this.nextProfile = nextProfile;
        this.profile = profile;
    }

    @Override
    public Content getProfileHeader(String heading) {
        String profileName = this.profile.name;
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(profileName));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.header);
        HtmlTree tHeading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, this.profileLabel);
        ((Content)tHeading).addContent(this.getSpace());
        RawHtml profileHead = new RawHtml(heading);
        ((Content)tHeading).addContent(profileHead);
        div.addContent(tHeading);
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    @Override
    public Content getContentHeader() {
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        return div;
    }

    @Override
    public Content getSummaryHeader() {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        li.addStyle(HtmlStyle.blockList);
        return li;
    }

    @Override
    public Content getSummaryTree(Content summaryContentTree) {
        HtmlTree ul = HtmlTree.UL(HtmlStyle.blockList, summaryContentTree);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.summary, ul);
        return div;
    }

    @Override
    public Content getPackageSummaryHeader(PackageDoc pkg) {
        Content pkgName = this.getTargetProfilePackageLink(pkg, "classFrame", new StringContent(pkg.name()), this.profile.name);
        HtmlTree heading = HtmlTree.HEADING(HtmlTag.H3, pkgName);
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, heading);
        this.addPackageDeprecationInfo(li, pkg);
        return li;
    }

    @Override
    public Content getPackageSummaryTree(Content packageSummaryContentTree) {
        HtmlTree ul = HtmlTree.UL(HtmlStyle.blockList, packageSummaryContentTree);
        return ul;
    }

    @Override
    public void addClassesSummary(ClassDoc[] classes, String label, String tableSummary, String[] tableHeader, Content packageSummaryContentTree) {
        this.addClassesSummary(classes, label, tableSummary, tableHeader, packageSummaryContentTree, this.profile.value);
    }

    @Override
    public void addProfileFooter(Content contentTree) {
        this.addNavLinks(false, contentTree);
        this.addBottom(contentTree);
    }

    @Override
    public void printDocument(Content contentTree) throws IOException {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.profile), true, contentTree);
    }

    public void addPackageDeprecationInfo(Content li, PackageDoc pkg) {
        if (Util.isDeprecated(pkg)) {
            Tag[] commentTags;
            Tag[] deprs = pkg.tags("deprecated");
            HtmlTree deprDiv = new HtmlTree(HtmlTag.DIV);
            deprDiv.addStyle(HtmlStyle.deprecatedContent);
            HtmlTree deprPhrase = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            deprDiv.addContent(deprPhrase);
            if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                this.addInlineDeprecatedComment(pkg, deprs[0], deprDiv);
            }
            li.addContent(deprDiv);
        }
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree li = this.prevProfile == null ? HtmlTree.LI(this.prevprofileLabel) : HtmlTree.LI(this.getHyperLink(this.pathToRoot.resolve(DocPaths.profileSummary(this.prevProfile.name)), this.prevprofileLabel, "", ""));
        return li;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree li = this.nextProfile == null ? HtmlTree.LI(this.nextprofileLabel) : HtmlTree.LI(this.getHyperLink(this.pathToRoot.resolve(DocPaths.profileSummary(this.nextProfile.name)), this.nextprofileLabel, "", ""));
        return li;
    }
}

