/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.tools.oldlets.formats.html.AbstractIndexWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.IndexBuilder;
import java.io.IOException;

public class SingleIndexWriter
extends AbstractIndexWriter {
    public SingleIndexWriter(ConfigurationImpl configuration, DocPath filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename, indexbuilder);
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        DocPath filename = DocPaths.INDEX_ALL;
        try {
            SingleIndexWriter indexgen = new SingleIndexWriter(configuration, filename, indexbuilder);
            indexgen.generateIndexFile();
            indexgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    protected void generateIndexFile() throws IOException {
        String title = this.configuration.getText("doclet.Window_Single_Index");
        HtmlTree body = this.getBody(true, this.getWindowTitle(title));
        this.addTop(body);
        this.addNavLinks(true, body);
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.addLinksForIndexes(divTree);
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character unicode = (Character)this.indexbuilder.elements()[i];
            this.addContents(unicode, this.indexbuilder.getMemberList(unicode), divTree);
        }
        this.addLinksForIndexes(divTree);
        ((Content)body).addContent(divTree);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    protected void addLinksForIndexes(Content contentTree) {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            String unicode = this.indexbuilder.elements()[i].toString();
            contentTree.addContent(this.getHyperLink(this.getNameForIndex(unicode), (Content)new StringContent(unicode)));
            contentTree.addContent(this.getSpace());
        }
    }
}

