/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.markup.DocType;
import com.sun.tools.oldlets.formats.html.markup.HtmlDocument;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocFile;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletConstants;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import javax.tools.FileObject;
import org.apidesign.javadoc.codesnippet.impl.Profiles;

public class SourceToHTMLConverter {
    private static final int NUM_BLANK_LINES = 60;
    private static final String NEW_LINE = DocletConstants.NL;
    private final ConfigurationImpl configuration;
    private final RootDoc rootDoc;
    private DocPath outputdir;
    private DocPath relativePath = DocPath.empty;

    private SourceToHTMLConverter(ConfigurationImpl configuration, RootDoc rd, DocPath outputdir) {
        this.configuration = configuration;
        this.rootDoc = rd;
        this.outputdir = outputdir;
    }

    public static void convertRoot(ConfigurationImpl configuration, RootDoc rd, DocPath outputdir) {
        new SourceToHTMLConverter(configuration, rd, outputdir).generate();
    }

    void generate() {
        if (this.rootDoc == null || this.outputdir == null) {
            return;
        }
        PackageDoc[] pds = this.rootDoc.specifiedPackages();
        for (int i = 0; i < pds.length; ++i) {
            if (this.configuration.nodeprecated && Util.isDeprecated(pds[i])) continue;
            this.convertPackage(pds[i], this.outputdir);
        }
        ClassDoc[] cds = this.rootDoc.specifiedClasses();
        for (int i = 0; i < cds.length; ++i) {
            if (this.configuration.nodeprecated && (Util.isDeprecated(cds[i]) || Util.isDeprecated(cds[i].containingPackage()))) continue;
            this.convertClass(cds[i], this.outputdir);
        }
    }

    public void convertPackage(PackageDoc pd, DocPath outputdir) {
        if (pd == null) {
            return;
        }
        ClassDoc[] cds = pd.allClasses();
        for (int i = 0; i < cds.length; ++i) {
            if (this.configuration.nodeprecated && Util.isDeprecated(cds[i])) continue;
            this.convertClass(cds[i], outputdir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertClass(ClassDoc cd, DocPath outputdir) {
        if (cd == null) {
            return;
        }
        try {
            Reader r;
            SourcePosition sp = cd.position();
            if (sp == null) {
                return;
            }
            FileObject[] optional = Profiles.findFileObject(sp);
            if (optional != null) {
                FileObject fo = optional[0];
                if (fo == null) {
                    return;
                }
                r = fo.openReader(true);
            } else {
                File file = sp.file();
                if (file == null) {
                    return;
                }
                r = new FileReader(file);
            }
            LineNumberReader reader = new LineNumberReader(r);
            int lineno = 1;
            this.relativePath = DocPaths.SOURCE_OUTPUT.resolve(DocPath.forPackage(cd)).invert();
            Content body = SourceToHTMLConverter.getHeader();
            HtmlTree pre = new HtmlTree(HtmlTag.PRE);
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    SourceToHTMLConverter.addLineNo(pre, lineno);
                    this.addLine(pre, line, lineno);
                    ++lineno;
                }
            }
            finally {
                reader.close();
            }
            SourceToHTMLConverter.addBlankLines(pre);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.sourceContainer, pre);
            body.addContent(div);
            this.writeToFile(body, outputdir.resolve(DocPath.forClass(cd)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(Content body, DocPath path) throws IOException {
        DocType htmlDocType = DocType.TRANSITIONAL;
        HtmlTree head = new HtmlTree(HtmlTag.HEAD);
        ((Content)head).addContent(HtmlTree.TITLE(new StringContent(this.configuration.getText("doclet.Window_Source_title"))));
        ((Content)head).addContent(this.getStyleSheetProperties());
        HtmlTree htmlTree = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), head, body);
        HtmlDocument htmlDocument = new HtmlDocument(htmlDocType, htmlTree);
        this.configuration.message.notice("doclet.Generating_0", path.getPath());
        DocFile df = DocFile.createFileForOutput(this.configuration, path);
        try (Writer w = df.openWriter();){
            ((Content)htmlDocument).write(w, true);
        }
    }

    public HtmlTree getStyleSheetProperties() {
        DocPath stylesheet;
        String filename = this.configuration.stylesheetfile;
        if (filename.length() > 0) {
            DocFile file = DocFile.createFileForInput(this.configuration, filename);
            stylesheet = DocPath.create(file.getName());
        } else {
            stylesheet = DocPaths.STYLESHEET;
        }
        DocPath p = this.relativePath.resolve(stylesheet);
        HtmlTree link = HtmlTree.LINK("stylesheet", "text/css", p.getPath(), "Style");
        return link;
    }

    private static Content getHeader() {
        return new HtmlTree(HtmlTag.BODY);
    }

    private static void addLineNo(Content pre, int lineno) {
        HtmlTree span = new HtmlTree(HtmlTag.SPAN);
        span.addStyle(HtmlStyle.sourceLineNo);
        if (lineno < 10) {
            span.addContent("00" + Integer.toString(lineno));
        } else if (lineno < 100) {
            span.addContent("0" + Integer.toString(lineno));
        } else {
            span.addContent(Integer.toString(lineno));
        }
        pre.addContent(span);
    }

    private void addLine(Content pre, String line, int currentLineNo) {
        if (line != null) {
            pre.addContent(Util.replaceTabs(this.configuration, line));
            HtmlTree anchor = HtmlTree.A_NAME("line." + Integer.toString(currentLineNo));
            pre.addContent(anchor);
            pre.addContent(NEW_LINE);
        }
    }

    private static void addBlankLines(Content pre) {
        for (int i = 0; i < 60; ++i) {
            pre.addContent(NEW_LINE);
        }
    }

    public static String getAnchorName(Doc d) {
        return "line." + d.position().line();
    }
}

