/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.tools.oldlets.formats.html.AbstractIndexWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.IndexBuilder;
import java.io.IOException;

public class SplitIndexWriter
extends AbstractIndexWriter {
    protected int prev;
    protected int next;

    public SplitIndexWriter(ConfigurationImpl configuration, DocPath path, IndexBuilder indexbuilder, int prev, int next) throws IOException {
        super(configuration, path, indexbuilder);
        this.prev = prev;
        this.next = next;
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        DocPath filename = DocPath.empty;
        DocPath path = DocPaths.INDEX_FILES;
        try {
            for (int i = 0; i < indexbuilder.elements().length; ++i) {
                int j = i + 1;
                int prev = j == 1 ? -1 : i;
                int next = j == indexbuilder.elements().length ? -1 : j + 1;
                filename = DocPaths.indexN(j);
                SplitIndexWriter indexgen = new SplitIndexWriter(configuration, path.resolve(filename), indexbuilder, prev, next);
                indexgen.generateIndexFile((Character)indexbuilder.elements()[i]);
                indexgen.close();
            }
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename.getPath());
            throw new DocletAbortException(exc);
        }
    }

    protected void generateIndexFile(Character unicode) throws IOException {
        String title = this.configuration.getText("doclet.Window_Split_Index", unicode.toString());
        HtmlTree body = this.getBody(true, this.getWindowTitle(title));
        this.addTop(body);
        this.addNavLinks(true, body);
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.addLinksForIndexes(divTree);
        this.addContents(unicode, this.indexbuilder.getMemberList(unicode), divTree);
        this.addLinksForIndexes(divTree);
        ((Content)body).addContent(divTree);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    protected void addLinksForIndexes(Content contentTree) {
        Object[] unicodeChars = this.indexbuilder.elements();
        for (int i = 0; i < unicodeChars.length; ++i) {
            int j = i + 1;
            contentTree.addContent(this.getHyperLink(DocPaths.indexN(j), (Content)new StringContent(unicodeChars[i].toString())));
            contentTree.addContent(this.getSpace());
        }
    }

    @Override
    public Content getNavLinkPrevious() {
        Content prevletterLabel = this.getResource("doclet.Prev_Letter");
        if (this.prev == -1) {
            return HtmlTree.LI(prevletterLabel);
        }
        Content prevLink = this.getHyperLink(DocPaths.indexN(this.prev), prevletterLabel);
        return HtmlTree.LI(prevLink);
    }

    @Override
    public Content getNavLinkNext() {
        Content nextletterLabel = this.getResource("doclet.Next_Letter");
        if (this.next == -1) {
            return HtmlTree.LI(nextletterLabel);
        }
        Content nextLink = this.getHyperLink(DocPaths.indexN(this.next), nextletterLabel);
        return HtmlTree.LI(nextLink);
    }
}

