/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.formats.html.AbstractTreeWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.ClassTree;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;

public class TreeWriter
extends AbstractTreeWriter {
    private PackageDoc[] packages;
    private boolean classesonly;

    public TreeWriter(ConfigurationImpl configuration, DocPath filename, ClassTree classtree) throws IOException {
        super(configuration, filename, classtree);
        this.packages = configuration.packages;
        this.classesonly = this.packages.length == 0;
    }

    public static void generate(ConfigurationImpl configuration, ClassTree classtree) {
        DocPath filename = DocPaths.OVERVIEW_TREE;
        try {
            TreeWriter treegen = new TreeWriter(configuration, filename, classtree);
            treegen.generateTreeFile();
            treegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    public void generateTreeFile() throws IOException {
        Content body = this.getTreeHeader();
        Content headContent = this.getResource("doclet.Hierarchy_For_All_Packages");
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, false, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        this.addPackageTreeLinks(div);
        body.addContent(div);
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.addTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy", divTree);
        this.addTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy", divTree);
        this.addTree(this.classtree.baseAnnotationTypes(), "doclet.Annotation_Type_Hierarchy", divTree);
        this.addTree(this.classtree.baseEnums(), "doclet.Enum_Hierarchy", divTree);
        body.addContent(divTree);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    protected void addPackageTreeLinks(Content contentTree) {
        if (this.packages.length == 1 && this.packages[0].name().length() == 0) {
            return;
        }
        if (!this.classesonly) {
            HtmlTree span = HtmlTree.SPAN(HtmlStyle.packageHierarchyLabel, this.getResource("doclet.Package_Hierarchies"));
            contentTree.addContent(span);
            HtmlTree ul = new HtmlTree(HtmlTag.UL);
            ul.addStyle(HtmlStyle.horizontal);
            for (int i = 0; i < this.packages.length; ++i) {
                if (this.packages[i].name().length() == 0 || this.configuration.nodeprecated && Util.isDeprecated(this.packages[i])) continue;
                DocPath link = this.pathString(this.packages[i], DocPaths.PACKAGE_TREE);
                HtmlTree li = HtmlTree.LI(this.getHyperLink(link, (Content)new StringContent(this.packages[i].name())));
                if (i < this.packages.length - 1) {
                    ((Content)li).addContent(", ");
                }
                ul.addContent(li);
            }
            contentTree.addContent(ul);
        }
    }

    protected Content getTreeHeader() {
        String title = this.configuration.getText("doclet.Window_Class_Hierarchy");
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        return bodyTree;
    }
}

