/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html.markup;

import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContentBuilder
extends Content {
    protected List<Content> contents = Collections.emptyList();

    @Override
    public void addContent(Content content) {
        ContentBuilder.nullCheck(content);
        this.ensureMutableContents();
        if (content instanceof ContentBuilder) {
            this.contents.addAll(((ContentBuilder)content).contents);
        } else {
            this.contents.add(content);
        }
    }

    @Override
    public void addContent(String text) {
        StringContent sc;
        Content c;
        if (text.isEmpty()) {
            return;
        }
        this.ensureMutableContents();
        Content content = c = this.contents.isEmpty() ? null : this.contents.get(this.contents.size() - 1);
        if (c != null && c instanceof StringContent) {
            sc = (StringContent)c;
        } else {
            sc = new StringContent();
            this.contents.add(sc);
        }
        sc.addContent(text);
    }

    @Override
    public boolean write(Writer writer, boolean atNewline) throws IOException {
        for (Content content : this.contents) {
            atNewline = content.write(writer, atNewline);
        }
        return atNewline;
    }

    @Override
    public boolean isEmpty() {
        for (Content content : this.contents) {
            if (content.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int charCount() {
        int n = 0;
        for (Content c : this.contents) {
            n += c.charCount();
        }
        return n;
    }

    private void ensureMutableContents() {
        if (this.contents.isEmpty()) {
            this.contents = new ArrayList<Content>();
        }
    }
}

