/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html.markup;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.oldlets.formats.html.SectionName;
import com.sun.tools.oldlets.formats.html.markup.Comment;
import com.sun.tools.oldlets.formats.html.markup.DocType;
import com.sun.tools.oldlets.formats.html.markup.HtmlAttr;
import com.sun.tools.oldlets.formats.html.markup.HtmlDocument;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.HtmlWriter;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocFile;
import com.sun.tools.oldlets.internal.toolkit.util.DocLink;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class HtmlDocWriter
extends HtmlWriter {
    public static final String CONTENT_TYPE = "text/html";

    public HtmlDocWriter(Configuration configuration, DocPath filename) throws IOException {
        super(configuration, filename);
        configuration.message.notice("doclet.Generating_0", DocFile.createFileForOutput(configuration, filename).getPath());
    }

    public abstract Configuration configuration();

    public Content getHyperLink(DocPath link, String label) {
        return this.getHyperLink(link, (Content)new StringContent(label), false, "", "", "");
    }

    public Content getHyperLink(String where, Content label) {
        return this.getHyperLink(this.getDocLink(where), label, "", "");
    }

    public Content getHyperLink(SectionName sectionName, Content label) {
        return this.getHyperLink(this.getDocLink(sectionName), label, "", "");
    }

    public Content getHyperLink(SectionName sectionName, String where, Content label) {
        return this.getHyperLink(this.getDocLink(sectionName, where), label, "", "");
    }

    public DocLink getDocLink(String where) {
        return DocLink.fragment(this.getName(where));
    }

    public DocLink getDocLink(SectionName sectionName) {
        return DocLink.fragment(sectionName.getName());
    }

    public DocLink getDocLink(SectionName sectionName, String where) {
        return DocLink.fragment(sectionName.getName() + this.getName(where));
    }

    public String getName(String name) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            switch (ch) {
                case '(': 
                case ')': 
                case ',': 
                case '<': 
                case '>': {
                    sb.append('-');
                    continue block7;
                }
                case ' ': 
                case '[': {
                    continue block7;
                }
                case ']': {
                    sb.append(":A");
                    continue block7;
                }
                case '$': {
                    if (i == 0) {
                        sb.append("Z:Z");
                    }
                    sb.append(":D");
                    continue block7;
                }
                case '_': {
                    if (i == 0) {
                        sb.append("Z:Z");
                    }
                    sb.append(ch);
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public Content getHyperLink(DocPath link, Content label) {
        return this.getHyperLink(link, label, "", "");
    }

    public Content getHyperLink(DocLink link, Content label) {
        return this.getHyperLink(link, label, "", "");
    }

    public Content getHyperLink(DocPath link, Content label, boolean strong, String stylename, String title, String target) {
        return this.getHyperLink(new DocLink(link), label, strong, stylename, title, target);
    }

    public Content getHyperLink(DocLink link, Content label, boolean strong, String stylename, String title, String target) {
        Content body = label;
        if (strong) {
            body = HtmlTree.SPAN(HtmlStyle.typeNameLink, body);
        }
        if (stylename != null && stylename.length() != 0) {
            HtmlTree t = new HtmlTree(HtmlTag.FONT, body);
            t.addAttr(HtmlAttr.CLASS, stylename);
            body = t;
        }
        HtmlTree l = HtmlTree.A(link.toString(), body);
        if (title != null && title.length() != 0) {
            l.addAttr(HtmlAttr.TITLE, title);
        }
        if (target != null && target.length() != 0) {
            l.addAttr(HtmlAttr.TARGET, target);
        }
        return l;
    }

    public Content getHyperLink(DocPath link, Content label, String title, String target) {
        return this.getHyperLink(new DocLink(link), label, title, target);
    }

    public Content getHyperLink(DocLink link, Content label, String title, String target) {
        HtmlTree anchor = HtmlTree.A(link.toString(), label);
        if (title != null && title.length() != 0) {
            anchor.addAttr(HtmlAttr.TITLE, title);
        }
        if (target != null && target.length() != 0) {
            anchor.addAttr(HtmlAttr.TARGET, target);
        }
        return anchor;
    }

    public String getPkgName(ClassDoc cd) {
        String pkgName = cd.containingPackage().name();
        if (pkgName.length() > 0) {
            pkgName = pkgName + ".";
            return pkgName;
        }
        return "";
    }

    public boolean getMemberDetailsListPrinted() {
        return this.memberDetailsListPrinted;
    }

    public void printFramesetDocument(String title, boolean noTimeStamp, Content frameset) throws IOException {
        DocType htmlDocType = DocType.FRAMESET;
        Comment htmlComment = new Comment(this.configuration.getText("doclet.New_Page"));
        HtmlTree head = new HtmlTree(HtmlTag.HEAD);
        ((Content)head).addContent(this.getGeneratedBy(!noTimeStamp));
        if (this.configuration.charset.length() > 0) {
            HtmlTree meta = HtmlTree.META("Content-Type", CONTENT_TYPE, this.configuration.charset);
            ((Content)head).addContent(meta);
        }
        HtmlTree windowTitle = HtmlTree.TITLE(new StringContent(title));
        ((Content)head).addContent(windowTitle);
        ((Content)head).addContent(this.getFramesetJavaScript());
        HtmlTree htmlTree = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), head, frameset);
        HtmlDocument htmlDocument = new HtmlDocument(htmlDocType, htmlComment, htmlTree);
        this.write(htmlDocument);
    }

    protected Comment getGeneratedBy(boolean timestamp) {
        String text = "Generated by javadoc";
        if (timestamp) {
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault());
            Date today = calendar.getTime();
            text = text + " (" + this.configuration.getDocletSpecificBuildDate() + ") on " + today;
        }
        return new Comment(text);
    }
}

