/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.oldlets.formats.html.HtmlDoclet;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.BuilderFactory;
import com.sun.tools.oldlets.internal.toolkit.util.ClassTree;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.FatalError;
import com.sun.tools.oldlets.internal.toolkit.util.PackageListWriter;
import com.sun.tools.oldlets.internal.toolkit.util.Util;

public abstract class AbstractDoclet {
    public Configuration configuration;
    private static final String TOOLKIT_DOCLET_NAME = HtmlDoclet.class.getName();

    private boolean isValidDoclet(AbstractDoclet doclet) {
        if (!doclet.getClass().getName().equals(TOOLKIT_DOCLET_NAME)) {
            this.configuration.message.error("doclet.Toolkit_Usage_Violation", TOOLKIT_DOCLET_NAME);
            return false;
        }
        return true;
    }

    public boolean start(AbstractDoclet doclet, RootDoc root) {
        this.configuration = this.configuration();
        this.configuration.root = root;
        if (!this.isValidDoclet(doclet)) {
            return false;
        }
        try {
            doclet.startGeneration(root);
        }
        catch (Configuration.Fault f) {
            root.printError(f.getMessage());
            return false;
        }
        catch (FatalError fe) {
            return false;
        }
        catch (DocletAbortException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause.getLocalizedMessage() != null) {
                    root.printError(cause.getLocalizedMessage());
                } else {
                    root.printError(cause.toString());
                }
            }
            return false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public abstract Configuration configuration();

    private void startGeneration(RootDoc root) throws Configuration.Fault, Exception {
        if (root.classes().length == 0) {
            this.configuration.message.error("doclet.No_Public_Classes_To_Document", new Object[0]);
            return;
        }
        this.configuration.setOptions();
        this.configuration.getDocletSpecificMsg().notice("doclet.build_version", this.configuration.getDocletSpecificBuildDate());
        ClassTree classtree = new ClassTree(this.configuration, this.configuration.nodeprecated);
        this.generateClassFiles(root, classtree);
        Util.copyDocFiles(this.configuration, DocPaths.DOC_FILES);
        PackageListWriter.generate(this.configuration);
        this.generatePackageFiles(classtree);
        this.generateProfileFiles();
        this.generateOtherFiles(root, classtree);
        this.configuration.tagletManager.printReport();
    }

    protected void generateOtherFiles(RootDoc root, ClassTree classtree) throws Exception {
        BuilderFactory builderFactory = this.configuration.getBuilderFactory();
        AbstractBuilder constantsSummaryBuilder = builderFactory.getConstantsSummaryBuider();
        constantsSummaryBuilder.build();
        AbstractBuilder serializedFormBuilder = builderFactory.getSerializedFormBuilder();
        serializedFormBuilder.build();
    }

    protected abstract void generateProfileFiles() throws Exception;

    protected abstract void generatePackageFiles(ClassTree var1) throws Exception;

    protected abstract void generateClassFiles(ClassDoc[] var1, ClassTree var2);

    protected void generateClassFiles(RootDoc root, ClassTree classtree) {
        this.generateClassFiles(classtree);
        PackageDoc[] packages = root.specifiedPackages();
        for (int i = 0; i < packages.length; ++i) {
            this.generateClassFiles(packages[i].allClasses(), classtree);
        }
    }

    private void generateClassFiles(ClassTree classtree) {
        String[] packageNames = this.configuration.classDocCatalog.packageNames();
        for (int packageNameIndex = 0; packageNameIndex < packageNames.length; ++packageNameIndex) {
            this.generateClassFiles(this.configuration.classDocCatalog.allClasses(packageNames[packageNameIndex]), classtree);
        }
    }
}

