/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.builders.LayoutParser;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.FatalError;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public abstract class AbstractBuilder {
    protected final Configuration configuration;
    protected final Set<String> containingPackagesSeen;
    protected final LayoutParser layoutParser;
    protected static final boolean DEBUG = false;

    public AbstractBuilder(Context c) {
        this.configuration = c.configuration;
        this.containingPackagesSeen = c.containingPackagesSeen;
        this.layoutParser = c.layoutParser;
    }

    public abstract String getName();

    public abstract void build() throws IOException;

    protected void build(XMLNode node, Content contentTree) {
        String component = node.name;
        try {
            this.invokeMethod("build" + component, new Class[]{XMLNode.class, Content.class}, new Object[]{node, contentTree});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            this.configuration.root.printError("Unknown element: " + component);
            throw new DocletAbortException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FatalError) {
                throw (FatalError)cause;
            }
            if (cause instanceof DocletAbortException) {
                throw (DocletAbortException)cause;
            }
            throw new DocletAbortException(cause);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.configuration.root.printError("Exception " + e.getClass().getName() + " thrown while processing element: " + component);
            throw new DocletAbortException(e);
        }
    }

    protected void buildChildren(XMLNode node, Content contentTree) {
        for (XMLNode child : node.children) {
            this.build(child, contentTree);
        }
    }

    protected void invokeMethod(String methodName, Class<?>[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    public static class Context {
        final Configuration configuration;
        final Set<String> containingPackagesSeen;
        final LayoutParser layoutParser;

        Context(Configuration configuration, Set<String> containingPackagesSeen, LayoutParser layoutParser) {
            this.configuration = configuration;
            this.containingPackagesSeen = containingPackagesSeen;
            this.layoutParser = layoutParser;
        }
    }
}

