/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DeprecatedAPIListBuilder {
    public static final int NUM_TYPES = 12;
    public static final int PACKAGE = 0;
    public static final int INTERFACE = 1;
    public static final int CLASS = 2;
    public static final int ENUM = 3;
    public static final int EXCEPTION = 4;
    public static final int ERROR = 5;
    public static final int ANNOTATION_TYPE = 6;
    public static final int FIELD = 7;
    public static final int METHOD = 8;
    public static final int CONSTRUCTOR = 9;
    public static final int ENUM_CONSTANT = 10;
    public static final int ANNOTATION_TYPE_MEMBER = 11;
    private List<List<Doc>> deprecatedLists = new ArrayList<List<Doc>>();

    public DeprecatedAPIListBuilder(Configuration configuration) {
        for (int i = 0; i < 12; ++i) {
            this.deprecatedLists.add(i, new ArrayList());
        }
        this.buildDeprecatedAPIInfo(configuration);
    }

    private void buildDeprecatedAPIInfo(Configuration configuration) {
        PackageDoc[] packages = configuration.packages;
        for (int c = 0; c < packages.length; ++c) {
            PackageDoc pkg = packages[c];
            if (!Util.isDeprecated(pkg)) continue;
            this.getList(0).add(pkg);
        }
        ClassDoc[] classes = configuration.root.classes();
        for (int i = 0; i < classes.length; ++i) {
            ClassDoc cd = classes[i];
            if (Util.isDeprecated(cd)) {
                if (cd.isOrdinaryClass()) {
                    this.getList(2).add(cd);
                } else if (cd.isInterface()) {
                    this.getList(1).add(cd);
                } else if (cd.isException()) {
                    this.getList(4).add(cd);
                } else if (cd.isEnum()) {
                    this.getList(3).add(cd);
                } else if (cd.isError()) {
                    this.getList(5).add(cd);
                } else if (cd.isAnnotationType()) {
                    this.getList(6).add(cd);
                }
            }
            this.composeDeprecatedList(this.getList(7), cd.fields());
            this.composeDeprecatedList(this.getList(8), cd.methods());
            this.composeDeprecatedList(this.getList(9), cd.constructors());
            if (cd.isEnum()) {
                this.composeDeprecatedList(this.getList(10), cd.enumConstants());
            }
            if (!cd.isAnnotationType()) continue;
            this.composeDeprecatedList(this.getList(11), ((AnnotationTypeDoc)cd).elements());
        }
        this.sortDeprecatedLists();
    }

    private void composeDeprecatedList(List<Doc> list, MemberDoc[] members) {
        for (int i = 0; i < members.length; ++i) {
            if (!Util.isDeprecated(members[i])) continue;
            list.add(members[i]);
        }
    }

    private void sortDeprecatedLists() {
        for (int i = 0; i < 12; ++i) {
            Collections.sort(this.getList(i));
        }
    }

    public List<Doc> getList(int type) {
        return this.deprecatedLists.get(type);
    }

    public boolean hasDocumentation(int type) {
        return this.deprecatedLists.get(type).size() > 0;
    }
}

