/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.DocFile;
import com.sun.tools.oldlets.internal.toolkit.util.DocLink;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.tools.DocumentationTool;

public class Extern {
    private Map<String, Item> packageToItemMap;
    private final Configuration configuration;
    private boolean linkoffline = false;

    public Extern(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isExternal(ProgramElementDoc doc) {
        if (this.packageToItemMap == null) {
            return false;
        }
        return this.packageToItemMap.get(doc.containingPackage().name()) != null;
    }

    public DocLink getExternalLink(String pkgName, DocPath relativepath, String filename) {
        return this.getExternalLink(pkgName, relativepath, filename, null);
    }

    public DocLink getExternalLink(String pkgName, DocPath relativepath, String filename, String memberName) {
        Item fnd = this.findPackageItem(pkgName);
        if (fnd == null) {
            return null;
        }
        DocPath p = fnd.relative ? relativepath.resolve(fnd.path).resolve(filename) : DocPath.create(fnd.path).resolve(filename);
        return new DocLink(p, "is-external=true", memberName);
    }

    public boolean link(String url, String pkglisturl, DocErrorReporter reporter, boolean linkoffline) {
        this.linkoffline = linkoffline;
        try {
            url = this.adjustEndFileSeparator(url);
            if (this.isUrl(pkglisturl)) {
                this.readPackageListFromURL(url, this.toURL(this.adjustEndFileSeparator(pkglisturl)));
            } else {
                this.readPackageListFromFile(url, DocFile.createFileForInput(this.configuration, pkglisturl));
            }
            return true;
        }
        catch (Fault f) {
            reporter.printWarning(f.getMessage());
            return false;
        }
    }

    private URL toURL(String url) throws Fault {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new Fault(this.configuration.getText("doclet.MalformedURL", url), e);
        }
    }

    private Item findPackageItem(String pkgName) {
        if (this.packageToItemMap == null) {
            return null;
        }
        return this.packageToItemMap.get(pkgName);
    }

    private String adjustEndFileSeparator(String url) {
        return url.endsWith("/") ? url : url + '/';
    }

    private void readPackageListFromURL(String urlpath, URL pkglisturlpath) throws Fault {
        try {
            URL link = this.getLinkForPackageList(pkglisturlpath);
            this.readPackageList(link.openStream(), urlpath, false);
        }
        catch (URISyntaxException exc) {
            throw new Fault(this.configuration.getText("doclet.MalformedURL", pkglisturlpath.toString()), exc);
        }
        catch (MalformedURLException exc) {
            throw new Fault(this.configuration.getText("doclet.MalformedURL", pkglisturlpath.toString()), exc);
        }
        catch (IOException exc) {
            throw new Fault(this.configuration.getText("doclet.URL_error", pkglisturlpath.toString()), exc);
        }
    }

    private URL getLinkForPackageList(URL pkglisturlpath) throws URISyntaxException, IOException {
        URL link = pkglisturlpath.toURI().resolve(DocPaths.PACKAGE_LIST.getPath()).toURL();
        HttpURLConnection connection = (HttpURLConnection)link.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        if (connection.getResponseCode() == 404) {
            link = pkglisturlpath.toURI().resolve(DocPaths.ELEMENT_LIST.getPath()).toURL();
        }
        return link;
    }

    private void readPackageListFromFile(String path, DocFile pkgListPath) throws Fault {
        boolean isPathRelative;
        DocFile packageListFile = pkgListPath.resolve(DocPaths.PACKAGE_LIST);
        DocFile elementListFile = pkgListPath.resolve(DocPaths.ELEMENT_LIST);
        if (!packageListFile.isAbsolute() && !this.linkoffline) {
            packageListFile = packageListFile.resolveAgainst(DocumentationTool.Location.DOCUMENTATION_OUTPUT);
        }
        if (!elementListFile.isAbsolute() && !this.linkoffline) {
            elementListFile = elementListFile.resolveAgainst(DocumentationTool.Location.DOCUMENTATION_OUTPUT);
        }
        boolean bl = isPathRelative = !DocFile.createFileForInput(this.configuration, path).isAbsolute() && !this.isUrl(path);
        if (packageListFile.exists() && packageListFile.canRead()) {
            try {
                this.readPackageList(packageListFile.openInputStream(), path, isPathRelative);
            }
            catch (IOException ex) {
                throw new Fault(this.configuration.getText("doclet.File_error", packageListFile.getPath()), ex);
            }
        } else if (elementListFile.exists() && elementListFile.canRead()) {
            try {
                this.readPackageList(elementListFile.openInputStream(), path, isPathRelative);
            }
            catch (IOException ex) {
                throw new Fault(this.configuration.getText("doclet.File_error", elementListFile.getPath()), ex);
            }
        } else {
            throw new Fault(this.configuration.getText("doclet.File_error", packageListFile.getPath()), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPackageList(InputStream input, String path, boolean relative) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        StringBuilder strbuf = new StringBuilder();
        try {
            int c;
            while ((c = in.read()) >= 0) {
                char ch = (char)c;
                if (ch == '\n' || ch == '\r') {
                    if (strbuf.length() <= 0) continue;
                    String packname = strbuf.toString();
                    String packpath = path + packname.replace('.', '/') + '/';
                    new Item(packname, packpath, relative);
                    strbuf.setLength(0);
                    continue;
                }
                strbuf.append(ch);
            }
        }
        finally {
            input.close();
        }
    }

    public boolean isUrl(String urlCandidate) {
        try {
            new URL(urlCandidate);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(String msg, Exception cause) {
            super(msg, cause);
        }
    }

    private class Item {
        final String packageName;
        final String path;
        final boolean relative;

        Item(String packageName, String path, boolean relative) {
            this.packageName = packageName;
            this.path = path;
            this.relative = relative;
            if (Extern.this.packageToItemMap == null) {
                Extern.this.packageToItemMap = new HashMap();
            }
            if (!Extern.this.packageToItemMap.containsKey(packageName)) {
                Extern.this.packageToItemMap.put(packageName, this);
            }
        }

        public String toString() {
            return this.packageName + (this.relative ? " -> " : " => ") + this.path;
        }
    }
}

