/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.util.ArrayList;

public class MetaKeywords {
    private final Configuration configuration;

    public MetaKeywords(Configuration configuration) {
        this.configuration = configuration;
    }

    public String[] getMetaKeywords(ClassDoc classdoc) {
        ArrayList<String> results = new ArrayList<String>();
        if (this.configuration.keywords) {
            results.addAll(this.getClassKeyword(classdoc));
            results.addAll(this.getMemberKeywords(classdoc.fields()));
            results.addAll(this.getMemberKeywords(classdoc.methods()));
        }
        return results.toArray(new String[0]);
    }

    protected ArrayList<String> getClassKeyword(ClassDoc classdoc) {
        String cltypelower = classdoc.isInterface() ? "interface" : "class";
        ArrayList<String> metakeywords = new ArrayList<String>(1);
        metakeywords.add(classdoc.qualifiedName() + " " + cltypelower);
        return metakeywords;
    }

    public String[] getMetaKeywords(PackageDoc packageDoc) {
        if (this.configuration.keywords) {
            String pkgName = Util.getPackageName(packageDoc);
            return new String[]{pkgName + " package"};
        }
        return new String[0];
    }

    public String[] getMetaKeywords(Profile profile) {
        if (this.configuration.keywords) {
            String profileName = profile.name;
            return new String[]{profileName + " profile"};
        }
        return new String[0];
    }

    public String[] getOverviewMetaKeywords(String title, String docTitle) {
        if (this.configuration.keywords) {
            String windowOverview = this.configuration.getText(title);
            String[] metakeywords = new String[]{windowOverview};
            if (docTitle.length() > 0) {
                metakeywords[0] = metakeywords[0] + ", " + docTitle;
            }
            return metakeywords;
        }
        return new String[0];
    }

    protected ArrayList<String> getMemberKeywords(MemberDoc[] memberdocs) {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < memberdocs.length; ++i) {
            String membername = memberdocs[i].name() + (memberdocs[i].isMethod() ? "()" : "");
            if (results.contains(membername)) continue;
            results.add(membername);
        }
        return results;
    }
}

