/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.javadoc.main;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.oldlets.javadoc.main.ClassDocImpl;
import com.sun.tools.oldlets.javadoc.main.DocEnv;
import com.sun.tools.oldlets.javadoc.main.DocImpl;
import com.sun.tools.oldlets.javadoc.main.JavaScriptScanner;
import com.sun.tools.oldlets.javadoc.main.PackageDocImpl;
import com.sun.tools.oldlets.javadoc.main.SourcePositionImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class RootDocImpl
extends DocImpl
implements RootDoc {
    private List<ClassDocImpl> cmdLineClasses;
    private List<PackageDocImpl> cmdLinePackages;
    private List<String[]> options;

    public RootDocImpl(DocEnv env, List<JCTree.JCClassDecl> classes, List<String> packages, List<String[]> options) {
        super(env, null);
        this.options = options;
        this.setPackages(env, packages);
        this.setClasses(env, classes);
    }

    public RootDocImpl(DocEnv env, List<String> classes, List<String[]> options) {
        super(env, null);
        this.options = options;
        this.cmdLinePackages = List.nil();
        ListBuffer<ClassDocImpl> classList = new ListBuffer<ClassDocImpl>();
        for (String className : classes) {
            ClassDocImpl c = env.loadClass(className);
            if (c == null) {
                env.error(null, "javadoc.class_not_found", className);
                continue;
            }
            classList = classList.append(c);
        }
        this.cmdLineClasses = classList.toList();
    }

    private void setClasses(DocEnv env, List<JCTree.JCClassDecl> classes) {
        ListBuffer<ClassDocImpl> result = new ListBuffer<ClassDocImpl>();
        for (JCTree.JCClassDecl def : classes) {
            ClassDocImpl cd;
            if (!env.shouldDocument(def.sym) || (cd = env.getClassDoc(def.sym)) == null) continue;
            cd.isIncluded = true;
            result.append(cd);
        }
        this.cmdLineClasses = result.toList();
    }

    private void setPackages(DocEnv env, List<String> packages) {
        ListBuffer<PackageDocImpl> packlist = new ListBuffer<PackageDocImpl>();
        for (String name : packages) {
            PackageDocImpl pkg = env.lookupPackage(name);
            if (pkg != null) {
                pkg.isIncluded = true;
                packlist.append(pkg);
                continue;
            }
            env.warning(null, "main.no_source_files_for_package", name);
        }
        this.cmdLinePackages = packlist.toList();
    }

    @Override
    public String[][] options() {
        return (String[][])this.options.toArray((T[])new String[this.options.length()][]);
    }

    @Override
    public PackageDoc[] specifiedPackages() {
        return this.cmdLinePackages.toArray(new PackageDocImpl[this.cmdLinePackages.length()]);
    }

    @Override
    public ClassDoc[] specifiedClasses() {
        ListBuffer<ClassDocImpl> classesToDocument = new ListBuffer<ClassDocImpl>();
        for (ClassDocImpl cd : this.cmdLineClasses) {
            cd.addAllClasses(classesToDocument, true);
        }
        return classesToDocument.toArray(new ClassDocImpl[classesToDocument.length()]);
    }

    @Override
    public ClassDoc[] classes() {
        ListBuffer<ClassDocImpl> classesToDocument = new ListBuffer<ClassDocImpl>();
        for (ClassDocImpl cd : this.cmdLineClasses) {
            cd.addAllClasses(classesToDocument, true);
        }
        for (PackageDocImpl pd : this.cmdLinePackages) {
            pd.addAllClassesTo(classesToDocument);
        }
        return classesToDocument.toArray(new ClassDocImpl[classesToDocument.length()]);
    }

    @Override
    public ClassDoc classNamed(String qualifiedName) {
        return this.env.lookupClass(qualifiedName);
    }

    @Override
    public PackageDoc packageNamed(String name) {
        return this.env.lookupPackage(name);
    }

    @Override
    public String name() {
        return "*RootDocImpl*";
    }

    @Override
    public String qualifiedName() {
        return "*RootDocImpl*";
    }

    @Override
    public boolean isIncluded() {
        return false;
    }

    @Override
    public void printError(String msg) {
        this.env.printError(msg);
    }

    @Override
    public void printError(SourcePosition pos, String msg) {
        this.env.printError(pos, msg);
    }

    @Override
    public void printWarning(String msg) {
        this.env.printWarning(msg);
    }

    @Override
    public void printWarning(SourcePosition pos, String msg) {
        this.env.printWarning(pos, msg);
    }

    @Override
    public void printNotice(String msg) {
        this.env.printNotice(msg);
    }

    @Override
    public void printNotice(SourcePosition pos, String msg) {
        this.env.printNotice(pos, msg);
    }

    private JavaFileObject getOverviewPath() {
        for (String[] opt : this.options) {
            if (!opt[0].equals("-overview") || !(this.env.fileManager instanceof StandardJavaFileManager)) continue;
            StandardJavaFileManager fm = (StandardJavaFileManager)this.env.fileManager;
            return fm.getJavaFileObjects(opt[1]).iterator().next();
        }
        return null;
    }

    @Override
    protected String documentation() {
        if (this.documentation == null) {
            JavaFileObject overviewPath = this.getOverviewPath();
            if (overviewPath == null) {
                this.documentation = "";
            } else {
                try {
                    this.documentation = this.readHTMLDocumentation(overviewPath.openInputStream(), overviewPath);
                }
                catch (IOException exc) {
                    this.documentation = "";
                    this.env.error(null, "javadoc.File_Read_Error", overviewPath.getName());
                }
            }
        }
        return this.documentation;
    }

    @Override
    public SourcePosition position() {
        JavaFileObject path = this.getOverviewPath();
        return path == null ? null : SourcePositionImpl.make(path, -1, null);
    }

    public Locale getLocale() {
        return this.env.doclocale.locale;
    }

    public JavaFileManager getFileManager() {
        return this.env.fileManager;
    }

    public void initDocLint(Collection<String> opts, Collection<String> customTagNames, String htmlVersion) {
        this.env.initDoclint(opts, customTagNames, htmlVersion);
    }

    public JavaScriptScanner initJavaScriptScanner(boolean allowScriptInComments) {
        return this.env.initJavaScriptScanner(allowScriptInComments);
    }

    public boolean isFunctionalInterface(AnnotationDesc annotationDesc) {
        return RootDocImpl.allowedInSource(this.env.source) && annotationDesc.annotationType().qualifiedName().equals(this.env.syms.functionalInterfaceType.toString());
    }

    public boolean showTagMessages() {
        return this.env.showTagMessages();
    }

    private static boolean allowedInSource(Source source) {
        return Source.lookup("1.8").compareTo(source) >= 0;
    }
}

