/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.androlib.res.xml.ResXmlEncoders;
import java.io.IOException;
import org.apache.commons.lang3.tuple.Pair;
import org.xmlpull.v1.XmlSerializer;

public class ResPluralsValue
extends ResBagValue
implements ResValuesXmlSerializable {
    private static final String[] QUANTITY_MAP = new String[]{"other", "zero", "one", "two", "few", "many"};
    private static final int BAG_KEY_PLURALS_START = 0x1000004;
    private final ResScalarValue[] mItems = new ResScalarValue[6];

    ResPluralsValue(ResReferenceValue parent, Pair<Integer, ResScalarValue>[] items) {
        super(parent);
        for (Pair<Integer, ResScalarValue> item : items) {
            this.mItems[((Integer)item.getLeft()).intValue() - 0x1000004] = (ResScalarValue)item.getRight();
        }
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws AndrolibException, IOException {
        serializer.startTag(null, "plurals");
        serializer.attribute(null, "name", res.getResSpec().getName());
        for (int i = 0; i < this.mItems.length; ++i) {
            ResScalarValue item = this.mItems[i];
            if (item == null) continue;
            serializer.startTag(null, "item");
            serializer.attribute(null, "quantity", QUANTITY_MAP[i]);
            serializer.text(ResXmlEncoders.enumerateNonPositionalSubstitutionsIfRequired(item.encodeAsResXmlNonEscapedItemValue()));
            serializer.endTag(null, "item");
        }
        serializer.endTag(null, "plurals");
    }
}

