/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import com.android.tools.smali.baksmali.Main;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public final class ApktoolProperties
extends Properties {
    private static final Logger LOGGER = Logger.getLogger(ApktoolProperties.class.getName());
    private static volatile ApktoolProperties sInstance;

    private static String get(String key, String defaultValue) {
        if (sInstance == null) {
            sInstance = new ApktoolProperties();
        }
        return sInstance.getProperty(key, defaultValue);
    }

    public static String getVersion() {
        return ApktoolProperties.get("application.version", "(unknown)");
    }

    public static String getSmaliVersion() {
        return ApktoolProperties.get("smali.version", "(unknown)");
    }

    public static String getBaksmaliVersion() {
        return ApktoolProperties.get("baksmali.version", "(unknown)");
    }

    private ApktoolProperties() {
        ApktoolProperties.load(this, this.getClass(), "/apktool.properties");
        Properties smaliProps = new Properties();
        ApktoolProperties.load(smaliProps, com.android.tools.smali.smali.Main.class, "/smali.properties");
        String smaliVersion = smaliProps.getProperty("application.version", "");
        if (!smaliVersion.isEmpty()) {
            this.put("smali.version", smaliVersion);
        }
        Properties baksmaliProps = new Properties();
        ApktoolProperties.load(baksmaliProps, Main.class, "/baksmali.properties");
        String baksmaliVersion = baksmaliProps.getProperty("application.version", "");
        if (!baksmaliVersion.isEmpty()) {
            this.put("baksmali.version", baksmaliVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(Properties props, Class<?> clz, String name) {
        InputStream in = null;
        try {
            in = clz.getResourceAsStream(name);
            if (in == null) {
                throw new FileNotFoundException(name);
            }
            props.load(in);
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.warning("Could not find " + clz.getName());
        }
        catch (IOException ex) {
            LOGGER.warning("Could not load " + name);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

