/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.meta;

import brut.androlib.ApktoolProperties;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.meta.PackageInfo;
import brut.androlib.meta.SdkInfo;
import brut.androlib.meta.UsesFramework;
import brut.androlib.meta.VersionInfo;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.yaml.YamlLine;
import brut.yaml.YamlReader;
import brut.yaml.YamlSerializable;
import brut.yaml.YamlWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ApkInfo
implements YamlSerializable {
    public static final String[] RESOURCES_DIRNAMES = new String[]{"res", "r", "R"};
    public static final String[] RAW_DIRNAMES = new String[]{"assets", "lib"};
    public static final Pattern ORIGINAL_FILENAMES_PATTERN = Pattern.compile("AndroidManifest\\.xml|META-INF/[^/]+\\.(RSA|SF|MF)|stamp-cert-sha256");
    public static final Pattern STANDARD_FILENAMES_PATTERN = Pattern.compile("[^/]+\\.dex|resources\\.arsc|(" + String.join((CharSequence)"|", RESOURCES_DIRNAMES) + "|" + String.join((CharSequence)"|", RAW_DIRNAMES) + ")/.*|" + ORIGINAL_FILENAMES_PATTERN.pattern());
    private String mVersion = ApktoolProperties.getVersion();
    private String mApkFileName = null;
    private final UsesFramework mUsesFramework = new UsesFramework();
    private final List<String> mUsesLibrary = new ArrayList<String>();
    private final SdkInfo mSdkInfo = new SdkInfo();
    private final PackageInfo mPackageInfo = new PackageInfo();
    private final VersionInfo mVersionInfo = new VersionInfo();
    private final Map<String, Boolean> mFeatureFlags = new LinkedHashMap<String, Boolean>();
    private Boolean mSparseResources = null;
    private Boolean mCompactEntries = null;
    private final List<String> mDoNotCompress = new ArrayList<String>();
    private ExtFile mApkFile;

    public ApkInfo() {
    }

    public ApkInfo(ExtFile apkFile) {
        this();
        this.setApkFile(apkFile);
    }

    public static ApkInfo load(InputStream in) {
        YamlReader reader = new YamlReader(in);
        ApkInfo apkInfo = new ApkInfo();
        reader.readRoot((YamlSerializable)apkInfo);
        return apkInfo;
    }

    public static ApkInfo load(ExtFile apkDir) throws AndrolibException {
        ApkInfo apkInfo;
        block8: {
            InputStream in = apkDir.getDirectory().getFileInput("apktool.yml");
            try {
                ApkInfo apkInfo2 = ApkInfo.load(in);
                apkInfo2.setApkFile(apkDir);
                apkInfo = apkInfo2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryException | IOException ex) {
                    throw new AndrolibException(ex);
                }
            }
            in.close();
        }
        return apkInfo;
    }

    public void save(File file) throws AndrolibException {
        try (YamlWriter writer = new YamlWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            this.write(writer);
        }
        catch (FileNotFoundException ex) {
            throw new AndrolibException("File not found");
        }
        catch (Exception ex) {
            throw new AndrolibException(ex);
        }
    }

    public void readItem(YamlReader reader) {
        YamlLine line = reader.getLine();
        switch (line.getKey()) {
            case "version": {
                this.mVersion = line.getValue();
                break;
            }
            case "apkFileName": {
                this.mApkFileName = line.getValue();
                break;
            }
            case "usesFramework": {
                this.mUsesFramework.clear();
                reader.readObject((YamlSerializable)this.mUsesFramework);
                break;
            }
            case "usesLibrary": {
                this.mUsesLibrary.clear();
                reader.readStringList(this.mUsesLibrary);
                break;
            }
            case "sdkInfo": {
                this.mSdkInfo.clear();
                reader.readObject((YamlSerializable)this.mSdkInfo);
                break;
            }
            case "packageInfo": {
                this.mPackageInfo.clear();
                reader.readObject((YamlSerializable)this.mPackageInfo);
                break;
            }
            case "versionInfo": {
                this.mVersionInfo.clear();
                reader.readObject((YamlSerializable)this.mVersionInfo);
                break;
            }
            case "featureFlags": {
                this.mFeatureFlags.clear();
                reader.readBoolMap(this.mFeatureFlags);
                break;
            }
            case "sparseResources": {
                this.mSparseResources = line.getValueBool();
                break;
            }
            case "compactEntries": {
                this.mCompactEntries = line.getValueBool();
                break;
            }
            case "doNotCompress": {
                this.mDoNotCompress.clear();
                reader.readStringList(this.mDoNotCompress);
            }
        }
    }

    public void write(YamlWriter writer) {
        writer.writeString("version", this.mVersion);
        writer.writeString("apkFileName", this.mApkFileName);
        if (!this.mUsesFramework.isEmpty()) {
            writer.writeObject("usesFramework", (YamlSerializable)this.mUsesFramework);
        }
        if (!this.mUsesLibrary.isEmpty()) {
            writer.writeList("usesLibrary", this.mUsesLibrary);
        }
        if (!this.mSdkInfo.isEmpty()) {
            writer.writeObject("sdkInfo", (YamlSerializable)this.mSdkInfo);
        }
        if (!this.mPackageInfo.isEmpty()) {
            writer.writeObject("packageInfo", (YamlSerializable)this.mPackageInfo);
        }
        if (!this.mVersionInfo.isEmpty()) {
            writer.writeObject("versionInfo", (YamlSerializable)this.mVersionInfo);
        }
        if (!this.mFeatureFlags.isEmpty()) {
            writer.writeMap("featureFlags", this.mFeatureFlags);
        }
        if (this.mSparseResources != null) {
            writer.writeBool("sparseResources", this.mSparseResources.booleanValue());
        }
        if (this.mCompactEntries != null) {
            writer.writeBool("compactEntries", this.mCompactEntries.booleanValue());
        }
        if (!this.mDoNotCompress.isEmpty()) {
            writer.writeList("doNotCompress", this.mDoNotCompress);
        }
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public String getApkFileName() {
        return this.mApkFileName;
    }

    public void setApkFileName(String apkFileName) {
        this.mApkFileName = apkFileName;
    }

    public UsesFramework getUsesFramework() {
        return this.mUsesFramework;
    }

    public List<String> getUsesLibrary() {
        return this.mUsesLibrary;
    }

    public SdkInfo getSdkInfo() {
        return this.mSdkInfo;
    }

    public PackageInfo getPackageInfo() {
        return this.mPackageInfo;
    }

    public VersionInfo getVersionInfo() {
        return this.mVersionInfo;
    }

    public Map<String, Boolean> getFeatureFlags() {
        return this.mFeatureFlags;
    }

    public boolean isSparseResources() {
        return this.mSparseResources != null ? this.mSparseResources : false;
    }

    public void setSparseResources(boolean sparseResources) {
        this.mSparseResources = sparseResources;
    }

    public boolean isCompactEntries() {
        return this.mCompactEntries != null ? this.mCompactEntries : false;
    }

    public void setCompactEntries(boolean compactEntries) {
        this.mCompactEntries = compactEntries;
    }

    public List<String> getDoNotCompress() {
        return this.mDoNotCompress;
    }

    public ExtFile getApkFile() {
        return this.mApkFile;
    }

    public void setApkFile(ExtFile apkFile) {
        this.mApkFile = apkFile;
        if (this.mApkFileName == null) {
            this.mApkFileName = apkFile.getName();
        }
    }

    public boolean hasSources() throws AndrolibException {
        if (this.mApkFile == null) {
            return false;
        }
        try {
            return this.mApkFile.getDirectory().containsFile("classes.dex");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasManifest() throws AndrolibException {
        if (this.mApkFile == null) {
            return false;
        }
        try {
            return this.mApkFile.getDirectory().containsFile("AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasResources() throws AndrolibException {
        if (this.mApkFile == null) {
            return false;
        }
        try {
            return this.mApkFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }
}

