/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class ResValuesFile {
    private final ResPackage mPackage;
    private final ResTypeSpec mType;
    private final ResType mConfig;
    private final Set<ResResource> mResources;

    public ResValuesFile(ResPackage pkg, ResTypeSpec type, ResType config) {
        this.mPackage = pkg;
        this.mType = type;
        this.mConfig = config;
        this.mResources = new LinkedHashSet<ResResource>();
    }

    public String getPath() {
        return "values" + this.mConfig.getFlags().getQualifiers() + "/" + this.mType.getName() + (this.mType.getName().endsWith("s") ? "" : "s") + ".xml";
    }

    public Set<ResResource> listResources() {
        return this.mResources;
    }

    public ResTypeSpec getType() {
        return this.mType;
    }

    public boolean isSynthesized(ResResource res) {
        return this.mPackage.isSynthesized(res.getResSpec().getId());
    }

    public void addResource(ResResource res) {
        this.mResources.add(res);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResValuesFile) {
            ResValuesFile other = (ResValuesFile)obj;
            return Objects.equals(this.mType, other.mType) && Objects.equals(this.mConfig, other.mConfig);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mConfig);
    }
}

