/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.arsc.FlagItem;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;
import org.xmlpull.v1.XmlSerializer;

public class ResFlagsAttr
extends ResAttr {
    private static final Logger LOGGER = Logger.getLogger(ResFlagsAttr.class.getName());
    private final FlagItem[] mItems;
    private FlagItem[] mZeroFlags;
    private FlagItem[] mFlags;

    ResFlagsAttr(ResReferenceValue parent, int type, Integer min, Integer max, Boolean l10n, Pair<ResReferenceValue, ResScalarValue>[] items) {
        super(parent, type, min, max, l10n);
        this.mItems = new FlagItem[items.length];
        for (int i = 0; i < items.length; ++i) {
            Pair<ResReferenceValue, ResScalarValue> item = items[i];
            this.mItems[i] = new FlagItem((ResReferenceValue)item.getLeft(), ((ResScalarValue)item.getRight()).getRawIntValue());
        }
    }

    @Override
    public String convertToResXmlFormat(ResScalarValue value) throws AndrolibException {
        if (value instanceof ResReferenceValue) {
            return value.encodeAsResXml();
        }
        if (!(value instanceof ResIntValue)) {
            return super.convertToResXmlFormat(value);
        }
        this.loadFlags();
        int intVal = ((ResIntValue)value).getValue();
        if (intVal == 0) {
            return this.renderFlags(this.mZeroFlags);
        }
        FlagItem[] flags = new FlagItem[this.mFlags.length];
        int flagsCount = 0;
        int flagsInt = 0;
        for (FlagItem item : this.mFlags) {
            int flag = item.flag;
            if ((intVal & flag) != flag || (flagsInt & flag) == flag) continue;
            flags[flagsCount++] = item;
            if (intVal == (flagsInt |= flag)) break;
        }
        if (flagsCount == 0) {
            throw new AndrolibException(String.format("invalid flags in value: 0x%08x", intVal));
        }
        if (flagsCount > 2) {
            FlagItem[] filtered = new FlagItem[flagsCount];
            int filteredCount = 0;
            for (int i = 0; i < flagsCount; ++i) {
                FlagItem item;
                item = flags[i];
                int mask = 0;
                for (int j = 0; j < flagsCount; ++j) {
                    FlagItem other = flags[j];
                    if (j == i || other == null) continue;
                    mask |= other.flag;
                }
                if ((item.flag & ~mask) != 0) {
                    filtered[filteredCount++] = item;
                    continue;
                }
                flags[i] = null;
            }
            flags = filtered;
            flagsCount = filteredCount;
        }
        if (flagsCount != flags.length) {
            flags = Arrays.copyOf(flags, flagsCount);
        }
        return this.renderFlags(flags);
    }

    @Override
    protected void serializeBody(XmlSerializer serializer, ResResource res) throws AndrolibException, IOException {
        for (FlagItem item : this.mItems) {
            ResResSpec referent = item.ref.getReferent();
            if (referent == null && this.mConfig.getDecodeResolve() == Config.DecodeResolve.REMOVE) {
                LOGGER.fine(String.format("null flag reference: 0x%08x(%s)", item.ref.getValue(), item.ref.getType()));
                continue;
            }
            serializer.startTag(null, "flag");
            serializer.attribute(null, "name", item.getValue());
            serializer.attribute(null, "value", String.format("0x%08x", item.flag));
            serializer.endTag(null, "flag");
        }
    }

    private String renderFlags(FlagItem[] flags) throws AndrolibException {
        StringBuilder sb = new StringBuilder();
        for (FlagItem flag : flags) {
            sb.append("|").append(flag.getValue());
        }
        if (sb.length() == 0) {
            return sb.toString();
        }
        return sb.substring(1);
    }

    private void loadFlags() {
        if (this.mFlags != null) {
            return;
        }
        FlagItem[] zeroFlags = new FlagItem[this.mItems.length];
        int zeroFlagsCount = 0;
        FlagItem[] flags = new FlagItem[this.mItems.length];
        int flagsCount = 0;
        for (FlagItem item2 : this.mItems) {
            if (item2.flag == 0) {
                zeroFlags[zeroFlagsCount++] = item2;
                continue;
            }
            flags[flagsCount++] = item2;
        }
        this.mZeroFlags = Arrays.copyOf(zeroFlags, zeroFlagsCount);
        this.mFlags = Arrays.copyOf(flags, flagsCount);
        Arrays.sort(this.mFlags, Comparator.comparingInt(item -> Integer.bitCount(item.flag)).reversed().thenComparingInt(item -> item.flag));
    }
}

