/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.value.ResIntValue;

public class ResReferenceValue
extends ResIntValue {
    private final ResPackage mPackage;
    private final boolean mTheme;

    public ResReferenceValue(ResPackage pkg, int value, String rawValue) {
        this(pkg, value, rawValue, false);
    }

    public ResReferenceValue(ResPackage pkg, int value, String rawValue, boolean theme) {
        super(value, rawValue, "reference");
        this.mPackage = pkg;
        this.mTheme = theme;
    }

    @Override
    protected String encodeAsResXml() throws AndrolibException {
        ResResSpec spec;
        ResResSpec resResSpec = spec = !this.isNull() ? this.getReferent() : null;
        if (spec == null) {
            return "@null";
        }
        String prefix = this.mTheme ? "?" : "@";
        boolean excludeType = this.mTheme && spec.getType().getName().equals("attr");
        return prefix + spec.getFullName(this.mPackage, excludeType);
    }

    public ResPackage getPackage() {
        return this.mPackage;
    }

    public ResResSpec getReferent() throws AndrolibException {
        try {
            return this.mPackage.getResTable().getResSpec(this.getValue());
        }
        catch (UndefinedResObjectException ex) {
            return null;
        }
    }

    public boolean isNull() {
        return this.mValue == 0;
    }

    public boolean referentIsNull() throws AndrolibException {
        return this.getReferent() == null;
    }
}

