/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;
import org.xmlpull.v1.XmlSerializer;

public class ResStyleValue
extends ResBagValue
implements ResValuesXmlSerializable {
    private static final Logger LOGGER = Logger.getLogger(ResStyleValue.class.getName());
    private final Pair<ResReferenceValue, ResScalarValue>[] mItems;

    ResStyleValue(ResReferenceValue parent, Pair<Integer, ResScalarValue>[] items, ResValueFactory factory) {
        super(parent);
        this.mItems = new Pair[items.length];
        for (int i = 0; i < items.length; ++i) {
            Pair<Integer, ResScalarValue> item = items[i];
            this.mItems[i] = Pair.of((Object)factory.newReference((Integer)item.getLeft(), null), (Object)((ResScalarValue)item.getRight()));
        }
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws AndrolibException, IOException {
        serializer.startTag(null, "style");
        serializer.attribute(null, "name", res.getResSpec().getName());
        if (!this.mParent.isNull() && !this.mParent.referentIsNull()) {
            serializer.attribute(null, "parent", this.mParent.encodeAsResXmlAttr());
        } else if (res.getResSpec().getName().indexOf(46) != -1) {
            serializer.attribute(null, "parent", "");
        }
        HashSet<String> processedNames = new HashSet<String>();
        for (Pair<ResReferenceValue, ResScalarValue> item : this.mItems) {
            String name;
            ResReferenceValue ref = (ResReferenceValue)item.getLeft();
            ResScalarValue val = (ResScalarValue)item.getRight();
            ResResSpec spec = ref.getReferent();
            if (spec == null) {
                LOGGER.fine(String.format("null style reference: ref=0x%08x(%s), val=0x%08x(%s)", ref.getRawIntValue(), ref.getType(), val.getRawIntValue(), val.getType()));
                continue;
            }
            String value = null;
            ResValue resource = spec.getDefaultResource().getValue();
            if (resource instanceof ResReferenceValue) continue;
            if (resource instanceof ResAttr) {
                ResAttr attr = (ResAttr)resource;
                value = attr.convertToResXmlFormat(val);
                name = spec.getFullName(res.getResSpec().getPackage(), true);
            } else {
                name = "@" + spec.getFullName(res.getResSpec().getPackage(), false);
            }
            if (!this.mConfig.isAnalysisMode() && processedNames.contains(name)) continue;
            if (value == null) {
                value = val.encodeAsResXmlValue();
            }
            if (value == null) continue;
            serializer.startTag(null, "item");
            serializer.attribute(null, "name", name);
            serializer.text(value);
            serializer.endTag(null, "item");
            processedNames.add(name);
        }
        serializer.endTag(null, "style");
        processedNames.clear();
    }
}

