/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import brut.androlib.res.data.arsc.ARSCData;
import brut.androlib.res.data.arsc.ARSCHeader;
import brut.androlib.res.data.arsc.EntryData;
import brut.androlib.res.data.arsc.FlagsOffset;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResIntBasedValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.decoder.StringBlock;
import brut.util.ExtDataInput;
import brut.util.ExtDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;

public class ARSCDecoder {
    private static final Logger LOGGER = Logger.getLogger(ARSCDecoder.class.getName());
    private static final int ENTRY_FLAG_COMPLEX = 1;
    private static final int ENTRY_FLAG_PUBLIC = 2;
    private static final int ENTRY_FLAG_WEAK = 4;
    private static final int ENTRY_FLAG_COMPACT = 8;
    private static final int TABLE_TYPE_FLAG_SPARSE = 1;
    private static final int TABLE_TYPE_FLAG_OFFSET16 = 2;
    private static final int KNOWN_CONFIG_BYTES = 64;
    private static final int NO_ENTRY = -1;
    private static final int NO_ENTRY_OFFSET16 = 65535;
    private final ExtDataInputStream mIn;
    private final ResTable mResTable;
    private final List<FlagsOffset> mFlagsOffsets;
    private final boolean mKeepBroken;
    private final Config mConfig;
    private final Map<Integer, ResTypeSpec> mResTypeSpecs;
    private final Map<Integer, Integer> mMissingResSpecs;
    private final Set<ResConfigFlags> mInvalidResConfigFlags;
    private ARSCHeader mHeader;
    private StringBlock mTableStrings;
    private StringBlock mTypeNames;
    private StringBlock mSpecNames;
    private ResPackage mPackage;
    private ResTypeSpec mTypeSpec;
    private ResType mType;
    private int mResId;
    private int mTypeIdOffset;

    public ARSCDecoder(InputStream in, ResTable resTable, boolean storeFlagsOffsets, boolean keepBroken) {
        this.mIn = ExtDataInputStream.littleEndian((InputStream)in);
        this.mResTable = resTable;
        this.mFlagsOffsets = storeFlagsOffsets ? new ArrayList() : null;
        this.mKeepBroken = keepBroken;
        this.mConfig = resTable.getConfig();
        this.mResTypeSpecs = new HashMap<Integer, ResTypeSpec>();
        this.mMissingResSpecs = new LinkedHashMap<Integer, Integer>();
        this.mInvalidResConfigFlags = new HashSet<ResConfigFlags>();
    }

    public ARSCData decode() throws AndrolibException {
        try {
            ResPackage[] pkgs = this.readResourceTable();
            FlagsOffset[] flagsOffsets = this.mFlagsOffsets != null ? this.mFlagsOffsets.toArray(new FlagsOffset[0]) : null;
            return new ARSCData(pkgs, flagsOffsets);
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not decode arsc file", ex);
        }
    }

    private ResPackage[] readResourceTable() throws AndrolibException, IOException {
        LinkedHashSet<ResPackage> pkgs = new LinkedHashSet<ResPackage>();
        int chunkNumber = 1;
        block12: while (true) {
            this.mHeader = ARSCHeader.read((ExtDataInput)this.mIn);
            LOGGER.fine(String.format("Chunk #%d start=0x%08x type=0x%04x chunkSize=0x%08x", chunkNumber++, this.mIn.position(), this.mHeader.type, this.mHeader.chunkSize));
            switch (this.mHeader.type) {
                case 0: {
                    this.readUnknownChunk();
                    continue block12;
                }
                case 1: {
                    this.readStringPoolChunk();
                    continue block12;
                }
                case 2: {
                    this.readTableChunk();
                    continue block12;
                }
                case 512: {
                    this.mTypeIdOffset = 0;
                    pkgs.add(this.readTablePackage());
                    continue block12;
                }
                case 513: {
                    this.readTableType();
                    continue block12;
                }
                case 514: {
                    ResTypeSpec typeSpec = this.readTableSpecType();
                    this.mResTypeSpecs.put(typeSpec.getId(), typeSpec);
                    continue block12;
                }
                case 515: {
                    this.readLibraryType();
                    continue block12;
                }
                case 516: {
                    this.readOverlaySpec();
                    continue block12;
                }
                case 517: {
                    this.readOverlayPolicySpec();
                    continue block12;
                }
                case 518: {
                    this.readStagedAliasSpec();
                    continue block12;
                }
            }
            break;
        }
        if (this.mHeader.type != -1) {
            LOGGER.severe(String.format("Unknown chunk type: %04x", this.mHeader.type));
        }
        if (this.mConfig.getDecodeResolve() == Config.DecodeResolve.DUMMY && this.mPackage != null && this.mPackage.getResSpecCount() > 0) {
            this.addMissingResSpecs();
        }
        return pkgs.toArray(new ResPackage[0]);
    }

    private void readStringPoolChunk() throws AndrolibException, IOException {
        this.checkChunkType(1);
        this.mTableStrings = StringBlock.readWithoutChunk((ExtDataInput)this.mIn, this.mHeader.startPosition, this.mHeader.headerSize, this.mHeader.chunkSize);
    }

    private void readTableChunk() throws AndrolibException, IOException {
        this.checkChunkType(2);
        this.mIn.skipInt();
        this.mHeader.checkForUnreadHeader((ExtDataInput)this.mIn);
    }

    private void readUnknownChunk() throws AndrolibException, IOException {
        this.checkChunkType(0);
        this.mHeader.checkForUnreadHeader((ExtDataInput)this.mIn);
        LOGGER.warning("Skipping unknown chunk data of size " + this.mHeader.chunkSize);
        this.mIn.jumpTo(this.mHeader.endPosition);
    }

    private ResPackage readTablePackage() throws AndrolibException, IOException {
        this.checkChunkType(512);
        int id = this.mIn.readInt();
        String name = this.mIn.readUtf16(128);
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        int splitHeaderSize = 288;
        if (this.mHeader.headerSize == splitHeaderSize) {
            this.mTypeIdOffset = this.mIn.readInt();
        }
        if (this.mTypeIdOffset > 0) {
            LOGGER.warning("Please report this application to Apktool for a fix: https://github.com/iBotPeaches/Apktool/issues/1728");
        }
        this.mHeader.checkForUnreadHeader((ExtDataInput)this.mIn);
        this.mTypeNames = StringBlock.readWithChunk((ExtDataInput)this.mIn);
        this.mSpecNames = StringBlock.readWithChunk((ExtDataInput)this.mIn);
        if (id == 0 && this.mResTable.isMainPackageLoaded()) {
            id = this.mResTable.getDynamicRefPackageId(name);
        }
        this.mResId = id << 24;
        this.mPackage = new ResPackage(this.mResTable, id, name);
        return this.mPackage;
    }

    private void readLibraryType() throws AndrolibException, IOException {
        this.checkChunkType(515);
        int libraryCount = this.mIn.readInt();
        this.mHeader.checkForUnreadHeader((ExtDataInput)this.mIn);
        for (int i = 0; i < libraryCount; ++i) {
            int id = this.mIn.readInt();
            String name = this.mIn.readUtf16(128);
            this.mResTable.addDynamicRefPackage(id, name);
            LOGGER.fine(String.format("Shared library id: %d, name: \"%s\"", id, name));
        }
    }

    private void readStagedAliasSpec() throws IOException {
        int count = this.mIn.readInt();
        this.mHeader.checkForUnreadHeader((ExtDataInput)this.mIn);
        for (int i = 0; i < count; ++i) {
            LOGGER.fine(String.format("Staged alias: 0x%08x -> 0x%08x", this.mIn.readInt(), this.mIn.readInt()));
        }
    }

    private void readOverlaySpec() throws AndrolibException, IOException {
        this.checkChunkType(516);
        String name = this.mIn.readUtf16(256);
        String actor = this.mIn.readUtf16(256);
        this.mHeader.checkForUnreadHeader((ExtDataInput)this.mIn);
        LOGGER.fine(String.format("Overlay name: \"%s\", actor: \"%s\"", name, actor));
    }

    private void readOverlayPolicySpec() throws AndrolibException, IOException {
        this.checkChunkType(517);
        this.mIn.skipInt();
        int count = this.mIn.readInt();
        this.mHeader.checkForUnreadHeader((ExtDataInput)this.mIn);
        for (int i = 0; i < count; ++i) {
            LOGGER.fine(String.format("Skipping overlay (%h)", this.mIn.readInt()));
        }
    }

    private ResTypeSpec readTableSpecType() throws AndrolibException, IOException {
        this.checkChunkType(514);
        int id = this.mIn.readUnsignedByte();
        this.mIn.skipByte();
        this.mIn.skipShort();
        int entryCount = this.mIn.readInt();
        if (this.mFlagsOffsets != null) {
            this.mFlagsOffsets.add(new FlagsOffset((int)this.mIn.position(), entryCount));
        }
        this.mHeader.checkForUnreadHeader((ExtDataInput)this.mIn);
        for (int i = 0; i < entryCount; ++i) {
            this.mIn.skipInt();
        }
        this.mTypeSpec = new ResTypeSpec(this.mTypeNames.getString(id - 1), id);
        this.mPackage.addType(this.mTypeSpec);
        return this.mTypeSpec;
    }

    private ResType readTableType() throws AndrolibException, IOException {
        boolean isSparse;
        this.checkChunkType(513);
        int typeId = this.mIn.readUnsignedByte() - this.mTypeIdOffset;
        if (this.mResTypeSpecs.containsKey(typeId)) {
            this.mTypeSpec = this.mResTypeSpecs.get(typeId);
        } else {
            this.mTypeSpec = new ResTypeSpec(this.mTypeNames.getString(typeId - 1), typeId);
            this.mResTypeSpecs.put(this.mTypeSpec.getId(), this.mTypeSpec);
            this.mPackage.addType(this.mTypeSpec);
        }
        this.mResId = this.mResId & 0xFF000000 | this.mTypeSpec.getId() << 16;
        int typeFlags = this.mIn.readUnsignedByte();
        this.mIn.skipShort();
        int entryCount = this.mIn.readInt();
        int entriesStart = this.mIn.readInt();
        long entriesStartAligned = this.mHeader.startPosition + (long)entriesStart;
        ResConfigFlags flags = this.readConfigFlags();
        this.mIn.mark(this.mHeader.chunkSize);
        this.mHeader.checkForUnreadHeader((ExtDataInput)this.mIn);
        boolean isOffset16 = (typeFlags & 2) != 0;
        boolean bl = isSparse = (typeFlags & 1) != 0;
        if (isSparse && !this.mResTable.isMainPackageLoaded()) {
            this.mResTable.getApkInfo().setSparseResources(true);
        }
        LinkedHashMap<Integer, Integer> entryOffsetMap = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < entryCount; ++i) {
            if (isSparse) {
                entryOffsetMap.put(this.mIn.readUnsignedShort(), this.mIn.readUnsignedShort() * 4);
                continue;
            }
            if (isOffset16) {
                int offset = this.mIn.readUnsignedShort();
                entryOffsetMap.put(i, offset == 65535 ? -1 : offset * 4);
                continue;
            }
            entryOffsetMap.put(i, this.mIn.readInt());
        }
        if (this.mInvalidResConfigFlags.contains(flags)) {
            String resName = this.mTypeSpec.getName() + flags.getQualifiers();
            if (this.mKeepBroken) {
                LOGGER.warning("Invalid config flags detected: " + resName);
            } else {
                LOGGER.warning("Invalid config flags detected. Dropping resources: " + resName);
            }
        }
        this.mType = !this.mInvalidResConfigFlags.contains(flags) || this.mKeepBroken ? this.mPackage.getOrCreateConfig(flags) : null;
        this.mIn.jumpTo(entriesStartAligned);
        Iterator resName = ((HashMap)entryOffsetMap).keySet().iterator();
        while (resName.hasNext()) {
            int i = (Integer)resName.next();
            this.mResId = this.mResId & 0xFFFF0000 | i;
            int offset = (Integer)((HashMap)entryOffsetMap).get(i);
            if (offset == -1) {
                this.mMissingResSpecs.put(this.mResId, typeId);
                continue;
            }
            long entryStart = entriesStartAligned + (long)offset;
            if (entryStart < this.mIn.position()) {
                this.mIn.reset();
            }
            this.mIn.jumpTo(entryStart);
            if (this.mIn.position() >= this.mHeader.endPosition) {
                int remainingEntries = entryCount - i;
                LOGGER.warning(String.format("End of chunk hit. Skipping remaining entries (%d) in type: %s", remainingEntries, this.mTypeSpec.getName()));
                break;
            }
            EntryData entryData = this.readEntryData();
            if (entryData != null) {
                this.parseEntryData(entryData);
                continue;
            }
            this.mMissingResSpecs.put(this.mResId, typeId);
        }
        if (this.mHeader.endPosition > this.mIn.position()) {
            long bytesSkipped = this.mIn.skip(this.mHeader.endPosition - this.mIn.position());
            LOGGER.warning("Unknown data detected at end of type chunk. Skipping: " + bytesSkipped + " byte(s)");
        }
        return this.mType;
    }

    private EntryData readEntryData() throws AndrolibException, IOException {
        ResValue value;
        int size = this.mIn.readUnsignedShort();
        int flags = this.mIn.readUnsignedShort();
        boolean isComplex = (flags & 1) != 0;
        boolean isCompact = (flags & 8) != 0;
        int specNamesId = this.mIn.readInt();
        if (specNamesId == -1 && !isCompact) {
            return null;
        }
        if (isCompact && !this.mResTable.isMainPackageLoaded()) {
            this.mResTable.getApkInfo().setCompactEntries(true);
        }
        if (isCompact) {
            int type = flags >> 8 & 0xFF;
            value = this.readCompactValue(type, specNamesId);
            specNamesId = size;
        } else {
            value = isComplex ? this.readComplexEntry() : this.readValue();
        }
        if (value == null) {
            return null;
        }
        EntryData entryData = new EntryData();
        entryData.flags = flags;
        entryData.specNamesId = specNamesId;
        entryData.value = value;
        return entryData;
    }

    private void parseEntryData(EntryData entryData) throws AndrolibException {
        ResResSpec spec;
        int specNamesId = entryData.specNamesId;
        ResValue value = entryData.value;
        if (this.mTypeSpec.isString() && value instanceof ResFileValue) {
            value = new ResStringValue(value.toString(), ((ResFileValue)value).getRawIntValue());
        }
        if (this.mType == null) {
            return;
        }
        ResID resId = new ResID(this.mResId);
        if (this.mPackage.hasResSpec(resId)) {
            spec = this.mPackage.getResSpec(resId);
        } else {
            spec = new ResResSpec(resId, this.mSpecNames.getString(specNamesId), this.mPackage, this.mTypeSpec);
            this.mPackage.addResSpec(spec);
            this.mTypeSpec.addResSpec(spec);
        }
        ResResource res = new ResResource(this.mType, spec, value);
        try {
            this.mType.addResource(res);
            spec.addResource(res);
        }
        catch (AndrolibException ex) {
            if (this.mKeepBroken) {
                this.mType.addResource(res, true);
                spec.addResource(res, true);
                LOGGER.warning(String.format("Duplicate Resource Detected. Ignoring duplicate: %s", res));
            }
            throw ex;
        }
    }

    private ResBagValue readComplexEntry() throws AndrolibException, IOException {
        int parentId = this.mIn.readInt();
        int count = this.mIn.readInt();
        ResValueFactory factory = this.mPackage.getValueFactory();
        Pair[] items = new Pair[count];
        for (int i = 0; i < count; ++i) {
            int resId = this.mIn.readInt();
            ResIntBasedValue resValue = this.readValue();
            if (resValue == null) continue;
            if (!(resValue instanceof ResScalarValue)) {
                resValue = new ResStringValue(resValue.toString(), resValue.getRawIntValue());
            }
            items[i] = Pair.of((Object)resId, (Object)((ResScalarValue)resValue));
        }
        return factory.bagFactory(parentId, items, this.mTypeSpec);
    }

    private ResIntBasedValue readCompactValue(int type, int data) throws AndrolibException {
        return type == 3 ? this.mPackage.getValueFactory().factory(this.mTableStrings.getHTML(data), data) : this.mPackage.getValueFactory().factory(type, data, null);
    }

    private ResIntBasedValue readValue() throws AndrolibException, IOException {
        int size = this.mIn.readUnsignedShort();
        if (size < 8) {
            return null;
        }
        this.mIn.skipByte();
        int type = this.mIn.readUnsignedByte();
        int data = this.mIn.readInt();
        return type == 3 ? this.mPackage.getValueFactory().factory(this.mTableStrings.getHTML(data), data) : this.mPackage.getValueFactory().factory(type, data, null);
    }

    private ResConfigFlags readConfigFlags() throws AndrolibException, IOException {
        int remainingSize;
        int exceedingKnownSize;
        int size = this.mIn.readInt();
        int read = 8;
        if (size < 8) {
            throw new AndrolibException("Config size < 8");
        }
        boolean isInvalid = false;
        int mcc = this.mIn.readUnsignedShort();
        int mnc = this.mIn.readUnsignedShort();
        String language = "";
        String region = "";
        if (size >= 12) {
            language = this.unpackLanguageOrRegion(this.mIn.readBytes(2), 'a');
            region = this.unpackLanguageOrRegion(this.mIn.readBytes(2), '0');
            read = 12;
        }
        int orientation = 0;
        int touchscreen = 0;
        if (size >= 14) {
            orientation = this.mIn.readUnsignedByte();
            touchscreen = this.mIn.readUnsignedByte();
            read = 14;
        }
        int density = 0;
        if (size >= 16) {
            density = this.mIn.readUnsignedShort();
            read = 16;
        }
        int keyboard = 0;
        int navigation = 0;
        int inputFlags = 0;
        int grammaticalInflection = 0;
        if (size >= 20) {
            keyboard = this.mIn.readUnsignedByte();
            navigation = this.mIn.readUnsignedByte();
            inputFlags = this.mIn.readUnsignedByte();
            grammaticalInflection = this.mIn.readUnsignedByte();
            read = 20;
        }
        int screenWidth = 0;
        int screenHeight = 0;
        int sdkVersion = 0;
        int minorVersion = 0;
        if (size >= 28) {
            screenWidth = this.mIn.readUnsignedShort();
            screenHeight = this.mIn.readUnsignedShort();
            sdkVersion = this.mIn.readUnsignedShort();
            minorVersion = this.mIn.readUnsignedShort();
            read = 28;
        }
        int screenLayout = 0;
        int uiMode = 0;
        int smallestScreenWidthDp = 0;
        if (size >= 32) {
            screenLayout = this.mIn.readUnsignedByte();
            uiMode = this.mIn.readUnsignedByte();
            smallestScreenWidthDp = this.mIn.readUnsignedShort();
            read = 32;
        }
        int screenWidthDp = 0;
        int screenHeightDp = 0;
        if (size >= 36) {
            screenWidthDp = this.mIn.readUnsignedShort();
            screenHeightDp = this.mIn.readUnsignedShort();
            read = 36;
        }
        String localeScript = "";
        String localeVariant = "";
        if (size >= 48) {
            localeScript = this.mIn.readAscii(4);
            localeVariant = this.mIn.readAscii(8);
            read = 48;
        }
        int screenLayout2 = 0;
        int colorMode = 0;
        if (size >= 52) {
            screenLayout2 = this.mIn.readUnsignedByte();
            colorMode = this.mIn.readUnsignedByte();
            this.mIn.skipShort();
            read = 52;
        }
        String localeNumberingSystem = "";
        if (size >= 60) {
            localeNumberingSystem = this.mIn.readAscii(8);
            read = 60;
        }
        if ((exceedingKnownSize = size - 64) > 0) {
            byte[] buf = this.mIn.readBytes(exceedingKnownSize);
            read += exceedingKnownSize;
            BigInteger exceedingBI = new BigInteger(1, buf);
            if (exceedingBI.equals(BigInteger.ZERO)) {
                LOGGER.fine(String.format("Config flags size > %d, but exceeding bytes are all zero, so it should be ok.", 64));
            } else {
                LOGGER.warning(String.format("Config flags size > %d. Size = %d. Exceeding bytes: 0x%X.", 64, size, exceedingBI));
                isInvalid = true;
            }
        }
        if ((remainingSize = size - read) > 0) {
            this.mIn.skipBytes(remainingSize);
        }
        ResConfigFlags flags = new ResConfigFlags(mcc, mnc, language, region, orientation, touchscreen, density, keyboard, navigation, inputFlags, grammaticalInflection, screenWidth, screenHeight, sdkVersion, minorVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, localeScript, localeVariant, screenLayout2, colorMode, localeNumberingSystem);
        if (isInvalid || flags.isInvalid()) {
            this.mInvalidResConfigFlags.add(flags);
        }
        return flags;
    }

    private String unpackLanguageOrRegion(byte[] value, char base) {
        assert (value.length == 2);
        if (value[0] == 0) {
            return "";
        }
        if ((value[0] & 0x80) != 0) {
            byte first = (byte)(base + (value[1] & 0x1F));
            byte second = (byte)(base + ((value[1] & 0xE0) >>> 5) + ((value[0] & 3) << 3));
            byte third = (byte)(base + ((value[0] & 0x7C) >>> 2));
            value = new byte[]{first, second, third};
        }
        return new String(value, StandardCharsets.US_ASCII);
    }

    private void addMissingResSpecs() throws AndrolibException {
        for (int resId : this.mMissingResSpecs.keySet()) {
            int typeId = this.mMissingResSpecs.get(resId);
            String resName = "APKTOOL_DUMMY_" + Integer.toHexString(resId);
            ResID id = new ResID(resId);
            ResResSpec spec = new ResResSpec(id, resName, this.mPackage, this.mResTypeSpecs.get(typeId));
            if (this.mPackage.hasResSpec(id)) continue;
            this.mPackage.addResSpec(spec);
            spec.getType().addResSpec(spec);
            ResType resType = this.mPackage.getOrCreateConfig(new ResConfigFlags());
            ResReferenceValue value = new ResReferenceValue(this.mPackage, 0, "");
            ResResource res = new ResResource(resType, spec, value);
            resType.addResource(res);
            spec.addResource(res);
        }
    }

    private void checkChunkType(int expectedType) throws AndrolibException {
        if (this.mHeader.type != expectedType) {
            throw new AndrolibException(String.format("Invalid chunk type: expected=0x%08x, got=0x%08x", expectedType, this.mHeader.type));
        }
    }
}

