/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.res.xml.ResXmlEncoders;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class StyledString {
    private static final Logger LOGGER = Logger.getLogger(StyledString.class.getName());
    private final String mText;
    private final List<Span> mSpans;

    public StyledString(String text, List<Span> spans) {
        this.mText = text;
        this.mSpans = spans;
    }

    String getText() {
        return this.mText;
    }

    List<Span> getSpans() {
        return this.mSpans;
    }

    public String toString() {
        return new Decoder().decode(this);
    }

    private static class Decoder {
        private String mText;
        private StringBuilder mXmlValue;
        private int mLastOffset;

        private Decoder() {
        }

        public String decode(StyledString styledString) {
            this.mText = styledString.getText();
            this.mXmlValue = new StringBuilder(this.mText.length() * 2);
            this.mLastOffset = 0;
            PeekingIterator it = Iterators.peekingIterator(styledString.getSpans().iterator());
            while (it.hasNext()) {
                this.decodeIterate((PeekingIterator<Span>)it);
            }
            if (this.mLastOffset < this.mText.length()) {
                this.mXmlValue.append(ResXmlEncoders.escapeXmlChars(this.mText.substring(this.mLastOffset)));
            }
            return this.mXmlValue.toString();
        }

        private void decodeIterate(PeekingIterator<Span> it) {
            Span span = (Span)it.next();
            String name = span.getName();
            Map<String, String> attributes = span.getAttributes();
            int spanStart = span.getFirstChar();
            int spanEnd = span.getLastChar() + 1;
            if (spanStart > this.mLastOffset) {
                this.mXmlValue.append(ResXmlEncoders.escapeXmlChars(this.mText.substring(this.mLastOffset, spanStart)));
            }
            this.mLastOffset = spanStart;
            this.mXmlValue.append('<').append(name);
            if (attributes != null) {
                for (Map.Entry<String, String> attrEntry : attributes.entrySet()) {
                    this.mXmlValue.append(' ').append(attrEntry.getKey()).append("=\"").append(ResXmlEncoders.escapeXmlChars(attrEntry.getValue())).append('\"');
                }
            }
            if (spanStart == spanEnd) {
                this.mXmlValue.append("/>");
                return;
            }
            this.mXmlValue.append('>');
            while (it.hasNext() && ((Span)it.peek()).getFirstChar() < spanEnd) {
                this.decodeIterate(it);
            }
            if (spanEnd > this.mLastOffset && this.mText.length() >= spanEnd) {
                this.mXmlValue.append(ResXmlEncoders.escapeXmlChars(this.mText.substring(this.mLastOffset, spanEnd)));
            } else if (this.mText.length() >= this.mLastOffset && this.mText.length() < spanEnd) {
                LOGGER.warning("Span (" + name + ") exceeds mText length " + this.mText.length());
                this.mXmlValue.append(ResXmlEncoders.escapeXmlChars(this.mText.substring(this.mLastOffset)));
            }
            this.mLastOffset = spanEnd;
            this.mXmlValue.append("</").append(name).append('>');
        }
    }

    public static class Span
    implements Comparable<Span> {
        private static final Splitter.MapSplitter ATTRIBUTES_SPLITTER = Splitter.on((char)';').omitEmptyStrings().withKeyValueSeparator(Splitter.on((char)'=').limit(2));
        private final String mTag;
        private final int mFirstChar;
        private final int mLastChar;

        public Span(String tag, int firstChar, int lastChar) {
            this.mTag = tag;
            this.mFirstChar = firstChar;
            this.mLastChar = lastChar;
        }

        public String getTag() {
            return this.mTag;
        }

        public int getFirstChar() {
            return this.mFirstChar;
        }

        public int getLastChar() {
            return this.mLastChar;
        }

        public String getName() {
            int separatorIdx = this.mTag.indexOf(59);
            return separatorIdx == -1 ? this.mTag : this.mTag.substring(0, separatorIdx);
        }

        public Map<String, String> getAttributes() {
            int separatorIdx = this.mTag.indexOf(59);
            return separatorIdx != -1 ? ATTRIBUTES_SPLITTER.split((CharSequence)this.mTag.substring(separatorIdx + 1, this.mTag.endsWith(";") ? this.mTag.length() - 1 : this.mTag.length())) : null;
        }

        @Override
        public int compareTo(Span other) {
            int res = Integer.compare(this.mFirstChar, other.mFirstChar);
            if (res != 0) {
                return res;
            }
            res = Integer.compare(this.mLastChar, other.mLastChar);
            if (res != 0) {
                return -res;
            }
            return -this.mTag.compareTo(other.mTag);
        }
    }
}

