/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObjectException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResTable;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ResTypeSpec {
    public static final String RES_TYPE_NAME_ARRAY = "array";
    public static final String RES_TYPE_NAME_PLURALS = "plurals";
    public static final String RES_TYPE_NAME_STYLES = "style";
    public static final String RES_TYPE_NAME_ATTR = "attr";
    private final String mName;
    private final Map<String, ResResSpec> mResSpecs = new LinkedHashMap<String, ResResSpec>();
    private final ResTable mResTable;
    private final ResPackage mPackage;
    private final int mId;
    private final int mEntryCount;

    public ResTypeSpec(String name, ResTable resTable, ResPackage package_, int id, int entryCount) {
        this.mName = name;
        this.mResTable = resTable;
        this.mPackage = package_;
        this.mId = id;
        this.mEntryCount = entryCount;
    }

    public String getName() {
        return this.mName;
    }

    public int getId() {
        return this.mId;
    }

    public boolean isString() {
        return this.mName.equalsIgnoreCase("string");
    }

    public ResResSpec getResSpec(String name) throws AndrolibException {
        ResResSpec spec = this.getResSpecUnsafe(name);
        if (spec == null) {
            throw new UndefinedResObjectException(String.format("resource spec: %s/%s", this.getName(), name));
        }
        return spec;
    }

    public ResResSpec getResSpecUnsafe(String name) {
        return this.mResSpecs.get(name);
    }

    public void removeResSpec(ResResSpec spec) {
        this.mResSpecs.remove(spec.getName());
    }

    public void addResSpec(ResResSpec spec) throws AndrolibException {
        if (this.mResSpecs.put(spec.getName(), spec) != null) {
            throw new AndrolibException(String.format("Multiple res specs: %s/%s", this.getName(), spec.getName()));
        }
    }

    public String toString() {
        return this.mName;
    }
}

