/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AaptInvoker;
import brut.androlib.ApktoolProperties;
import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.Framework;
import brut.androlib.res.xml.ResXmlPatcher;
import brut.androlib.src.SmaliBuilder;
import brut.common.BrutException;
import brut.common.InvalidUnknownFileException;
import brut.common.RootUnknownFileException;
import brut.common.TraversalUnknownFileException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.directory.ZipUtils;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.xml.sax.SAXException;

public class ApkBuilder {
    private static final Logger LOGGER = Logger.getLogger(ApkBuilder.class.getName());
    private final Config mConfig;
    private ApkInfo mApkInfo;
    private int mMinSdkVersion = 0;
    private final ExtFile mApkDir;
    private static final String APK_DIRNAME = "build/apk";
    private static final String UNK_DIRNAME = "unknown";
    private static final String[] APK_RESOURCES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml", "res", "r", "R"};
    private static final String[] APK_RESOURCES_WITHOUT_RES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml"};
    private static final String[] APP_RESOURCES_FILENAMES = new String[]{"AndroidManifest.xml", "res"};
    private static final String[] APK_MANIFEST_FILENAMES = new String[]{"AndroidManifest.xml"};

    public ApkBuilder(ExtFile apkDir) {
        this(Config.getDefaultConfig(), apkDir);
    }

    public ApkBuilder(Config config, ExtFile apkDir) {
        this.mConfig = config;
        this.mApkDir = apkDir;
    }

    public void build(File outFile) throws BrutException {
        LOGGER.info("Using Apktool " + ApktoolProperties.getVersion());
        this.mApkInfo = ApkInfo.load((File)this.mApkDir);
        if (this.mApkInfo.getSdkInfo() != null && this.mApkInfo.getSdkInfo().get("minSdkVersion") != null) {
            String minSdkVersion = this.mApkInfo.getSdkInfo().get("minSdkVersion");
            this.mMinSdkVersion = this.mApkInfo.getMinSdkVersionFromAndroidCodename(minSdkVersion);
        }
        if (outFile == null) {
            String outFileName = this.mApkInfo.getApkFileName();
            outFile = new File((File)this.mApkDir, "dist" + File.separator + (outFileName == null ? "out.apk" : outFileName));
        }
        new File((File)this.mApkDir, APK_DIRNAME).mkdirs();
        File manifest = new File((File)this.mApkDir, "AndroidManifest.xml");
        File manifestOriginal = new File((File)this.mApkDir, "AndroidManifest.xml.orig");
        this.buildSources((File)this.mApkDir);
        this.buildNonDefaultSources(this.mApkDir);
        this.buildManifestFile((File)this.mApkDir, manifest, manifestOriginal);
        this.buildResources(this.mApkDir, this.mApkInfo.usesFramework);
        this.buildLibs((File)this.mApkDir);
        this.buildCopyOriginalFiles((File)this.mApkDir);
        this.buildApk((File)this.mApkDir, outFile);
        this.buildUnknownFiles((File)this.mApkDir, outFile, this.mApkInfo);
        if (manifest.isFile() && manifest.exists() && manifestOriginal.isFile()) {
            try {
                if (new File((File)this.mApkDir, "AndroidManifest.xml").delete()) {
                    FileUtils.moveFile((File)manifestOriginal, (File)manifest);
                }
            }
            catch (IOException ex) {
                throw new AndrolibException(ex.getMessage());
            }
        }
        LOGGER.info("Built apk into: " + outFile.getPath());
    }

    private void buildManifestFile(File appDir, File manifest, File manifestOriginal) throws AndrolibException {
        if (new File(appDir, "resources.arsc").exists()) {
            return;
        }
        if (manifest.isFile() && manifest.exists()) {
            try {
                if (manifestOriginal.exists()) {
                    manifestOriginal.delete();
                }
                FileUtils.copyFile((File)manifest, (File)manifestOriginal);
                ResXmlPatcher.fixingPublicAttrsInProviderAttributes(manifest);
            }
            catch (IOException ex) {
                throw new AndrolibException(ex.getMessage());
            }
        }
    }

    private void buildSources(File appDir) throws AndrolibException {
        if (!this.buildSourcesRaw(appDir, "classes.dex") && !this.buildSourcesSmali(appDir, "smali", "classes.dex")) {
            LOGGER.warning("Could not find sources");
        }
    }

    private void buildNonDefaultSources(ExtFile appDir) throws AndrolibException {
        try {
            Map dirs = appDir.getDirectory().getDirs();
            for (Map.Entry directory : dirs.entrySet()) {
                String filename;
                String name = (String)directory.getKey();
                if (!name.startsWith("smali_") || this.buildSourcesRaw((File)appDir, filename = name.substring(name.indexOf("_") + 1) + ".dex") || this.buildSourcesSmali((File)appDir, name, filename)) continue;
                LOGGER.warning("Could not find sources");
            }
            File[] dexFiles = appDir.listFiles();
            if (dexFiles != null) {
                for (File dex : dexFiles) {
                    if (!dex.getName().endsWith(".dex") || dex.getName().equalsIgnoreCase("classes.dex")) continue;
                    this.buildSourcesRaw((File)appDir, dex.getName());
                }
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean buildSourcesRaw(File appDir, String filename) throws AndrolibException {
        File working = new File(appDir, filename);
        if (!working.exists()) {
            return false;
        }
        File stored = new File(appDir, "build/apk/" + filename);
        if (this.mConfig.forceBuildAll || this.isModified(working, stored)) {
            LOGGER.info("Copying " + appDir.toString() + " " + filename + " file...");
            try {
                BrutIO.copyAndClose((InputStream)Files.newInputStream(working.toPath(), new OpenOption[0]), (OutputStream)Files.newOutputStream(stored.toPath(), new OpenOption[0]));
                return true;
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
        return true;
    }

    private boolean buildSourcesSmali(File appDir, String folder, String filename) throws AndrolibException {
        ExtFile smaliDir = new ExtFile(appDir, folder);
        if (!smaliDir.exists()) {
            return false;
        }
        File dex = new File(appDir, "build/apk/" + filename);
        if (!this.mConfig.forceBuildAll) {
            LOGGER.info("Checking whether sources has changed...");
        }
        if (this.mConfig.forceBuildAll || this.isModified((File)smaliDir, dex)) {
            LOGGER.info("Smaling " + folder + " folder into " + filename + "...");
            dex.delete();
            SmaliBuilder.build(smaliDir, dex, this.mConfig.forceApi > 0 ? this.mConfig.forceApi : this.mMinSdkVersion);
        }
        return true;
    }

    private void buildResources(ExtFile appDir, UsesFramework usesFramework) throws BrutException {
        if (!(this.buildResourcesRaw(appDir) || this.buildResourcesFull((File)appDir, usesFramework) || this.buildManifest(appDir, usesFramework))) {
            LOGGER.warning("Could not find resources");
        }
    }

    private boolean buildResourcesRaw(ExtFile appDir) throws AndrolibException {
        try {
            if (!new File((File)appDir, "resources.arsc").exists()) {
                return false;
            }
            File apkDir = new File((File)appDir, APK_DIRNAME);
            if (!this.mConfig.forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            if (this.mConfig.forceBuildAll || this.isModified(this.newFiles(APK_RESOURCES_FILENAMES, (File)appDir), this.newFiles(APK_RESOURCES_FILENAMES, apkDir))) {
                LOGGER.info("Copying raw resources...");
                appDir.getDirectory().copyToDir(apkDir, APK_RESOURCES_FILENAMES);
            }
            return true;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildResourcesFull(File appDir, UsesFramework usesFramework) throws AndrolibException {
        try {
            if (!new File(appDir, "res").exists()) {
                return false;
            }
            if (!this.mConfig.forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File apkDir = new File(appDir, APK_DIRNAME);
            File resourceFile = new File(apkDir.getParent(), "resources.zip");
            if (this.mConfig.forceBuildAll || this.isModified(this.newFiles(APP_RESOURCES_FILENAMES, appDir), this.newFiles(APK_RESOURCES_FILENAMES, apkDir)) || this.mConfig.isAapt2() && !this.isFile(resourceFile)) {
                LOGGER.info("Building resources...");
                if (this.mConfig.debugMode) {
                    if (this.mConfig.isAapt2()) {
                        LOGGER.info("Using aapt2 - setting 'debuggable' attribute to 'true' in AndroidManifest.xml");
                        ResXmlPatcher.setApplicationDebugTagTrue(new File(appDir, "AndroidManifest.xml"));
                    } else {
                        ResXmlPatcher.removeApplicationDebugTag(new File(appDir, "AndroidManifest.xml"));
                    }
                }
                if (this.mConfig.netSecConf) {
                    File netSecConfOrig;
                    ApkInfo meta = ApkInfo.load((File)new ExtFile(appDir));
                    if (meta.getSdkInfo() != null && meta.getSdkInfo().get("targetSdkVersion") != null && Integer.parseInt(meta.getSdkInfo().get("targetSdkVersion")) < 24) {
                        LOGGER.warning("Target SDK version is lower than 24! Network Security Configuration might be ignored!");
                    }
                    if ((netSecConfOrig = new File(appDir, "res/xml/network_security_config.xml")).exists()) {
                        LOGGER.info("Replacing existing network_security_config.xml!");
                        netSecConfOrig.delete();
                    }
                    ResXmlPatcher.modNetworkSecurityConfig(netSecConfOrig);
                    ResXmlPatcher.setNetworkSecurityConfig(new File(appDir, "AndroidManifest.xml"));
                    LOGGER.info("Added permissive network security config in manifest");
                }
                File apkFile = File.createTempFile("APKTOOL", null);
                apkFile.delete();
                resourceFile.delete();
                File ninePatch = new File(appDir, "9patch");
                if (!ninePatch.exists()) {
                    ninePatch = null;
                }
                AaptInvoker invoker = new AaptInvoker(this.mConfig, this.mApkInfo);
                invoker.invokeAapt(apkFile, new File(appDir, "AndroidManifest.xml"), new File(appDir, "res"), ninePatch, null, this.parseUsesFramework(usesFramework));
                ExtFile tmpExtFile = new ExtFile(apkFile);
                Directory tmpDir = tmpExtFile.getDirectory();
                try {
                    tmpDir.copyToDir(apkDir, tmpDir.containsDir("res") ? APK_RESOURCES_FILENAMES : APK_RESOURCES_WITHOUT_RES_FILENAMES);
                }
                catch (DirectoryException ex) {
                    LOGGER.warning(ex.getMessage());
                }
                finally {
                    tmpExtFile.close();
                }
                apkFile.delete();
            }
            return true;
        }
        catch (BrutException | IOException | ParserConfigurationException | TransformerException | SAXException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean buildManifestRaw(ExtFile appDir) throws AndrolibException {
        try {
            File apkDir = new File((File)appDir, APK_DIRNAME);
            LOGGER.info("Copying raw AndroidManifest.xml...");
            appDir.getDirectory().copyToDir(apkDir, APK_MANIFEST_FILENAMES);
            return true;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean buildManifest(ExtFile appDir, UsesFramework usesFramework) throws BrutException {
        try {
            if (!new File((File)appDir, "AndroidManifest.xml").exists()) {
                return false;
            }
            if (!this.mConfig.forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File apkDir = new File((File)appDir, APK_DIRNAME);
            if (this.mConfig.forceBuildAll || this.isModified(this.newFiles(APK_MANIFEST_FILENAMES, (File)appDir), this.newFiles(APK_MANIFEST_FILENAMES, apkDir))) {
                LOGGER.info("Building AndroidManifest.xml...");
                File apkFile = File.createTempFile("APKTOOL", null);
                apkFile.delete();
                File ninePatch = new File((File)appDir, "9patch");
                if (!ninePatch.exists()) {
                    ninePatch = null;
                }
                AaptInvoker invoker = new AaptInvoker(this.mConfig, this.mApkInfo);
                invoker.invokeAapt(apkFile, new File((File)appDir, "AndroidManifest.xml"), null, ninePatch, null, this.parseUsesFramework(usesFramework));
                Directory tmpDir = new ExtFile(apkFile).getDirectory();
                tmpDir.copyToDir(apkDir, APK_MANIFEST_FILENAMES);
                apkFile.delete();
            }
            return true;
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
        catch (AndrolibException ex) {
            LOGGER.warning("Parse AndroidManifest.xml failed, treat it as raw file.");
            return this.buildManifestRaw(appDir);
        }
    }

    private void buildLibs(File appDir) throws AndrolibException {
        this.buildLibrary(appDir, "lib");
        this.buildLibrary(appDir, "libs");
        this.buildLibrary(appDir, "kotlin");
        this.buildLibrary(appDir, "META-INF/services");
    }

    private void buildLibrary(File appDir, String folder) throws AndrolibException {
        File working = new File(appDir, folder);
        if (!working.exists()) {
            return;
        }
        File stored = new File(appDir, "build/apk/" + folder);
        if (this.mConfig.forceBuildAll || this.isModified(working, stored)) {
            LOGGER.info("Copying libs... (/" + folder + ")");
            try {
                OS.rmdir((File)stored);
                OS.cpdir((File)working, (File)stored);
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    private void buildCopyOriginalFiles(File appDir) throws AndrolibException {
        File originalDir;
        if (this.mConfig.copyOriginalFiles && (originalDir = new File(appDir, "original")).exists()) {
            try {
                LOGGER.info("Copy original files...");
                Directory in = new ExtFile(originalDir).getDirectory();
                if (in.containsFile("AndroidManifest.xml")) {
                    LOGGER.info("Copy AndroidManifest.xml...");
                    in.copyToDir(new File(appDir, APK_DIRNAME), "AndroidManifest.xml");
                }
                if (in.containsFile("stamp-cert-sha256")) {
                    LOGGER.info("Copy stamp-cert-sha256...");
                    in.copyToDir(new File(appDir, APK_DIRNAME), "stamp-cert-sha256");
                }
                if (in.containsDir("META-INF")) {
                    LOGGER.info("Copy META-INF...");
                    in.copyToDir(new File(appDir, APK_DIRNAME), "META-INF");
                }
            }
            catch (DirectoryException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    private void buildUnknownFiles(File appDir, File outFile, ApkInfo meta) throws AndrolibException {
        if (meta.unknownFiles != null) {
            LOGGER.info("Copying unknown files/dir...");
            Map<String, String> files = meta.unknownFiles;
            File tempFile = new File(outFile.getParent(), outFile.getName() + ".apktool_temp");
            boolean renamed = outFile.renameTo(tempFile);
            if (!renamed) {
                throw new AndrolibException("Unable to rename temporary file");
            }
            try (ZipFile inputFile = new ZipFile(tempFile);
                 ZipOutputStream actualOutput = new ZipOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));){
                this.copyExistingFiles(inputFile, actualOutput);
                this.copyUnknownFiles(appDir, actualOutput, files);
            }
            catch (BrutException | IOException ex) {
                throw new AndrolibException(ex);
            }
            tempFile.delete();
        }
    }

    private void copyExistingFiles(ZipFile inputFile, ZipOutputStream outputFile) throws IOException {
        Enumeration<? extends ZipEntry> entries = inputFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = new ZipEntry(entries.nextElement());
            entry.setCompressedSize(-1L);
            outputFile.putNextEntry(entry);
            if (!entry.isDirectory()) {
                BrutIO.copy((ZipFile)inputFile, (ZipOutputStream)outputFile, (ZipEntry)entry);
            }
            outputFile.closeEntry();
        }
    }

    private void copyUnknownFiles(File appDir, ZipOutputStream outputFile, Map<String, String> files) throws BrutException, IOException {
        File unknownFileDir = new File(appDir, UNK_DIRNAME);
        for (Map.Entry<String, String> unknownFileInfo : files.entrySet()) {
            File inputFile;
            try {
                inputFile = new File(unknownFileDir, BrutIO.sanitizeUnknownFile((File)unknownFileDir, (String)unknownFileInfo.getKey()));
            }
            catch (InvalidUnknownFileException | RootUnknownFileException | TraversalUnknownFileException exception) {
                LOGGER.warning(String.format("Skipping file %s (%s)", unknownFileInfo.getKey(), exception.getMessage()));
                continue;
            }
            if (inputFile.isDirectory()) continue;
            ZipEntry newEntry = new ZipEntry(unknownFileInfo.getKey());
            int method = Integer.parseInt(unknownFileInfo.getValue());
            LOGGER.fine(String.format("Copying unknown file %s with method %d", unknownFileInfo.getKey(), method));
            if (method == 0) {
                newEntry.setMethod(0);
                newEntry.setSize(inputFile.length());
                newEntry.setCompressedSize(-1L);
                BufferedInputStream unknownFile = new BufferedInputStream(Files.newInputStream(inputFile.toPath(), new OpenOption[0]));
                CRC32 crc = BrutIO.calculateCrc((InputStream)unknownFile);
                newEntry.setCrc(crc.getValue());
                unknownFile.close();
            } else {
                newEntry.setMethod(8);
            }
            outputFile.putNextEntry(newEntry);
            BrutIO.copy((File)inputFile, (ZipOutputStream)outputFile);
            outputFile.closeEntry();
        }
    }

    private void buildApk(File appDir, File outApk) throws AndrolibException {
        LOGGER.info("Building apk file...");
        if (outApk.exists()) {
            outApk.delete();
        } else {
            File outDir = outApk.getParentFile();
            if (outDir != null && !outDir.exists()) {
                outDir.mkdirs();
            }
        }
        File assetDir = new File(appDir, "assets");
        if (!assetDir.exists()) {
            assetDir = null;
        }
        this.zipPackage(outApk, new File(appDir, APK_DIRNAME), assetDir);
    }

    private void zipPackage(File apkFile, File rawDir, File assetDir) throws AndrolibException {
        try {
            ZipUtils.zipFolders((File)rawDir, (File)apkFile, (File)assetDir, this.mApkInfo.doNotCompress);
        }
        catch (BrutException | IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private File[] parseUsesFramework(UsesFramework usesFramework) throws AndrolibException {
        if (usesFramework == null) {
            return null;
        }
        List<Integer> ids = usesFramework.ids;
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        Framework framework = new Framework(this.mConfig);
        String tag = usesFramework.tag;
        File[] files = new File[ids.size()];
        int i = 0;
        for (int id : ids) {
            files[i++] = framework.getFrameworkApk(id, tag);
        }
        return files;
    }

    private boolean isModified(File working, File stored) {
        return !stored.exists() || BrutIO.recursiveModifiedTime((File)working) > BrutIO.recursiveModifiedTime((File)stored);
    }

    private boolean isFile(File working) {
        return working.exists();
    }

    private boolean isModified(File[] working, File[] stored) {
        for (File file : stored) {
            if (file.exists()) continue;
            return true;
        }
        return BrutIO.recursiveModifiedTime((File[])working) > BrutIO.recursiveModifiedTime((File[])stored);
    }

    private File[] newFiles(String[] names, File dir) {
        File[] files = new File[names.length];
        for (int i = 0; i < names.length; ++i) {
            files[i] = new File(dir, names[i]);
        }
        return files;
    }

    public boolean detectWhetherAppIsFramework(File appDir) throws AndrolibException {
        LineIterator it;
        File publicXml = new File(appDir, "res/values/public.xml");
        if (!publicXml.exists()) {
            return false;
        }
        try {
            it = IOUtils.lineIterator((Reader)new FileReader(new File(appDir, "res/values/public.xml")));
        }
        catch (FileNotFoundException ex) {
            throw new AndrolibException("Could not detect whether app is framework one", ex);
        }
        it.next();
        it.next();
        return ((String)it.next()).contains("0x01");
    }
}

