/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.apk;

import brut.androlib.apk.ApkInfo;
import brut.androlib.apk.PackageInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.apk.VersionInfo;
import brut.androlib.apk.YamlStringEscapeUtils;
import java.util.ArrayList;
import java.util.List;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class ClassSafeConstructor
extends Constructor {
    protected final List<Class<?>> allowableClasses = new ArrayList();

    public ClassSafeConstructor() {
        super(new LoaderOptions());
        this.yamlConstructors.put(Tag.STR, new ConstructStringEx());
        this.allowableClasses.add(ApkInfo.class);
        this.allowableClasses.add(PackageInfo.class);
        this.allowableClasses.add(UsesFramework.class);
        this.allowableClasses.add(VersionInfo.class);
    }

    protected Object newInstance(Node node) {
        if (this.yamlConstructors.containsKey(node.getTag()) || this.allowableClasses.contains(node.getType())) {
            return super.newInstance(node);
        }
        throw new YAMLException("Invalid Class attempting to be constructed: " + node.getTag());
    }

    protected Object finalizeConstruction(Node node, Object data) {
        if (this.yamlConstructors.containsKey(node.getTag()) || this.allowableClasses.contains(node.getType())) {
            return super.finalizeConstruction(node, data);
        }
        return this.newInstance(node);
    }

    private class ConstructStringEx
    extends AbstractConstruct {
        private ConstructStringEx() {
        }

        public Object construct(Node node) {
            String val = ClassSafeConstructor.this.constructScalar((ScalarNode)node);
            return YamlStringEscapeUtils.unescapeString(val);
        }
    }
}

