/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.arsc;

import brut.util.ExtDataInput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.commons.io.input.CountingInputStream;

public class ARSCHeader {
    public final short type;
    public final int headerSize;
    public final int chunkSize;
    public final int startPosition;
    public final int endPosition;
    public static final short RES_NONE_TYPE = -1;
    public static final short RES_NULL_TYPE = 0;
    public static final short RES_STRING_POOL_TYPE = 1;
    public static final short RES_TABLE_TYPE = 2;
    public static final short RES_XML_TYPE = 3;
    public static final short XML_TYPE_PACKAGE = 512;
    public static final short XML_TYPE_TYPE = 513;
    public static final short XML_TYPE_SPEC_TYPE = 514;
    public static final short XML_TYPE_LIBRARY = 515;
    public static final short XML_TYPE_OVERLAY = 516;
    public static final short XML_TYPE_OVERLAY_POLICY = 517;
    public static final short XML_TYPE_STAGED_ALIAS = 518;
    public static final short RES_XML_FIRST_CHUNK_TYPE = 256;
    public static final short RES_XML_START_NAMESPACE_TYPE = 256;
    public static final short RES_XML_END_NAMESPACE_TYPE = 257;
    public static final short RES_XML_START_ELEMENT_TYPE = 258;
    public static final short RES_XML_END_ELEMENT_TYPE = 259;
    public static final short RES_XML_CDATA_TYPE = 260;
    public static final short RES_XML_LAST_CHUNK_TYPE = 383;
    public static final short RES_XML_RESOURCE_MAP_TYPE = 384;

    public ARSCHeader(short type, int headerSize, int chunkSize, int headerStart) {
        this.type = type;
        this.headerSize = headerSize;
        this.chunkSize = chunkSize;
        this.startPosition = headerStart;
        this.endPosition = headerStart + chunkSize;
    }

    public static ARSCHeader read(ExtDataInput in, CountingInputStream countIn) throws IOException {
        short type;
        int start = countIn.getCount();
        try {
            type = in.readShort();
        }
        catch (EOFException ex) {
            return new ARSCHeader(-1, 0, 0, countIn.getCount());
        }
        return new ARSCHeader(type, in.readShort(), in.readInt(), start);
    }

    public void skipChunk(ExtDataInput in) throws IOException {
        in.skipBytes(this.chunkSize - this.headerSize);
    }
}

