/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.ninepatch;

import brut.util.ExtDataInput;
import java.io.IOException;

public class NinePatchData {
    public final int padLeft;
    public final int padRight;
    public final int padTop;
    public final int padBottom;
    public final int[] xDivs;
    public final int[] yDivs;

    public NinePatchData(int padLeft, int padRight, int padTop, int padBottom, int[] xDivs, int[] yDivs) {
        this.padLeft = padLeft;
        this.padRight = padRight;
        this.padTop = padTop;
        this.padBottom = padBottom;
        this.xDivs = xDivs;
        this.yDivs = yDivs;
    }

    public static NinePatchData decode(ExtDataInput di) throws IOException {
        di.skipBytes(1);
        byte numXDivs = di.readByte();
        byte numYDivs = di.readByte();
        di.skipBytes(1);
        di.skipBytes(8);
        int padLeft = di.readInt();
        int padRight = di.readInt();
        int padTop = di.readInt();
        int padBottom = di.readInt();
        di.skipBytes(4);
        int[] xDivs = di.readIntArray((int)numXDivs);
        int[] yDivs = di.readIntArray((int)numYDivs);
        return new NinePatchData(padLeft, padRight, padTop, padBottom, xDivs, yDivs);
    }
}

