/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.res.decoder.StyledString;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtDataInput;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

public class StringBlock {
    private int[] m_stringOffsets;
    private byte[] m_strings;
    private int[] m_styleOffsets;
    private int[] m_styles;
    private boolean m_isUTF8;
    private final CharsetDecoder UTF16LE_DECODER = StandardCharsets.UTF_16LE.newDecoder();
    private final CharsetDecoder UTF8_DECODER = StandardCharsets.UTF_8.newDecoder();
    private final CharsetDecoder CESU8_DECODER = Charset.forName("CESU8").newDecoder();
    private static final Logger LOGGER = Logger.getLogger(StringBlock.class.getName());
    private static final int UTF8_FLAG = 256;

    public static StringBlock readWithChunk(ExtDataInput reader) throws IOException {
        reader.skipCheckShort((short)1);
        reader.skipShort();
        int chunkSize = reader.readInt();
        return StringBlock.readWithoutChunk(reader, chunkSize);
    }

    public static StringBlock readWithoutChunk(ExtDataInput reader, int chunkSize) throws IOException {
        int stringCount = reader.readInt();
        int styleCount = reader.readInt();
        int flags = reader.readInt();
        int stringsOffset = reader.readInt();
        int stylesOffset = reader.readInt();
        StringBlock block = new StringBlock();
        block.m_isUTF8 = (flags & 0x100) != 0;
        block.m_stringOffsets = reader.readIntArray(stringCount);
        if (styleCount != 0) {
            block.m_styleOffsets = reader.readIntArray(styleCount);
        }
        int size = (stylesOffset == 0 ? chunkSize : stylesOffset) - stringsOffset;
        block.m_strings = new byte[size];
        reader.readFully(block.m_strings);
        if (stylesOffset != 0) {
            size = chunkSize - stylesOffset;
            block.m_styles = reader.readIntArray(size / 4);
            int remaining = size % 4;
            if (remaining >= 1) {
                while (remaining-- > 0) {
                    reader.readByte();
                }
            }
        }
        return block;
    }

    public String getString(int index) {
        int[] val;
        if (index < 0 || this.m_stringOffsets == null || index >= this.m_stringOffsets.length) {
            return null;
        }
        int offset = this.m_stringOffsets[index];
        if (this.m_isUTF8) {
            val = StringBlock.getUtf8(this.m_strings, offset);
            offset = val[0];
        } else {
            val = StringBlock.getUtf16(this.m_strings, offset);
            offset += val[0];
        }
        int length = val[1];
        return this.decodeString(offset, length);
    }

    public String getHTML(int index) {
        String text = this.getString(index);
        if (text == null) {
            return null;
        }
        int[] style = this.getStyle(index);
        if (style == null) {
            return ResXmlEncoders.escapeXmlChars(text);
        }
        if (style[1] > text.length()) {
            return ResXmlEncoders.escapeXmlChars(text);
        }
        ArrayList<StyledString.Span> spans = new ArrayList<StyledString.Span>(style.length / 3);
        for (int i = 0; i < style.length; i += 3) {
            spans.add(new StyledString.Span(this.getString(style[i]), style[i + 1], style[i + 2]));
        }
        Collections.sort(spans);
        StyledString styledString = new StyledString(text, spans);
        return styledString.toString();
    }

    public int find(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i != this.m_stringOffsets.length; ++i) {
            int j;
            int offset = this.m_stringOffsets[i];
            int length = StringBlock.getShort(this.m_strings, offset);
            if (length != string.length()) continue;
            for (j = 0; j != length && string.charAt(j) == StringBlock.getShort(this.m_strings, offset += 2); ++j) {
            }
            if (j != length) continue;
            return i;
        }
        return -1;
    }

    private StringBlock() {
    }

    @VisibleForTesting
    StringBlock(byte[] strings, boolean isUTF8) {
        this.m_strings = strings;
        this.m_isUTF8 = isUTF8;
    }

    private int[] getStyle(int index) {
        int i;
        if (this.m_styleOffsets == null || this.m_styles == null || index >= this.m_styleOffsets.length) {
            return null;
        }
        int offset = this.m_styleOffsets[index] / 4;
        int count = 0;
        for (i = offset; i < this.m_styles.length && this.m_styles[i] != -1; ++i) {
            ++count;
        }
        if (count == 0 || count % 3 != 0) {
            return null;
        }
        int[] style = new int[count];
        i = offset;
        int j = 0;
        while (i < this.m_styles.length && this.m_styles[i] != -1) {
            style[j++] = this.m_styles[i++];
        }
        return style;
    }

    @VisibleForTesting
    String decodeString(int offset, int length) {
        try {
            ByteBuffer wrappedBuffer = ByteBuffer.wrap(this.m_strings, offset, length);
            return (this.m_isUTF8 ? this.UTF8_DECODER : this.UTF16LE_DECODER).decode(wrappedBuffer).toString();
        }
        catch (CharacterCodingException ex) {
            if (!this.m_isUTF8) {
                LOGGER.warning("Failed to decode a string at offset " + offset + " of length " + length);
                return null;
            }
            try {
                ByteBuffer wrappedBufferRetry = ByteBuffer.wrap(this.m_strings, offset, length);
                return this.CESU8_DECODER.decode(wrappedBufferRetry).toString();
            }
            catch (CharacterCodingException e) {
                LOGGER.warning("Failed to decode a string with CESU-8 decoder.");
                return null;
            }
        }
    }

    private static int getShort(byte[] array, int offset) {
        return (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
    }

    private static int[] getUtf8(byte[] array, int offset) {
        int length;
        int val = array[offset];
        offset = (val & 0x80) != 0 ? (offset += 2) : ++offset;
        val = array[offset];
        ++offset;
        if ((val & 0x80) != 0) {
            int low = array[offset] & 0xFF;
            length = ((val & 0x7F) << 8) + low;
        } else {
            length = val;
        }
        return new int[]{++offset, length};
    }

    private static int[] getUtf16(byte[] array, int offset) {
        int val = (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
        if ((val & 0x8000) != 0) {
            int high = (array[offset + 3] & 0xFF) << 8;
            int low = array[offset + 2] & 0xFF;
            int len_value = ((val & Short.MAX_VALUE) << 16) + (high + low);
            return new int[]{4, len_value * 2};
        }
        return new int[]{2, val * 2};
    }
}

