/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.apk;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class YamlStringEscapeUtils {
    public static String escapeString(String str) {
        return YamlStringEscapeUtils.escapeJavaStyleString(str);
    }

    private static String escapeJavaStyleString(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            YamlStringEscapeUtils.escapeJavaStyleString(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void escapeJavaStyleString(Writer out, String str) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block11: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\ufffd') {
                out.write("\\u" + CharSequenceTranslator.hex((int)ch));
                continue;
            }
            if (ch > '\ud7ff' && ch < '\ue000') {
                out.write("\\u" + CharSequenceTranslator.hex((int)ch));
                continue;
            }
            if (ch > '~' && ch != '\u0085' && ch < '\u00a0') {
                out.write("\\u00" + CharSequenceTranslator.hex((int)ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + CharSequenceTranslator.hex((int)ch));
                            break;
                        }
                        out.write("\\u000" + CharSequenceTranslator.hex((int)ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    out.write(39);
                    continue block11;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block11;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block11;
                }
                case '/': {
                    out.write(47);
                    continue block11;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    public static String unescapeString(String str) {
        return StringEscapeUtils.unescapeJava((String)str);
    }
}

