/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResResSpec;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ResTypeSpec {
    public static final String RES_TYPE_NAME_ARRAY = "array";
    public static final String RES_TYPE_NAME_ATTR = "attr";
    public static final String RES_TYPE_NAME_ATTR_PRIVATE = "^attr-private";
    public static final String RES_TYPE_NAME_PLURALS = "plurals";
    public static final String RES_TYPE_NAME_STRING = "string";
    public static final String RES_TYPE_NAME_STYLES = "style";
    private final String mName;
    private final Map<String, ResResSpec> mResSpecs = new LinkedHashMap<String, ResResSpec>();
    private final int mId;

    public ResTypeSpec(String name, int id) {
        this.mName = name;
        this.mId = id;
    }

    public String getName() {
        return this.mName;
    }

    public int getId() {
        return this.mId;
    }

    public boolean isString() {
        return this.mName.equalsIgnoreCase(RES_TYPE_NAME_STRING);
    }

    public ResResSpec getResSpec(String name) throws AndrolibException {
        ResResSpec spec = this.getResSpecUnsafe(name);
        if (spec == null) {
            throw new UndefinedResObjectException(String.format("resource spec: %s/%s", this.getName(), name));
        }
        return spec;
    }

    public ResResSpec getResSpecUnsafe(String name) {
        return this.mResSpecs.get(name);
    }

    public void addResSpec(ResResSpec spec) throws AndrolibException {
        if (this.mResSpecs.put(spec.getName(), spec) != null) {
            throw new AndrolibException(String.format("Multiple res specs: %s/%s", this.getName(), spec.getName()));
        }
    }

    public String toString() {
        return this.mName;
    }
}

